/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.recorders;

import edu.cmu.scs.fluorite.commands.CopyCommand;
import edu.cmu.scs.fluorite.commands.CutCommand;
import edu.cmu.scs.fluorite.commands.EclipseCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.PasteCommand;
import edu.cmu.scs.fluorite.commands.RedoCommand;
import edu.cmu.scs.fluorite.commands.UndoCommand;
import edu.cmu.scs.fluorite.recorders.BaseRecorder;
import edu.cmu.scs.fluorite.util.EventLoggerConsole;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class EclipseCommandRecorder
extends BaseRecorder
implements IExecutionListener {
    private static EclipseCommandRecorder instance = null;
    private Listener[] mPreexecuteListeners = null;
    private Set<String> mNonRecordableCommandIds = new HashSet<String>();
    private Map<String, String> mParameters;

    public static EclipseCommandRecorder getInstance() {
        if (instance == null) {
            instance = new EclipseCommandRecorder();
        }
        return instance;
    }

    private EclipseCommandRecorder() {
        this.mNonRecordableCommandIds.add("org.eclipse.ui.edit.findReplace");
        this.mNonRecordableCommandIds.add("eventlogger.actions.viewLastLog");
        this.mNonRecordableCommandIds.add("eventlogger.actions.annotateBackward");
        this.mNonRecordableCommandIds.add("eventlogger.actions.annotateForward");
        this.mParameters = new HashMap<String, String>();
    }

    @Override
    public void addListeners(IEditorPart editor) {
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (cs != null) {
            cs.addExecutionListener((IExecutionListener)this);
        }
    }

    @Override
    public void removeListeners(IEditorPart editor) {
        try {
            ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
            if (cs != null) {
                cs.removeExecutionListener((IExecutionListener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
        this.getRecorder().setCurrentlyExecutingCommand(false);
        this.getRecorder().endIncrementalFindMode();
        System.out.println("not handled: " + commandId);
        this.mParameters.clear();
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
        this.getRecorder().setCurrentlyExecutingCommand(false);
        this.getRecorder().endIncrementalFindMode();
        System.out.println("command failed: " + commandId);
        this.mParameters.clear();
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
        this.getRecorder().setCurrentlyExecutingCommand(false);
        this.getRecorder().endIncrementalFindMode();
        if (this.mNonRecordableCommandIds.contains(commandId)) {
            if (!commandId.equals("eventlogger.actions.recordMacro") && !commandId.equals("org.eclipse.ui.edit.findReplace")) {
                EventLoggerConsole.getConsole().writeln("Not recording command (it's in the exclude list): " + commandId, 1);
            }
            return;
        }
        if (commandId.equals("org.eclipse.ui.edit.findIncremental") || commandId.equals("org.eclipse.ui.edit.findIncrementalReverse")) {
            if (commandId.equals("org.eclipse.ui.edit.findIncremental")) {
                this.getRecorder().setIncrementalFindForward(true);
            } else {
                this.getRecorder().setIncrementalFindForward(false);
            }
            Listener[] currentListeners = Utilities.getStyledText(Utilities.getActiveEditor()).getListeners(4);
            this.getRecorder().setIncrementalListener(null);
            Listener[] listenerArray = currentListeners;
            int n = currentListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listenerBeforeFind;
                Listener listener = listenerArray[n2];
                boolean inCurrentList = false;
                Listener[] listenerArray2 = this.mPreexecuteListeners;
                if (this.mPreexecuteListeners.length != 0 && (listenerBeforeFind = listenerArray2[0]) == listener) {
                    inCurrentList = true;
                }
                if (!inCurrentList) {
                    this.getRecorder().setIncrementalListener(listener);
                }
                ++n2;
            }
        }
        this.getRecorder().updateIncrementalFindMode();
        if (!this.getRecorder().isIncrementalFindMode()) {
            this.getRecorder().recordCommand(this.createCommandByEclipseCommandId(commandId));
        }
        this.mParameters.clear();
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        this.getRecorder().setCurrentlyExecutingCommand(true);
        if (commandId.equals("org.eclipse.ui.edit.findIncremental") || commandId.equals("org.eclipse.ui.edit.findIncrementalReverse")) {
            this.getRecorder().setIncrementalFindMode(true);
            StyledText widget = Utilities.getStyledText(Utilities.getActiveEditor());
            if (widget != null) {
                this.mPreexecuteListeners = widget.getListeners(4);
            }
        }
        Map parameterMap = event.getParameters();
        for (Object key : parameterMap.keySet()) {
            this.mParameters.put(key.toString(), parameterMap.get(key).toString());
        }
    }

    private ICommand createCommandByEclipseCommandId(String commandId) {
        if (commandId.equals("org.eclipse.ui.edit.undo")) {
            return new UndoCommand();
        }
        if (commandId.equals("org.eclipse.ui.edit.redo")) {
            return new RedoCommand();
        }
        if (commandId.equals("org.eclipse.ui.edit.copy")) {
            return new CopyCommand();
        }
        if (commandId.equals("org.eclipse.ui.edit.cut")) {
            return new CutCommand();
        }
        if (commandId.equals("org.eclipse.ui.edit.paste")) {
            return new PasteCommand();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(this.mParameters);
        return new EclipseCommand(commandId, parameters);
    }
}

