/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.model;

import edu.cmu.scs.fluorite.commands.ICommand;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Events {
    private List<ICommand> mCommands = new ArrayList<ICommand>();
    private long mStartTimestamp;

    public Events(List<ICommand> commands, String id, String name, String desc) {
        this(commands, id, name, desc, 0L);
    }

    public Events(List<ICommand> commands, String id, String name, String desc, long startTimestamp) {
        this.mCommands.addAll(commands);
        this.mStartTimestamp = startTimestamp;
    }

    public void addCommand(ICommand command) {
        this.mCommands.add(command);
    }

    public boolean removeLastCommand() {
        if (this.hasEvents()) {
            this.mCommands.remove(this.mCommands.size() - 1);
            return true;
        }
        return false;
    }

    public boolean hasEvents() {
        return this.mCommands.size() > 0;
    }

    public void dump() {
        for (ICommand command : this.mCommands) {
            command.dump();
        }
    }

    public void persist(Document doc, Element macroElement) {
        macroElement.setAttribute("startTimestamp", Long.toString(this.getStartTimestamp()));
        for (ICommand command : this.mCommands) {
            try {
                String commandTag = command.getCommandTag();
                Element child = doc.createElement(commandTag);
                command.persist(doc, child);
                macroElement.appendChild(child);
            }
            catch (Exception exception) {}
        }
    }

    public List<ICommand> getCommands() {
        return this.mCommands;
    }

    public void copyFrom(Events existingMacro) {
        this.mCommands.clear();
        this.mCommands.addAll(existingMacro.mCommands);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Events)) {
            return false;
        }
        return ((Events)obj).getStartTimestamp() == this.getStartTimestamp();
    }

    public int hashCode() {
        return (int)this.getStartTimestamp();
    }

    public String toString() {
        return "Events, start timestamp: " + Long.toString(this.getStartTimestamp());
    }

    public long getStartTimestamp() {
        return this.mStartTimestamp;
    }
}

