/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands.document;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.ASTNode;

public class Range
implements ISourceRange {
    private final int offset;
    private final int length;

    public Range(ASTNode node) {
        this(node.getStartPosition(), node.getLength());
    }

    public Range(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public boolean contains(Range other) {
        return this.contains(other, true, true);
    }

    public boolean contains(Range other, boolean leftInclusive, boolean rightInclusive) {
        return this.contains(other.getOffset(), leftInclusive, rightInclusive) && this.contains(other.getEndOffset(), leftInclusive, rightInclusive);
    }

    public boolean contains(int offset) {
        return this.contains(offset, true, true);
    }

    public boolean contains(int offset, boolean leftInclusive, boolean rightInclusive) {
        if (offset == this.getOffset()) {
            return leftInclusive;
        }
        if (offset == this.getEndOffset()) {
            return rightInclusive;
        }
        return this.getOffset() < offset && offset < this.getEndOffset();
    }

    public static boolean overlap(Range r1, Range r2) {
        return r1.getEndOffset() >= r2.getOffset() && r2.getEndOffset() >= r1.getOffset();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.offset == other.offset;
    }
}

