/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.util;

import edu.cmu.scs.fluorite.util.Utilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class LogNormalizer {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String REPLACEMENT = "]]>&#13;<![CDATA[";
    private static final String OPENING_TAG = "<Events";
    private static final String CLOSING_TAG = "</Events>";
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");

    public static boolean normalizeLog(String logPath) {
        String content = Utilities.readFile(logPath);
        if (content == null) {
            return false;
        }
        content = LogNormalizer.normalizeContent(content);
        return LogNormalizer.writeFile(logPath, content);
    }

    public static String getNormalizedContentFromLog(String logPath) {
        return LogNormalizer.normalizeContent(Utilities.readFile(logPath));
    }

    public static String normalizeContent(String content) {
        if (content.trim().length() == 0) {
            return null;
        }
        String result = LogNormalizer.normalizeCarriageReturns(content);
        result = LogNormalizer.fixClosingTag(result);
        return result;
    }

    private static String normalizeCarriageReturns(String content) {
        StringBuffer buf = new StringBuffer(content);
        int pos = 0;
        int index = -1;
        while ((index = buf.indexOf(CDATA_START, pos)) != -1) {
            int start = index + CDATA_START.length();
            int end = buf.indexOf(CDATA_END, start);
            String replacement = buf.substring(start, end).replaceAll("\\r", REPLACEMENT);
            buf.replace(start, end, replacement);
            pos = start + replacement.length() + CDATA_END.length();
        }
        return buf.toString();
    }

    private static String fixClosingTag(String content) {
        String trimmed = content.trim();
        if (trimmed.startsWith(OPENING_TAG) && !trimmed.endsWith(CLOSING_TAG)) {
            String tail = String.valueOf(LINE_SEPERATOR) + CLOSING_TAG + LINE_SEPERATOR;
            return String.valueOf(trimmed) + tail;
        }
        return content;
    }

    static boolean writeFile(String filePath, String content) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8");
            writer.write(content);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

