/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.ITypeOverridable;
import edu.cmu.scs.fluorite.util.EventLoggerConsole;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class EclipseCommand
extends AbstractCommand
implements ITypeOverridable {
    public static final String XML_ID_ATTR = "commandID";
    private String mCommandId;
    private int mRepeatCount;
    private Map<String, String> mParameters;

    public EclipseCommand(String commandId, Map<String, String> parameters, int repeatCount) {
        this.mCommandId = commandId;
        this.mRepeatCount = repeatCount;
        this.mParameters = parameters != null ? new HashMap<String, String>(parameters) : new HashMap();
    }

    public EclipseCommand(String commandId, Map<String, String> parameters) {
        this(commandId, parameters, 1);
    }

    public EclipseCommand(String commandId) {
        this(commandId, null, 1);
    }

    public EclipseCommand() {
    }

    @Override
    public boolean execute(IEditorPart target) {
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Command command = cs.getCommand(this.mCommandId);
        if (command != null) {
            try {
                IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
                ExecutionEvent exEvent = hs.createExecutionEvent(command, null);
                int i = 0;
                while (i < this.mRepeatCount) {
                    if (command.getHandler() instanceof IHandler2) {
                        command.executeWithChecks(exEvent);
                    } else {
                        command.execute(exEvent);
                    }
                    ++i;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                EventLoggerConsole.getConsole().write(e, 2);
            }
        }
        return false;
    }

    @Override
    public void dump() {
        System.out.println("Eclipse Command: " + this.mCommandId + ", repeat: " + Integer.toString(this.mRepeatCount));
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_ID_ATTR, this.mCommandId);
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        return this.mParameters;
    }

    @Override
    public void createFrom(Element commandElement) {
        super.createFrom(commandElement);
        Attr attr = null;
        String value = null;
        attr = commandElement.getAttributeNode(XML_ID_ATTR);
        if (attr != null) {
            value = attr.getValue();
            this.mCommandId = attr.getValue().equals("null") ? null : value;
        }
    }

    @Override
    public String getCommandType() {
        return "EclipseCommand";
    }

    @Override
    public String getDescription() {
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Command command = cs.getCommand(this.mCommandId);
        try {
            String description = command.getDescription();
            if (description == null && (description = command.getName()) != null && description.endsWith("...")) {
                description = description.substring(0, description.length() - 3);
            }
            return description;
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getName() {
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Command command = cs.getCommand(this.mCommandId);
        try {
            return command.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return this.mCommandId;
        }
    }

    @Override
    public String getCategory() {
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Command command = cs.getCommand(this.mCommandId);
        try {
            Category cat = command.getCategory();
            if (cat != null) {
                return cat.getName();
            }
        }
        catch (NotDefinedException notDefinedException) {}
        return "";
    }

    @Override
    public String getCategoryID() {
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (cs == null) {
            return "";
        }
        Command command = cs.getCommand(this.mCommandId);
        try {
            Category cat = command.getCategory();
            if (cat != null) {
                return cat.getId();
            }
        }
        catch (NotDefinedException notDefinedException) {}
        return "";
    }

    public String getCommandID() {
        return this.mCommandId;
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        if (!(anotherCommand instanceof EclipseCommand)) {
            return false;
        }
        EclipseCommand nextCommand = (EclipseCommand)anotherCommand;
        return nextCommand.getCommandID().equals(this.getCommandID());
    }

    @Override
    public String getTypeForDisplay() {
        return this.getCommandID();
    }
}

