/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.recorders;

import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.MouseWheelCommand;
import edu.cmu.scs.fluorite.commands.MoveCaretCommand;
import edu.cmu.scs.fluorite.commands.SelectTextCommand;
import edu.cmu.scs.fluorite.plugin.Activator;
import edu.cmu.scs.fluorite.recorders.BaseRecorder;
import edu.cmu.scs.fluorite.util.Utilities;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class StyledTextEventRecorder
extends BaseRecorder
implements Listener {
    private static StyledTextEventRecorder instance;

    public static StyledTextEventRecorder getInstance() {
        if (instance == null) {
            instance = new StyledTextEventRecorder();
        }
        return instance;
    }

    private StyledTextEventRecorder() {
    }

    @Override
    public void addListeners(IEditorPart editor) {
        final StyledText styledText = Utilities.getStyledText(editor);
        if (styledText == null) {
            return;
        }
        styledText.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                StyledTextEventRecorder styledTextEventRecorder = StyledTextEventRecorder.getInstance();
                styledText.addListener(1, (Listener)styledTextEventRecorder);
                styledText.addListener(2, (Listener)styledTextEventRecorder);
                styledText.addListener(3, (Listener)styledTextEventRecorder);
                styledText.addListener(4, (Listener)styledTextEventRecorder);
                styledText.addListener(37, (Listener)styledTextEventRecorder);
            }
        });
    }

    @Override
    public void removeListeners(IEditorPart editor) {
        try {
            StyledText styledText = Utilities.getStyledText(editor);
            if (styledText != null) {
                styledText.removeListener(1, (Listener)this);
                styledText.removeListener(2, (Listener)this);
                styledText.removeListener(3, (Listener)this);
                styledText.removeListener(4, (Listener)this);
                styledText.removeListener(37, (Listener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isBound(Event event) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        KeyStroke k = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode);
        if (k == null) {
            return false;
        }
        Binding b = bindingService.getPerfectMatch((TriggerSequence)KeySequence.getInstance((KeyStroke)k));
        return b != null;
    }

    public void handleEvent(Event event) {
        this.getRecorder().updateIncrementalFindMode();
        switch (event.type) {
            case 1: {
                if (this.isBound(event)) {
                    return;
                }
                if (this.getRecorder().isAssistSession()) {
                    return;
                }
                ICommand command = Utilities.getCommandForKeyEvent(event);
                if (this.getRecorder().isIncrementalFindMode() || command == null) break;
                this.getRecorder().recordCommand(command);
                break;
            }
            case 4: {
                IEditorPart editor = Utilities.getActiveEditor();
                StyledText styledText = Utilities.getStyledText(editor);
                ISourceViewer viewer = Utilities.getSourceViewer(editor);
                if (styledText == null || viewer == null) break;
                if (styledText.getSelection().x != styledText.getSelection().y && (styledText.getSelection().x != this.getRecorder().getLastSelectionStart() || styledText.getSelection().y != this.getRecorder().getLastSelectionEnd())) {
                    int start = styledText.getSelection().x;
                    int end = styledText.getSelection().y;
                    int caretOffset = styledText.getCaretOffset();
                    ITextViewerExtension5 ext5 = Utilities.getTextViewerExtension5(editor);
                    int docStart = ext5.widgetOffset2ModelOffset(start);
                    int docEnd = ext5.widgetOffset2ModelOffset(end);
                    int docOffset = ext5.widgetOffset2ModelOffset(caretOffset);
                    SelectTextCommand command = new SelectTextCommand(start, end, caretOffset, docStart, docEnd, docOffset);
                    this.getRecorder().recordCommand(command);
                    break;
                }
                if (this.getRecorder().getLastCaretOffset() == styledText.getCaretOffset()) break;
                MoveCaretCommand command = new MoveCaretCommand(styledText.getCaretOffset(), viewer.getSelectedRange().x);
                this.getRecorder().recordCommand(command);
                break;
            }
            case 37: {
                if (!Activator.getDefault().getPreferenceStore().getBoolean("EventLogger_LogMouseWheel")) break;
                this.getRecorder().recordCommand(new MouseWheelCommand(event.count));
            }
        }
    }
}

