/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.dialogs;

import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.plugin.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class OptionsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button mEnableEventLogger;
    private Button mShowConsole;
    private Button mWriteToConsole;
    private Button mCombineCommands;
    private Text mCombineThreshold;
    private Button mLogInsertedText;
    private Button mLogDeletedText;
    private Button mLogTopBottomLines;
    private Button mLogMouseWheel;
    private Button mLogSeparateLines;

    public OptionsPage() {
    }

    public OptionsPage(String title) {
        super(title);
    }

    public OptionsPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "EventLogger.overallHelp");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.mEnableEventLogger = new Button(comp, 32);
        this.mEnableEventLogger.setText("Enable EventLogger plugin (restart needed)");
        this.mEnableEventLogger.setSelection(store.getBoolean("EventLogger_EnableEventLogger"));
        this.mShowConsole = new Button(comp, 32);
        this.mShowConsole.setText("Show console");
        this.mShowConsole.setToolTipText("If set, make the console visible during command log.");
        this.mShowConsole.setSelection(store.getBoolean("EventLogger_ShowConsole"));
        this.mWriteToConsole = new Button(comp, 32);
        this.mWriteToConsole.setText("Write to console");
        this.mWriteToConsole.setToolTipText("If set, write normal execution trace statements to the console during command log.");
        this.mWriteToConsole.setSelection(store.getBoolean("EventLogger_WriteToConsole"));
        this.mCombineCommands = new Button(comp, 32);
        this.mCombineCommands.setText("Combine multiple commands of same type");
        this.mCombineCommands.setSelection(store.getBoolean("EventLogger_CombineCommands"));
        Composite compCombine = new Composite(comp, 0);
        compCombine.setLayout((Layout)new GridLayout(2, false));
        compCombine.setLayoutData((Object)new GridData(768));
        Label label = new Label(compCombine, 0);
        label.setText("Command combine time threshold (in milliseconds)");
        this.mCombineThreshold = new Text(compCombine, 2048);
        this.mCombineThreshold.setText(Integer.toString(store.getInt("EventLogger_CombineTimeThreshold")));
        this.mLogInsertedText = new Button(comp, 32);
        this.mLogInsertedText.setText("Log Inserted Text");
        this.mLogInsertedText.setSelection(store.getBoolean("EventLogger_LogInsertedText"));
        this.mLogDeletedText = new Button(comp, 32);
        this.mLogDeletedText.setText("Log Deleted Text");
        this.mLogDeletedText.setSelection(store.getBoolean("EventLogger_LogDeletedText"));
        this.mLogTopBottomLines = new Button(comp, 32);
        this.mLogTopBottomLines.setText("Log top / bottom line numbers shown on the screen");
        this.mLogTopBottomLines.setSelection(store.getBoolean("EventLogger_LogTopBottomLines"));
        this.mLogMouseWheel = new Button(comp, 32);
        this.mLogMouseWheel.setText("Log mouse wheels");
        this.mLogMouseWheel.setSelection(store.getBoolean("EventLogger_LogMouseWheel"));
        this.mLogSeparateLines = new Button(comp, 32);
        this.mLogSeparateLines.setText("Log separate lines when a large chunk of code is inserted");
        this.mLogSeparateLines.setSelection(store.getBoolean("EventLogger_LogSeparateLines"));
        return comp;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue("EventLogger_EnableEventLogger", this.mEnableEventLogger.getSelection());
        store.setValue("EventLogger_ShowConsole", this.mShowConsole.getSelection());
        store.setValue("EventLogger_WriteToConsole", this.mWriteToConsole.getSelection());
        store.setValue("EventLogger_CombineCommands", this.mCombineCommands.getSelection());
        store.setValue("EventLogger_CombineTimeThreshold", Integer.parseInt(this.mCombineThreshold.getText()));
        EventRecorder.getInstance().setCombineCommands(this.mCombineCommands.getSelection());
        EventRecorder.getInstance().setCombineTimeThreshold(Integer.parseInt(this.mCombineThreshold.getText()));
        store.setValue("EventLogger_LogInsertedText", this.mLogInsertedText.getSelection());
        store.setValue("EventLogger_LogDeletedText", this.mLogDeletedText.getSelection());
        store.setValue("EventLogger_LogTopBottomLines", this.mLogTopBottomLines.getSelection());
        store.setValue("EventLogger_LogMouseWheel", this.mLogMouseWheel.getSelection());
        store.setValue("EventLogger_LogSeparateLines", this.mLogSeparateLines.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.mEnableEventLogger.setSelection(store.getDefaultBoolean("EventLogger_EnableEventLogger"));
        this.mShowConsole.setSelection(store.getDefaultBoolean("EventLogger_ShowConsole"));
        this.mWriteToConsole.setSelection(store.getDefaultBoolean("EventLogger_WriteToConsole"));
        this.mCombineCommands.setSelection(store.getDefaultBoolean("EventLogger_CombineCommands"));
        this.mCombineThreshold.setText(Integer.toString(store.getDefaultInt("EventLogger_CombineTimeThreshold")));
        this.mLogInsertedText.setSelection(store.getDefaultBoolean("EventLogger_LogInsertedText"));
        this.mLogDeletedText.setSelection(store.getDefaultBoolean("EventLogger_LogDeletedText"));
        this.mLogTopBottomLines.setSelection(store.getDefaultBoolean("EventLogger_LogTopBottomLines"));
        this.mLogMouseWheel.setSelection(store.getDefaultBoolean("EventLogger_LogMouseWheel"));
        this.mLogSeparateLines.setSelection(store.getDefaultBoolean("EventLogger_LogSeparateLines"));
        super.performDefaults();
    }
}

