/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class MoveCaretCommand
extends AbstractCommand {
    private int mCaretOffset;
    private int mDocOffset;

    public MoveCaretCommand() {
    }

    public MoveCaretCommand(int caretOffset, int docOffset) {
        this.mCaretOffset = caretOffset;
        this.mDocOffset = docOffset;
    }

    @Override
    public boolean execute(IEditorPart target) {
        StyledText styledText = Utilities.getStyledText(target);
        if (styledText == null) {
            return false;
        }
        styledText.setCaretOffset(this.mCaretOffset);
        return true;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("caretOffset", Integer.toString(this.mCaretOffset));
        attrMap.put("docOffset", Integer.toString(this.mDocOffset));
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        return null;
    }

    @Override
    public void createFrom(Element commandElement) {
        super.createFrom(commandElement);
        Attr attr = null;
        attr = commandElement.getAttributeNode("caretOffset");
        if (attr != null) {
            this.mCaretOffset = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("docOffset")) != null) {
            this.mDocOffset = Integer.parseInt(attr.getValue());
        }
    }

    @Override
    public String getCommandType() {
        return "MoveCaretCommand";
    }

    @Override
    public String getName() {
        return "Move Caret (caret offset: " + this.mCaretOffset + ", document offset: " + this.mDocOffset + ")";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        return false;
    }
}

