/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.util;

import edu.cmu.scs.fluorite.commands.EclipseCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.ITreeDataCommand;
import edu.cmu.scs.fluorite.commands.InsertStringCommand;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.plugin.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ST;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Utilities {
    private static Map<Integer, Command> mFillInCommands = new HashMap<Integer, Command>();
    public static final String FillInPrefix = "eventLogger.styledTextCommand";
    public static String NewLine = System.getProperty("line.separator");
    private static Set<String> mEditCategories = new HashSet<String>();

    static {
        mEditCategories.add("org.eclipse.ui.category.edit");
        mEditCategories.add("org.eclipse.ui.category.textEditor");
        mEditCategories.add("org.eclipse.jdt.ui.category.source");
        mEditCategories.add("org.eclipse.jdt.ui.category.refactoring");
        mEditCategories.add("eventlogger.category.utility.command");
        mEditCategories.add("eclipse.ui.category.navigate");
        mEditCategories.add(FillInPrefix);
    }

    public static IEditorPart getActiveEditor() {
        IEditorPart editor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            editor = page.getActiveEditor();
        }
        return editor;
    }

    public static ISourceViewer getSourceViewer(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        return viewer;
    }

    public static Font getFont() {
        IEditorPart editor = EventRecorder.getInstance().getEditor();
        if (editor == null) {
            return null;
        }
        StyledText styledText = Utilities.getStyledText(editor);
        if (styledText == null) {
            return null;
        }
        return styledText.getFont();
    }

    public static StyledText getStyledText(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        StyledText styledText = null;
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        if (viewer != null) {
            styledText = viewer.getTextWidget();
        }
        return styledText;
    }

    public static IDocument getDocument(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IDocument doc = null;
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        if (viewer != null) {
            doc = viewer.getDocument();
        }
        return doc;
    }

    public static ISourceViewerExtension3 getSourceViewerExtension3(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        if (viewer instanceof ISourceViewerExtension3) {
            return (ISourceViewerExtension3)viewer;
        }
        return null;
    }

    public static ISourceViewerExtension4 getSourceViewerExtension4(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ISourceViewer viewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        if (viewer instanceof ISourceViewerExtension4) {
            return (ISourceViewerExtension4)viewer;
        }
        return null;
    }

    public static ITextViewerExtension5 getTextViewerExtension5(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        ITextViewer viewer = (ITextViewer)editor.getAdapter(ITextOperationTarget.class);
        if (viewer instanceof ITextViewerExtension5) {
            return (ITextViewerExtension5)viewer;
        }
        return null;
    }

    public static Command getStyledTextCommand(int styledTextCode) {
        if (mFillInCommands.size() == 0) {
            Utilities.createStyledTextCommands();
        }
        return mFillInCommands.get(styledTextCode);
    }

    public static void createStyledTextCommands() {
        if (mFillInCommands.size() > 0) {
            return;
        }
        String[] styledTextConstantStrings = new String[]{"DELETE_PREVIOUS", "LINE_DOWN", "SELECT_WORD_PREVIOUS", "WORD_PREVIOUS", "SELECT_COLUMN_PREVIOUS", "COLUMN_PREVIOUS", "SELECT_WORD_NEXT", "WORD_NEXT", "SELECT_COLUMN_NEXT", "COLUMN_NEXT", "LINE_UP", "SELECT_TEXT_START", "TEXT_START", "SELECT_LINE_START", "LINE_START", "SELECT_TEXT_END", "TEXT_END", "SELECT_LINE_END", "LINE_END", "SELECT_WINDOW_END", "WINDOW_END", "SELECT_PAGE_DOWN", "PAGE_DOWN", "SELECT_WINDOW_START", "WINDOW_START", "SELECT_PAGE_UP", "PAGE_UP", "DELETE_WORD_NEXT", "CUT", "DELETE_NEXT", "COPY", "PASTE", "TOGGLE_OVERWRITE", "SELECT_LINE_DOWN", "SELECT_LINE_UP"};
        ICommandService cs = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Category cat = cs.getCategory(FillInPrefix);
        cat.define("Styled Text Commands", "");
        int i = 0;
        while (i < styledTextConstantStrings.length) {
            int constant = 0;
            boolean success = false;
            try {
                constant = ST.class.getField(styledTextConstantStrings[i]).getInt(null);
                success = true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            if (success) {
                Command newCommand = cs.getCommand("eventLogger.styledTextCommand." + styledTextConstantStrings[i]);
                newCommand.define(Utilities.getNameForStyledTextConstant(constant), "", cat);
                newCommand.setHandler((IHandler)new StyledTextHandler(constant));
                mFillInCommands.put(constant, newCommand);
            }
            ++i;
        }
    }

    public static ICommand getCommandForKeyEvent(Event event) {
        int key = 0x100FFFF & event.keyCode;
        if (key != 0 && !Character.isISOControl(event.character)) {
            return new InsertStringCommand(new String(new char[]{event.character}));
        }
        boolean isMod1 = (event.stateMask & SWT.MOD1) > 0;
        boolean isMod2 = (event.stateMask & SWT.MOD2) > 0;
        switch (key) {
            case 8: {
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(262152).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(8).getId());
            }
            case 0x1000002: {
                if (!isMod1 && isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1020002).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000002).getId());
            }
            case 0x1000003: {
                if (isMod1 && isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170435).getId());
                }
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039363).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908291).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000003).getId());
            }
            case 0x1000004: {
                if (isMod1 && isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170436).getId());
                }
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1040004).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908292).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000004).getId());
            }
            case 0x1000001: {
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1020001).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000001).getId());
            }
            case 0x1000007: {
                if (isMod1 && isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170439).getId());
                }
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039367).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908295).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000007).getId());
            }
            case 0x1000008: {
                if (isMod1 && isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170440).getId());
                }
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039368).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908296).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000008).getId());
            }
            case 0x1000006: {
                if (isMod1 && isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(0x1060006).getId());
                }
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039366).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908294).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000006).getId());
            }
            case 0x1000005: {
                if (isMod1 && isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17170437).getId());
                }
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039365).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908293).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000005).getId());
            }
            case 127: {
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(262271).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(131199).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(127).getId());
            }
            case 0x1000009: {
                if (isMod1) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(17039369).getId());
                }
                if (isMod2) {
                    return new EclipseCommand(Utilities.getStyledTextCommand(16908297).getId());
                }
                return new EclipseCommand(Utilities.getStyledTextCommand(0x1000009).getId());
            }
        }
        if (key == 13 || key == 10) {
            return new InsertStringCommand(new String(new char[]{(char)key}));
        }
        if (key == 9) {
            return new InsertStringCommand(new String(new char[]{(char)key}));
        }
        return null;
    }

    public static String getNameForStyledTextConstant(int constant) {
        switch (constant) {
            case 8: {
                return "Delete previous character";
            }
            case 0x1000002: {
                return "Move cursor down";
            }
            case 17170435: {
                return "Select previous word";
            }
            case 17039363: {
                return "Move cursor to previous word";
            }
            case 16908291: {
                return "Select previous character";
            }
            case 0x1000003: {
                return "Move cursor left";
            }
            case 17170436: {
                return "Select next word";
            }
            case 0x1040004: {
                return "Move cursor to next word";
            }
            case 16908292: {
                return "Select next character";
            }
            case 0x1000004: {
                return "Move cursor right";
            }
            case 0x1000001: {
                return "Move cursor up";
            }
            case 17170439: {
                return "Select to start of document";
            }
            case 17039367: {
                return "Move cursor to start of document";
            }
            case 16908295: {
                return "Select to line start";
            }
            case 0x1000007: {
                return "Move cursor to line start";
            }
            case 17170440: {
                return "Select to end of document";
            }
            case 17039368: {
                return "Move cursor to end of document";
            }
            case 16908296: {
                return "Select to end of line";
            }
            case 0x1000008: {
                return "Move cursor to end of line";
            }
            case 0x1060006: {
                return "Select to window end";
            }
            case 17039366: {
                return "Move cursor to window end";
            }
            case 16908294: {
                return "Select page down";
            }
            case 0x1000006: {
                return "Move cursor down a page";
            }
            case 17170437: {
                return "Select to window start";
            }
            case 17039365: {
                return "Move cursor to window start";
            }
            case 16908293: {
                return "Select page up";
            }
            case 0x1000005: {
                return "Move cursor up a page";
            }
            case 262271: {
                return "Delete next word";
            }
            case 131199: {
                return "Cut";
            }
            case 127: {
                return "Delete next character";
            }
            case 17039369: {
                return "Copy";
            }
            case 16908297: {
                return "Paste";
            }
            case 0x1000009: {
                return "Toggle overwrite mode";
            }
            case 0x1020002: {
                return "Select line down";
            }
            case 0x1020001: {
                return "Select line up";
            }
        }
        return "Unknown constant";
    }

    public static boolean isEditCategory(String categoryID) {
        System.out.println("category test:" + categoryID);
        return mEditCategories.contains(categoryID);
    }

    public static IFindReplaceTarget getFindReplaceTarget(IEditorPart editor) {
        IFindReplaceTarget target = (IFindReplaceTarget)editor.getAdapter(IFindReplaceTarget.class);
        return target;
    }

    public static String persistCommand(Map<String, String> attrs, Map<String, String> data, ICommand command) {
        boolean treeDataExists;
        StringBuffer buf = new StringBuffer();
        buf.append("  <" + command.getCommandTag());
        if (attrs == null) {
            attrs = new HashMap<String, String>();
        }
        attrs.put("__id", Integer.toString(command.getCommandIndex()));
        attrs.put("_type", command.getCommandType());
        attrs.put("timestamp", Long.toString(command.getTimestamp()));
        if (command.getRepeatCount() > 1) {
            attrs.put("timestamp2", Long.toString(command.getTimestamp2()));
            attrs.put("repeat", Integer.toString(command.getRepeatCount()));
        }
        if (command.areTopBottomLinesRecorded()) {
            attrs.put("topLine", Integer.toString(command.getTopLineNumber()));
            attrs.put("bottomLine", Integer.toString(command.getBottomLineNumber()));
        }
        TreeSet<String> sortedAttrKeys = new TreeSet<String>(attrs.keySet());
        for (String attrKey : sortedAttrKeys) {
            String attrValue = attrs.get(attrKey);
            buf.append(" " + attrKey + "=\"" + attrValue + "\"");
        }
        boolean bl = treeDataExists = command instanceof ITreeDataCommand && ((ITreeDataCommand)command).getRootElement() != null;
        if (!(data != null && data.size() != 0 || treeDataExists)) {
            buf.append(" />" + NewLine);
        } else {
            buf.append(">" + NewLine);
            if (data != null) {
                for (String dataKey : data.keySet()) {
                    String dataValue = data.get(dataKey);
                    buf.append("    <" + dataKey + ">");
                    String adjustedDataValue = dataValue.replace("]]>", "]]]]><![CDATA[>");
                    buf.append("<![CDATA[" + adjustedDataValue + "]]>");
                    buf.append("</" + dataKey + ">" + NewLine);
                }
            }
            if (treeDataExists) {
                ITreeDataCommand treeCommand = (ITreeDataCommand)command;
                Utilities.writeTreeData(buf, 2, treeCommand.getRootElement(), treeCommand);
            }
            buf.append("  </" + command.getCommandTag() + ">" + NewLine);
        }
        return buf.toString();
    }

    private static void writeTreeData(StringBuffer buf, int indentLevel, Object element, ITreeDataCommand treeCommand) {
        if (element == null) {
            return;
        }
        int i = 0;
        while (i < indentLevel) {
            buf.append("  ");
            ++i;
        }
        String tagName = treeCommand.getTagName(element);
        buf.append("<" + tagName);
        Map<String, String> attrMap = treeCommand.getAttrMap(element);
        for (String attrKey : attrMap.keySet()) {
            buf.append(" " + attrKey + "=\"" + attrMap.get(attrKey) + "\"");
        }
        Object[] children = treeCommand.getChildren(element);
        if (children != null && children.length > 0) {
            buf.append(">" + NewLine);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object childElement = objectArray[n2];
                Utilities.writeTreeData(buf, indentLevel + 1, childElement, treeCommand);
                ++n2;
            }
            int i2 = 0;
            while (i2 < indentLevel) {
                buf.append("  ");
                ++i2;
            }
            buf.append("</" + tagName + ">" + NewLine);
        } else {
            buf.append(" />" + NewLine);
        }
    }

    public static void persistCommand(Document doc, Element commandElement, String type, Map<String, String> attrs, Map<String, String> data, ICommand command) {
        commandElement.setAttribute("__id", Integer.toString(command.getCommandIndex()));
        commandElement.setAttribute("_type", type);
        commandElement.setAttribute("timestamp", Long.toString(command.getTimestamp()));
        if (command.getRepeatCount() > 1) {
            commandElement.setAttribute("timestamp2", Long.toString(command.getTimestamp2()));
            commandElement.setAttribute("repeat", Integer.toString(command.getRepeatCount()));
        }
        if (attrs != null) {
            for (String attr : attrs.keySet()) {
                commandElement.setAttribute(attr, attrs.get(attr));
            }
        }
        if (data != null) {
            for (String dataTag : data.keySet()) {
                String dataContent = data.get(dataTag);
                Element dataChild = doc.createElement(dataTag);
                CDATASection cdataContent = doc.createCDATASection(dataContent);
                commandElement.appendChild(dataChild);
                dataChild.appendChild(cdataContent);
            }
        }
    }

    public static void getCommandData(Element commandElement, Set<String> attrKeys, Set<String> dataKeys, Map<String, String> attrMap, Map<String, String> dataMap) {
        if (attrMap != null) {
            for (String attrName : attrKeys) {
                String attrValue = commandElement.getAttribute(attrName);
                attrMap.put(attrName, attrValue);
            }
        }
        if (dataMap != null) {
            NodeList children = commandElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                String tagName = children.item(i).getNodeName();
                if (dataKeys.contains(tagName)) {
                    String data = children.item(i).getTextContent();
                    dataMap.put(tagName, data);
                }
                ++i;
            }
        }
    }

    public static IDocument getIDocumentForEditor(IEditorPart editor) {
        TextFileDocumentProvider textFileDocumentProvider = new TextFileDocumentProvider();
        try {
            textFileDocumentProvider.connect((Object)editor.getEditorInput());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        IDocument document = textFileDocumentProvider.getDocument((Object)editor.getEditorInput());
        textFileDocumentProvider.disconnect((Object)editor.getEditorInput());
        return document;
    }

    public static boolean isSupportCategory(String categoryID) {
        return categoryID.equals("eventlogger.category.utility.command");
    }

    public static IPreferenceStore getMainPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static String getFilePathFromEditor(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                return fileInput.getFile().getLocation().toOSString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static File getLogLocation() throws Exception {
        File logLocation = Activator.getDefault().getStateLocation().append("Logs").toFile();
        if (!logLocation.exists() && !logLocation.mkdirs()) {
            throw new Exception("Could not make log directory!");
        }
        return logLocation;
    }

    public static String getUniqueLogNameByTimestamp(long timestamp, boolean autosave) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
        return "Log" + format.format(new Date(timestamp)) + (autosave ? "-Autosave" : "") + ".xml";
    }

    public static String readFile(String filePath) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8");
            StringBuffer buf = new StringBuffer();
            while (reader.ready()) {
                char[] charBuf = new char[1024];
                int count = reader.read(charBuf, 0, charBuf.length);
                buf.append(new String(charBuf, 0, count));
            }
            reader.close();
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    static class StyledTextHandler
    implements IHandler {
        private int mStyledTextAction;

        public StyledTextHandler(int styledTextConstant) {
            this.mStyledTextAction = styledTextConstant;
        }

        public void addHandlerListener(IHandlerListener handlerListener) {
        }

        public void dispose() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            IEditorPart target = Utilities.getActiveEditor();
            Utilities.getStyledText(target).invokeAction(this.mStyledTextAction);
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isHandled() {
            return true;
        }

        public void removeHandlerListener(IHandlerListener handlerListener) {
        }
    }
}

