/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.util;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.AnnotateCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.model.Events;
import edu.cmu.scs.fluorite.util.IFilter;
import edu.cmu.scs.fluorite.util.LogNormalizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LogReader {
    public static final String CHARSET = "UTF-8";

    public Events readAll(String logPath) {
        return this.readFilter(logPath, null);
    }

    public Events readDocumentChanges(String logPath) {
        return this.readFilter(logPath, new IFilter(){

            @Override
            public boolean filter(Element element) {
                return LogReader.isCommandTyped(element, "FileOpenCommand") || LogReader.isDocumentChange(element);
            }
        });
    }

    public Events readFilter(String logPath, IFilter filter) {
        String normalizedContent;
        DocumentBuilder dBuilder;
        Document doc;
        ArrayList<ICommand> result;
        block15: {
            if (logPath == null) {
                throw new IllegalArgumentException();
            }
            result = new ArrayList<ICommand>();
            doc = null;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dBuilder = dbFactory.newDocumentBuilder();
            normalizedContent = LogNormalizer.getNormalizedContentFromLog(logPath);
            if (normalizedContent != null) break block15;
            return null;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(normalizedContent.getBytes(CHARSET));
            doc = dBuilder.parse(is);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element root = doc.getDocumentElement();
        long startTimestamp = -1L;
        Attr attr = root.getAttributeNode("startTimestamp");
        if (attr != null) {
            try {
                startTimestamp = Long.parseLong(attr.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        boolean prevState = AbstractCommand.getIncrementCommandID();
        try {
            AbstractCommand.setIncrementCommandID(false);
            Node node = root.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Element child = (Element)node;
                    if (filter == null || filter.filter(child)) {
                        ICommand command = LogReader.parse(child);
                        command.setSessionId(startTimestamp);
                        result.add(command);
                    }
                }
                node = node.getNextSibling();
            }
        }
        finally {
            AbstractCommand.setIncrementCommandID(prevState);
        }
        return new Events(result, "", Long.toString(startTimestamp), "", startTimestamp);
    }

    public static boolean isCommandTyped(Element element, String typeName) {
        return LogReader.isCommand(element) && LogReader.isType(element, typeName);
    }

    private static boolean isType(Element element, String typeName) {
        Attr attr = element.getAttributeNode("_type");
        return attr != null && attr.getValue().equals(typeName);
    }

    private static boolean isCommand(Element element) {
        return element.getTagName().equals("Command");
    }

    private static boolean isDocumentChange(Element element) {
        return element.getTagName().equals("DocumentChange");
    }

    private static boolean isAnnotation(Element element) {
        return element.getTagName().equals("Annotation");
    }

    private static ICommand parse(Element element) {
        if (LogReader.isCommand(element) || LogReader.isDocumentChange(element)) {
            String typeName = element.getAttribute("_type");
            if (typeName == null) {
                throw new IllegalArgumentException();
            }
            Package commandsPackage = ICommand.class.getPackage();
            String fullyQualifiedName = String.valueOf(commandsPackage.getName()) + (LogReader.isDocumentChange(element) ? ".document." : ".") + typeName;
            try {
                Class<?> c = Class.forName(fullyQualifiedName);
                ICommand command = (ICommand)c.newInstance();
                command.createFrom(element);
                return command;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            if (LogReader.isAnnotation(element)) {
                AnnotateCommand annotateCommand = new AnnotateCommand();
                annotateCommand.createFrom(element);
                return annotateCommand;
            }
            throw new IllegalArgumentException();
        }
        return null;
    }
}

