/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.model;

import edu.cmu.scs.fluorite.actions.FindAction;
import edu.cmu.scs.fluorite.commands.FileOpenCommand;
import edu.cmu.scs.fluorite.commands.FindCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.MoveCaretCommand;
import edu.cmu.scs.fluorite.commands.SelectTextCommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.model.CommandExecutionListener;
import edu.cmu.scs.fluorite.model.DocumentChangeListener;
import edu.cmu.scs.fluorite.model.Events;
import edu.cmu.scs.fluorite.model.FileSnapshotManager;
import edu.cmu.scs.fluorite.model.FluoriteXMLFormatter;
import edu.cmu.scs.fluorite.plugin.Activator;
import edu.cmu.scs.fluorite.recorders.CompletionRecorder;
import edu.cmu.scs.fluorite.recorders.DocumentRecorder;
import edu.cmu.scs.fluorite.recorders.EclipseCommandRecorder;
import edu.cmu.scs.fluorite.recorders.JUnitRecorder;
import edu.cmu.scs.fluorite.recorders.PartRecorder;
import edu.cmu.scs.fluorite.recorders.RunRecorder;
import edu.cmu.scs.fluorite.recorders.StyledTextEventRecorder;
import edu.cmu.scs.fluorite.util.EventLoggerConsole;
import edu.cmu.scs.fluorite.util.Utilities;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventRecorder {
    public static final String MacroCommandCategory = "EventLogger utility command";
    public static final String MacroCommandCategoryID = "eventlogger.category.utility.command";
    public static final String UserMacroCategoryID = "eventlogger.category.usermacros";
    public static final String UserMacroCategoryName = "User defined editor macros";
    public static final String AnnotationCategory = "Annotation";
    public static final String AnnotationCategoryID = "eventlogger.category.annotation";
    public static final String DocumentChangeCategory = "Every document changes";
    public static final String DocumentChangeCategoryID = "eventlogger.category.documentChange";
    public static final String XML_Macro_Tag = "Events";
    public static final String XML_ID_Tag = "__id";
    public static final String XML_Description_Tag = "description";
    public static final String XML_Command_Tag = "Command";
    public static final String XML_DocumentChange_Tag = "DocumentChange";
    public static final String XML_Annotation_Tag = "Annotation";
    public static final String XML_CommandType_ATTR = "_type";
    public static final String PREF_USER_MACRO_DEFINITIONS = "Preference_UserMacroDefinitions";
    private IEditorPart mEditor = null;
    private LinkedList<ICommand> mCommands;
    private LinkedList<ICommand> mNormalCommands;
    private LinkedList<ICommand> mDocumentChangeCommands;
    private boolean mCurrentlyExecutingCommand;
    private boolean mRecordCommands;
    private IAction mSavedFindAction;
    private int mLastCaretOffset;
    private int mLastSelectionStart;
    private int mLastSelectionEnd;
    private long mStartTimestamp;
    private boolean mStarted = false;
    private boolean mAssistSession = false;
    private boolean mCombineCommands;
    private boolean mNormalCommandCombinable;
    private boolean mDocChangeCombinable;
    private int mCombineTimeThreshold;
    private DocChange mLastFiredDocumentChange;
    private Timer mTimer;
    private TimerTask mNormalTimerTask;
    private TimerTask mDocChangeTimerTask;
    private ListenerList mDocumentChangeListeners = new ListenerList();
    private ListenerList mCommandExecutionListeners = new ListenerList();
    private List<Runnable> mScheduledTasks;
    private FileSnapshotManager mFileSnapshotManager;
    private static EventRecorder instance = null;
    private static final Logger LOGGER = Logger.getLogger(EventRecorder.class.getName());
    private boolean mIncrementalFindMode = false;
    private boolean mIncrementalFindForward = true;
    private Listener mIncrementalListener = null;

    public static EventRecorder getInstance() {
        if (instance == null) {
            instance = new EventRecorder();
        }
        return instance;
    }

    private EventRecorder() {
        this.mTimer = new Timer();
        this.mScheduledTasks = new ArrayList<Runnable>();
        this.mFileSnapshotManager = new FileSnapshotManager();
    }

    public void setCurrentlyExecutingCommand(boolean executingCommand) {
        this.mCurrentlyExecutingCommand = executingCommand;
    }

    public boolean isCurrentlyExecutingCommand() {
        return this.mCurrentlyExecutingCommand;
    }

    public void setIncrementalFindForward(boolean incrementalFindForward) {
        this.mIncrementalFindForward = incrementalFindForward;
    }

    public boolean isIncrementalFindForward() {
        return this.mIncrementalFindForward;
    }

    public void setIncrementalFindMode(boolean incrementalFindMode) {
        this.mIncrementalFindMode = incrementalFindMode;
    }

    public boolean isIncrementalFindMode() {
        return this.mIncrementalFindMode;
    }

    public void setIncrementalListener(Listener incrementalListener) {
        this.mIncrementalListener = incrementalListener;
    }

    public int getLastCaretOffset() {
        return this.mLastCaretOffset;
    }

    public int getLastSelectionStart() {
        return this.mLastSelectionStart;
    }

    public int getLastSelectionEnd() {
        return this.mLastSelectionEnd;
    }

    public void setAssistSession(boolean assistSession) {
        this.mAssistSession = assistSession;
    }

    public boolean isAssistSession() {
        return this.mAssistSession;
    }

    public void addDocumentChangeListener(DocumentChangeListener docChangeListener) {
        this.mDocumentChangeListeners.add((Object)docChangeListener);
    }

    public void removeDocumentChangeListener(DocumentChangeListener docChangeListener) {
        this.mDocumentChangeListeners.remove((Object)docChangeListener);
    }

    public void addCommandExecutionListener(CommandExecutionListener cmdExecListener) {
        this.mCommandExecutionListeners.add((Object)cmdExecListener);
    }

    public void removeCommandExecutionListener(CommandExecutionListener cmdExecListener) {
        this.mCommandExecutionListeners.remove((Object)cmdExecListener);
    }

    public void setCombineCommands(boolean enabled) {
        this.mCombineCommands = enabled;
    }

    public boolean getCombineCommands() {
        return this.mCombineCommands;
    }

    public void setCombineTimeThreshold(int newThreshold) {
        this.mCombineTimeThreshold = newThreshold;
    }

    public int getCombineTimeThreshold() {
        return this.mCombineTimeThreshold;
    }

    private Timer getTimer() {
        return this.mTimer;
    }

    public FileSnapshotManager getFileSnapshotManager() {
        return this.mFileSnapshotManager;
    }

    public void fireActiveFileChangedEvent(FileOpenCommand foc) {
        Object[] objectArray = this.mDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((DocumentChangeListener)listenerObj).activeFileChanged(foc);
            ++n2;
        }
    }

    public void fireDocumentChangedEvent(DocChange docChange) {
        Object[] objectArray = this.mDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((DocumentChangeListener)listenerObj).documentChanged(docChange);
            ++n2;
        }
    }

    public void fireCommandExecutedEvent(ICommand command) {
        Object[] objectArray = this.mCommandExecutionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((CommandExecutionListener)listenerObj).commandExecuted(command);
            ++n2;
        }
    }

    public void fireLastDocumentChangeFinalizedEvent() {
        if (this.mDocumentChangeCommands != null && this.mDocumentChangeCommands.size() > 0) {
            this.fireDocumentChangeFinalizedEvent((DocChange)this.mDocumentChangeCommands.get(this.mDocumentChangeCommands.size() - 1));
        }
    }

    public synchronized void fireDocumentChangeFinalizedEvent(DocChange docChange) {
        if (docChange instanceof FileOpenCommand) {
            return;
        }
        if (docChange == this.mLastFiredDocumentChange) {
            return;
        }
        Object[] objectArray = this.mDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((DocumentChangeListener)listenerObj).documentChangeFinalized(docChange);
            ++n2;
        }
        this.mLastFiredDocumentChange = docChange;
        this.mDocChangeCombinable = false;
    }

    public void fireDocumentChangeUpdatedEvent(DocChange docChange) {
        Object[] objectArray = this.mDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((DocumentChangeListener)listenerObj).documentChangeUpdated(docChange);
            ++n2;
        }
    }

    public void fireDocumentChangeAmendedEvent(DocChange oldDocChange, DocChange newDocChange) {
        Object[] objectArray = this.mDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((DocumentChangeListener)listenerObj).documentChangeAmended(oldDocChange, newDocChange);
            ++n2;
        }
    }

    public void addListeners() {
        this.addListeners(Utilities.getActiveEditor());
    }

    public void addListeners(IEditorPart editor) {
        this.mEditor = editor;
        final StyledText styledText = Utilities.getStyledText(this.mEditor);
        final ISourceViewer viewer = Utilities.getSourceViewer(this.mEditor);
        if (styledText == null || viewer == null) {
            return;
        }
        StyledTextEventRecorder.getInstance().addListeners(editor);
        DocumentRecorder.getInstance().addListeners(editor);
        EclipseCommandRecorder.getInstance().addListeners(editor);
        CompletionRecorder.getInstance().addListeners(editor);
        this.registerFindAction();
        final ITextViewerExtension5 ext5 = Utilities.getTextViewerExtension5(editor);
        styledText.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EventRecorder.this.mLastCaretOffset = styledText.getCaretOffset();
                EventRecorder.this.mLastSelectionStart = styledText.getSelection().x;
                EventRecorder.this.mLastSelectionEnd = styledText.getSelection().y;
                if (EventRecorder.this.mLastSelectionStart != EventRecorder.this.mLastSelectionEnd) {
                    int docStart = ext5.widgetOffset2ModelOffset(EventRecorder.this.mLastSelectionStart);
                    int docEnd = ext5.widgetOffset2ModelOffset(EventRecorder.this.mLastSelectionEnd);
                    int docOffset = ext5.widgetOffset2ModelOffset(EventRecorder.this.mLastCaretOffset);
                    EventRecorder.this.recordCommand(new SelectTextCommand(EventRecorder.this.mLastSelectionStart, EventRecorder.this.mLastSelectionEnd, EventRecorder.this.mLastCaretOffset, docStart, docEnd, docOffset));
                } else {
                    EventRecorder.this.recordCommand(new MoveCaretCommand(EventRecorder.this.mLastCaretOffset, viewer.getSelectedRange().x));
                }
            }
        });
    }

    public void removeListeners() {
        if (this.mEditor == null) {
            return;
        }
        try {
            StyledTextEventRecorder.getInstance().removeListeners(this.mEditor);
            DocumentRecorder.getInstance().removeListeners(this.mEditor);
            EclipseCommandRecorder.getInstance().removeListeners(this.mEditor);
            CompletionRecorder.getInstance().removeListeners(this.mEditor);
            this.unregisterFindAction();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mEditor = null;
    }

    private void registerFindAction() {
        AbstractTextEditor ate = EventRecorder.findTextEditor(this.getEditor());
        if (ate != null) {
            this.mSavedFindAction = ate.getAction(ITextEditorActionConstants.FIND);
            FindAction findAction = new FindAction();
            findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
            ate.setAction(ITextEditorActionConstants.FIND, (IAction)findAction);
        }
    }

    private void unregisterFindAction() {
        AbstractTextEditor ate = EventRecorder.findTextEditor(this.getEditor());
        if (ate != null) {
            ate.setAction(ITextEditorActionConstants.FIND, this.mSavedFindAction);
        }
    }

    public static AbstractTextEditor findTextEditor(IEditorPart editor) {
        if (editor instanceof AbstractTextEditor) {
            return (AbstractTextEditor)editor;
        }
        if (editor instanceof MultiPageEditorPart) {
            IEditorPart[] parts;
            MultiPageEditorPart mpe = (MultiPageEditorPart)editor;
            IEditorPart[] iEditorPartArray = parts = mpe.findEditors(editor.getEditorInput());
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editorPart = iEditorPartArray[n2];
                if (editorPart instanceof AbstractTextEditor) {
                    return (AbstractTextEditor)editorPart;
                }
                ++n2;
            }
        }
        return null;
    }

    public void scheduleTask(Runnable runnable) {
        if (this.mStarted) {
            runnable.run();
        } else {
            this.mScheduledTasks.add(runnable);
        }
    }

    public void start() {
        EventLoggerConsole.getConsole().writeln("***Started macro recording", 3);
        this.mCommands = new LinkedList();
        this.mNormalCommands = new LinkedList();
        this.mDocumentChangeCommands = new LinkedList();
        this.mCurrentlyExecutingCommand = false;
        this.mRecordCommands = true;
        this.mStartTimestamp = Calendar.getInstance().getTime().getTime();
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IPartService service = window.getPartService();
            if (service != null) {
                service.addPartListener((IPartListener2)PartRecorder.getInstance());
                if (service.getActivePartReference() instanceof IEditorReference) {
                    PartRecorder.getInstance().partActivated(service.getActivePartReference());
                }
            }
            ++n2;
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)RunRecorder.getInstance());
        JUnitCore.addTestRunListener((TestRunListener)JUnitRecorder.getInstance());
        this.initializeLogger();
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        this.setCombineCommands(prefStore.getBoolean("EventLogger_CombineCommands"));
        this.setCombineTimeThreshold(prefStore.getInt("EventLogger_CombineTimeThreshold"));
        this.mStarted = true;
        for (Runnable runnable : this.mScheduledTasks) {
            runnable.run();
        }
    }

    public void stop() {
        if (!this.mStarted) {
            return;
        }
        this.updateIncrementalFindMode();
        for (ICommand command : this.mCommands) {
            LOGGER.log(Level.FINE, null, command);
        }
        try {
            IPartService partService;
            IWorkbenchWindow window;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (partService = window.getPartService()) != null) {
                partService.removePartListener((IPartListener2)PartRecorder.getInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)RunRecorder.getInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getTimer().cancel();
        this.getTimer().purge();
    }

    private void initializeLogger() {
        LOGGER.setLevel(Level.FINE);
        File outputFile = null;
        try {
            File logLocation = Utilities.getLogLocation();
            outputFile = new File(logLocation, Utilities.getUniqueLogNameByTimestamp(this.getStartTimestamp(), false));
            FileHandler handler = new FileHandler(outputFile.getPath());
            handler.setEncoding("UTF-8");
            handler.setFormatter(new FluoriteXMLFormatter(this.getStartTimestamp()));
            LOGGER.addHandler(handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Events getRecordedEventsSoFar() {
        return this.getRecordedEvents(this.mCommands);
    }

    public Events getRecordedEvents(List<ICommand> commands) {
        return new Events(commands, "", Long.toString(this.getStartTimestamp()), "", this.getStartTimestamp());
    }

    public IEditorPart getEditor() {
        return this.mEditor;
    }

    public void updateIncrementalFindMode() {
        if (!this.mIncrementalFindMode) {
            return;
        }
        StyledText st = Utilities.getStyledText(Utilities.getActiveEditor());
        Listener[] currentListeners = st.getListeners(4);
        boolean stillInList = false;
        Listener[] listenerArray = currentListeners;
        int n = currentListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (listener == this.mIncrementalListener) {
                stillInList = true;
                break;
            }
            ++n2;
        }
        if (!stillInList) {
            this.mIncrementalFindMode = false;
            String selectionText = st.getSelectionText();
            FindCommand findCommand = new FindCommand(selectionText);
            findCommand.setSearchForward(this.mIncrementalFindForward);
            this.recordCommand(findCommand);
            System.out.println("Incremental find string: " + selectionText);
        }
    }

    public void endIncrementalFindMode() {
    }

    public void pauseRecording() {
        this.mRecordCommands = false;
    }

    public void resumeRecording() {
        this.mRecordCommands = true;
    }

    public void amendLastDocumentChange(DocChange newDocChange, boolean usePreviousTimestamp) {
        DocChange lastDocChange = (DocChange)this.mDocumentChangeCommands.getLast();
        int index = this.mCommands.indexOf(lastDocChange);
        this.fireDocumentChangeFinalizedEvent(lastDocChange);
        newDocChange.setCommandIndex(lastDocChange.getCommandIndex());
        long timestamp = Calendar.getInstance().getTime().getTime();
        newDocChange.setTimestamp(usePreviousTimestamp ? lastDocChange.getTimestamp() : (timestamp -= this.mStartTimestamp));
        newDocChange.setTimestamp2(timestamp);
        this.mDocumentChangeCommands.set(this.mDocumentChangeCommands.size() - 1, newDocChange);
        this.mCommands.set(index, newDocChange);
        this.mLastFiredDocumentChange = newDocChange;
        this.fireDocumentChangeAmendedEvent(lastDocChange, newDocChange);
    }

    public void recordCommand(ICommand newCommand) {
        StyledText styledText;
        if (!this.mRecordCommands) {
            return;
        }
        long timestamp = Calendar.getInstance().getTime().getTime();
        EventLoggerConsole.getConsole().writeln("*Command added to macro: " + newCommand.getName() + "\ttimestamp: " + (timestamp -= this.mStartTimestamp), 3);
        newCommand.setTimestamp(timestamp);
        newCommand.setTimestamp2(timestamp);
        boolean isNewCmdDocChange = newCommand instanceof DocChange;
        LinkedList<ICommand> commands = isNewCmdDocChange ? this.mDocumentChangeCommands : this.mNormalCommands;
        boolean combined = false;
        ICommand lastCommand = commands.size() > 0 ? commands.get(commands.size() - 1) : null;
        boolean isLastCmdDocChange = lastCommand instanceof DocChange;
        if (lastCommand != null && this.isCombineEnabled(newCommand, lastCommand, isNewCmdDocChange)) {
            combined = lastCommand.combineWith(newCommand);
        }
        if (combined && isLastCmdDocChange) {
            this.fireDocumentChangeUpdatedEvent((DocChange)lastCommand);
        }
        if (!combined) {
            commands.add(newCommand);
            this.mCommands.add(newCommand);
            if (newCommand instanceof DocChange) {
                if (!(newCommand instanceof FileOpenCommand)) {
                    this.fireDocumentChangedEvent((DocChange)newCommand);
                }
                if (isLastCmdDocChange && lastCommand != this.mLastFiredDocumentChange) {
                    this.fireDocumentChangeFinalizedEvent((DocChange)lastCommand);
                }
            } else {
                this.fireCommandExecutedEvent(newCommand);
            }
        }
        while (!this.mCommands.isEmpty()) {
            LinkedList<ICommand> typeList;
            ICommand firstCmd = this.mCommands.getFirst();
            LinkedList<ICommand> linkedList = typeList = firstCmd instanceof DocChange ? this.mDocumentChangeCommands : this.mNormalCommands;
            if (typeList.size() <= 1 || typeList.getFirst() != firstCmd) break;
            LOGGER.log(Level.FINE, null, firstCmd);
            typeList.removeFirst();
            this.mCommands.removeFirst();
        }
        if ((styledText = Utilities.getStyledText(Utilities.getActiveEditor())) != null) {
            this.mLastCaretOffset = styledText.getCaretOffset();
            this.mLastSelectionStart = styledText.getSelection().x;
            this.mLastSelectionEnd = styledText.getSelection().y;
        }
        if (isNewCmdDocChange) {
            if (this.mDocChangeTimerTask != null) {
                this.mDocChangeTimerTask.cancel();
            }
            this.mDocChangeTimerTask = new TimerTask(){

                @Override
                public void run() {
                    EventRecorder.this.mDocChangeCombinable = false;
                    try {
                        ICommand lastCommand;
                        ICommand iCommand = lastCommand = EventRecorder.this.mDocumentChangeCommands.size() > 0 ? (ICommand)EventRecorder.this.mDocumentChangeCommands.get(EventRecorder.this.mDocumentChangeCommands.size() - 1) : null;
                        if (lastCommand != null && lastCommand != EventRecorder.this.mLastFiredDocumentChange) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    EventRecorder.this.fireDocumentChangeFinalizedEvent((DocChange)lastCommand);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            this.getTimer().schedule(this.mDocChangeTimerTask, this.getCombineTimeThreshold());
            this.mDocChangeCombinable = true;
        } else {
            if (this.mNormalTimerTask != null) {
                this.mNormalTimerTask.cancel();
            }
            this.mNormalTimerTask = new TimerTask(){

                @Override
                public void run() {
                    EventRecorder.this.mNormalCommandCombinable = false;
                }
            };
            this.getTimer().schedule(this.mNormalTimerTask, this.getCombineTimeThreshold());
            this.mNormalCommandCombinable = true;
        }
    }

    private boolean isCombineEnabled(ICommand newCommand, ICommand lastCommand, boolean isDocChange) {
        return this.getCombineCommands() && (isDocChange ? this.mDocChangeCombinable : this.mNormalCommandCombinable);
    }

    public long getStartTimestamp() {
        return this.mStartTimestamp;
    }

    public static Document createDocument(Events events) {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement(XML_Macro_Tag);
            doc.appendChild(root);
            events.persist(doc, root);
            return doc;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String outputXML(Document doc) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            return xmlString;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String persistMacro(Events macro) {
        Document doc = EventRecorder.createDocument(macro);
        return EventRecorder.outputXML(doc);
    }
}

