/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Range;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.model.FileSnapshotManager;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileOpenCommand
extends DocChange {
    private String mFilePath;
    private String mProjectName;
    private String mSnapshot;
    private String mPrevSnapshot;

    public FileOpenCommand() {
    }

    public FileOpenCommand(IEditorPart editor) {
        this.initialize(editor);
    }

    private void initialize(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                IFile file = fileInput.getFile();
                IProject project = file.getProject();
                this.mProjectName = project.getName();
                this.mFilePath = fileInput.getFile().getLocation().toOSString();
                IDocument doc = Utilities.getDocument(editor);
                if (doc != null) {
                    String content = doc.get();
                    this.calcNumericalValues(content);
                    FileSnapshotManager snapshotManager = EventRecorder.getInstance().getFileSnapshotManager();
                    if (!snapshotManager.isSame(this.mFilePath, content)) {
                        this.mPrevSnapshot = snapshotManager.getContent(this.mFilePath);
                        this.mSnapshot = content;
                        snapshotManager.updateSnapshot(this.mFilePath, content);
                    } else {
                        this.mSnapshot = null;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("projectName", this.mProjectName == null ? "null" : this.mProjectName);
        Map<String, Integer> numericalValues = this.getNumericalValues();
        if (numericalValues != null) {
            for (Map.Entry<String, Integer> pair : numericalValues.entrySet()) {
                attrMap.put(pair.getKey(), Integer.toString(pair.getValue()));
            }
        }
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("filePath", this.mFilePath == null ? "null" : this.mFilePath);
        if (this.mSnapshot != null) {
            dataMap.put("snapshot", this.mSnapshot);
        }
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        Node textNode;
        super.createFrom(commandElement);
        Attr attr = null;
        String value = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode("projectName");
        this.mProjectName = attr != null ? ((value = attr.getValue()).equals("null") ? null : value) : null;
        nodeList = commandElement.getElementsByTagName("filePath");
        this.mFilePath = nodeList.getLength() > 0 ? ((value = (textNode = nodeList.item(0)).getTextContent()).equals("null") ? null : value) : null;
        nodeList = commandElement.getElementsByTagName("snapshot");
        if (nodeList.getLength() > 0) {
            textNode = nodeList.item(0);
            value = textNode.getTextContent();
            this.mSnapshot = this.checkTextValidity(value, this.getNumericalValues().get("docLength"));
        } else {
            this.mSnapshot = null;
        }
    }

    @Override
    public String getCommandType() {
        return "FileOpenCommand";
    }

    @Override
    public String getName() {
        return "File Open: \"" + this.mFilePath + "\"";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    public String getSnapshot() {
        return this.mSnapshot;
    }

    public String getPrevSnapshot() {
        return this.mPrevSnapshot;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public String getProjectName() {
        return this.mProjectName;
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        return false;
    }

    @Override
    public void apply(IDocument doc) {
        if (this.getSnapshot() != null) {
            doc.set(this.getSnapshot());
        }
    }

    @Override
    public String apply(String original) {
        if (this.getSnapshot() != null) {
            return this.getSnapshot();
        }
        return original;
    }

    @Override
    public void apply(StringBuilder builder) {
        if (this.getSnapshot() != null) {
            builder.replace(0, builder.length(), this.getSnapshot());
        }
    }

    @Override
    public void applyInverse(IDocument doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String applyInverse(String original) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyInverse(StringBuilder builder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getY1() {
        return 0.0;
    }

    @Override
    public double getY2() {
        return 100.0;
    }

    @Override
    public Range getDeletionRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDeletedText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Range getInsertionRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getInsertedText() {
        throw new UnsupportedOperationException();
    }
}

