/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.ITimestampOverridable;
import edu.cmu.scs.fluorite.commands.ITypeOverridable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotateCommand
extends AbstractCommand
implements ITimestampOverridable,
ITypeOverridable {
    public static final int CANCEL = 1;
    public static final int OTHER = 0;
    public static final int BACKTRACKING = 2;
    public static final int WRITING_NEW_CODE = 3;
    public static final int TUNING_PARAMETERS = 4;
    public static final int LEARNING_API = 5;
    public static final int TRYING_OUT_UI_DESIGN = 6;
    public static final int CORRECTING_LOGIC = 7;
    public static final int TRYING_OUT_DIFFERENT_ALGORITHMS = 8;
    public static final int DEBUGGING = 9;
    public static final int TAG = 10;
    public static final String[] BUTTON_NAMES = new String[]{"Other", "Cancel", "Backtracking", "Writing new code", "Tuning parameters", "Learning API", "Trying out UI design", "Correcting Logic", "Trying out different algorithms", "Debugging", "Tag"};
    private int mId;
    private String mComment;
    private boolean mOverrideTimestamp;
    private long mDisplayTimestamp;

    public AnnotateCommand() {
    }

    public AnnotateCommand(int id, String comment) {
        this.mId = id;
        this.mComment = comment;
        this.mOverrideTimestamp = false;
        this.mDisplayTimestamp = -1L;
    }

    public AnnotateCommand(int id, String comment, long displayTimestamp) {
        this.mId = id;
        this.mComment = comment;
        this.mOverrideTimestamp = true;
        this.mDisplayTimestamp = displayTimestamp;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int id) {
        this.mId = id;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean overridesTimestamp() {
        return this.mOverrideTimestamp;
    }

    public long getDisplayTimestamp() {
        return this.mDisplayTimestamp;
    }

    public void setmComment(String mComment) {
        this.mComment = mComment;
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        String selectionString = this.getSelectionString();
        attrMap.put("selection", selectionString);
        if (this.overridesTimestamp()) {
            attrMap.put("displayTimestamp", Long.toString(this.getDisplayTimestamp()));
        }
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("comment", this.mComment);
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        Node textNode;
        super.createFrom(commandElement);
        Attr attr = null;
        String value = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode("selection");
        this.mId = attr != null ? Arrays.asList(BUTTON_NAMES).indexOf(attr.getValue()) : -1;
        attr = commandElement.getAttributeNode("displayTimestamp");
        if (attr != null) {
            this.mOverrideTimestamp = true;
            this.mDisplayTimestamp = Long.parseLong(attr.getValue());
        } else {
            this.mOverrideTimestamp = false;
            this.mDisplayTimestamp = -1L;
        }
        nodeList = commandElement.getElementsByTagName("comment");
        this.mComment = nodeList.getLength() > 0 ? ((value = (textNode = nodeList.item(0)).getTextContent()).equals("null") ? null : value) : null;
    }

    @Override
    public String getCommandType() {
        return "Annotation";
    }

    private String getSelectionString() {
        String selectionString = "Other";
        if (this.mId >= 0 && this.mId <= BUTTON_NAMES.length) {
            selectionString = BUTTON_NAMES[this.mId];
        }
        return selectionString;
    }

    @Override
    public String getName() {
        return "Annotation (" + this.getSelectionString() + "): " + this.mComment;
    }

    @Override
    public String getDescription() {
        return this.getComment();
    }

    @Override
    public String getCategory() {
        return "Annotation";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.annotation";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        return false;
    }

    @Override
    public long getTimestampForDisplay() {
        if (this.overridesTimestamp()) {
            return this.getDisplayTimestamp();
        }
        return this.getSessionId() + this.getTimestamp();
    }

    @Override
    public String getTypeForDisplay() {
        if (this.getId() == 10) {
            return "Tag";
        }
        return this.getCommandType();
    }
}

