/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IEditorPart;

public class ShellBoundsCommand
extends AbstractCommand {
    private Rectangle bounds;
    private Map<String, String> attrs;

    public ShellBoundsCommand(Rectangle r) {
        this.bounds = r;
        this.attrs = null;
        if (r != null) {
            this.attrs = new HashMap<String, String>();
            this.attrs.put("bounds", String.format("[%d, %d, %d, %d]", r.x, r.y, r.width, r.height));
        }
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        return this.attrs;
    }

    @Override
    public Map<String, String> getDataMap() {
        return null;
    }

    @Override
    public String getCommandType() {
        return "ShellBoundsCommand";
    }

    @Override
    public String getName() {
        return "Shell Bounds Command";
    }

    @Override
    public String getDescription() {
        return "Shell moved/resized to " + this.bounds;
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        if (!(anotherCommand instanceof ShellBoundsCommand)) {
            return false;
        }
        ShellBoundsCommand rsc = (ShellBoundsCommand)anotherCommand;
        this.attrs = rsc.attrs;
        return true;
    }
}

