/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SelectTextCommand
extends AbstractCommand {
    private int mStart;
    private int mEnd;
    private int mCaretOffset;
    private int mDocStart;
    private int mDocEnd;
    private int mDocOffset;

    public SelectTextCommand() {
    }

    public SelectTextCommand(int start, int end, int caretOffset, int docStart, int docEnd, int docOffset) {
        this.mStart = start;
        this.mEnd = end;
        this.mCaretOffset = caretOffset;
        this.mDocStart = docStart;
        this.mDocEnd = docEnd;
        this.mDocOffset = docOffset;
    }

    @Override
    public boolean execute(IEditorPart target) {
        StyledText styledText = Utilities.getStyledText(target);
        if (styledText == null) {
            return false;
        }
        if (this.mStart == this.mCaretOffset) {
            styledText.setSelection(this.mEnd, this.mStart);
        } else {
            styledText.setSelection(this.mStart, this.mEnd);
        }
        return true;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("start", Integer.toString(this.mStart));
        attrMap.put("end", Integer.toString(this.mEnd));
        attrMap.put("caretOffset", Integer.toString(this.mCaretOffset));
        attrMap.put("docStart", Integer.toString(this.mDocStart));
        attrMap.put("docEnd", Integer.toString(this.mDocEnd));
        attrMap.put("docOffset", Integer.toString(this.mDocOffset));
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        return null;
    }

    @Override
    public void createFrom(Element commandElement) {
        super.createFrom(commandElement);
        Attr attr = null;
        attr = commandElement.getAttributeNode("start");
        if (attr != null) {
            this.mStart = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("end")) != null) {
            this.mEnd = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("caretOffset")) != null) {
            this.mCaretOffset = Integer.parseInt(attr.getValue());
        }
        this.mDocStart = (attr = commandElement.getAttributeNode("docStart")) != null ? Integer.parseInt(attr.getValue()) : -1;
        attr = commandElement.getAttributeNode("docEnd");
        this.mDocEnd = attr != null ? Integer.parseInt(attr.getValue()) : -1;
        attr = commandElement.getAttributeNode("docOffset");
        this.mDocOffset = attr != null ? Integer.parseInt(attr.getValue()) : -1;
    }

    @Override
    public String getCommandType() {
        return "SelectTextCommand";
    }

    @Override
    public String getName() {
        return "Select Text (" + this.mStart + ", " + this.mEnd + ", " + this.mCaretOffset + ", " + this.mDocStart + ", " + this.mDocEnd + ", " + this.mDocOffset + ")";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        return false;
    }
}

