/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.util;

import edu.cmu.scs.fluorite.plugin.Activator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class EventLoggerConsole
extends IOConsole {
    private static EventLoggerConsole mConsole;
    private static final String ConsoleName = "EventLogger.Macro_Console";
    public static final int Type_Standard = 1;
    public static final int Type_Error = 2;
    public static final int Type_RecordingCommand = 3;
    public static final int Type_PlayingCommand = 4;
    public static final int Type_DebugInfo = 5;
    public static final Color Red;
    public static final Color Green;
    public static final Color Blue;
    public static final Color Purple;

    static {
        Red = new Color((Device)Display.getDefault(), 255, 0, 0);
        Green = new Color((Device)Display.getDefault(), 0, 128, 0);
        Blue = new Color((Device)Display.getDefault(), 0, 0, 255);
        Purple = new Color((Device)Display.getDefault(), 128, 0, 128);
    }

    public EventLoggerConsole() {
        super("Event Logger", null);
        mConsole = null;
    }

    public void write(Exception e) {
        this.write(e, 2);
    }

    public void write(Exception e, int type) {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)mConsole);
        IOConsoleOutputStream outputStream = mConsole.newOutputStream();
        this.configureStream(outputStream, type);
        try {
            PrintStream ps = new PrintStream((OutputStream)outputStream);
            e.printStackTrace(ps);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void writeln(String data) {
        this.writeln(data, 1);
    }

    public void writeln(String data, int type) {
        this.write(String.valueOf(data) + "\n", type);
    }

    public void write(String data) {
        this.write(data, 1);
    }

    public void write(String data, int type) {
        if (type != 2 && type != 5 && !Activator.getDefault().getPreferenceStore().getBoolean("EventLogger_WriteToConsole")) {
            return;
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("EventLogger_ShowConsole")) {
            try {
                IViewReference consoleView;
                IWorkbenchPage page;
                IWorkbenchWindow window;
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (consoleView = page.findViewReference("org.eclipse.ui.console.ConsoleView")) != null && !consoleView.isFastView()) {
                    ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)mConsole);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        IOConsoleOutputStream outputStream = mConsole.newOutputStream();
        this.configureStream(outputStream, type);
        try {
            try {
                outputStream.write(data);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    outputStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void configureStream(IOConsoleOutputStream outputStream, int type) {
        switch (type) {
            case 2: {
                outputStream.setColor(Red);
                break;
            }
            case 4: {
                outputStream.setColor(Blue);
                break;
            }
            case 3: {
                outputStream.setColor(Green);
                break;
            }
            case 5: {
                outputStream.setColor(Purple);
            }
        }
    }

    public static EventLoggerConsole getConsole() {
        if (mConsole == null) {
            IConsole[] consoles;
            IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getName().equals(ConsoleName) && console instanceof EventLoggerConsole) {
                    mConsole = (EventLoggerConsole)console;
                }
                ++n2;
            }
            if (mConsole == null) {
                mConsole = new EventLoggerConsole();
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{mConsole});
            }
        }
        mConsole.setWaterMarks(10000, 100000);
        return mConsole;
    }
}

