/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.recorders;

import edu.cmu.scs.fluorite.commands.AssistCommand;
import edu.cmu.scs.fluorite.recorders.BaseRecorder;
import edu.cmu.scs.fluorite.util.Utilities;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.ui.IEditorPart;

public class CompletionRecorder
extends BaseRecorder
implements ICompletionListener {
    private static CompletionRecorder instance = null;

    public static CompletionRecorder getInstance() {
        if (instance == null) {
            instance = new CompletionRecorder();
        }
        return instance;
    }

    private CompletionRecorder() {
    }

    @Override
    public void addListeners(IEditorPart editor) {
        ISourceViewerExtension4 sourceViewerExtension4;
        ISourceViewerExtension3 sourceViewerExtension3 = Utilities.getSourceViewerExtension3(editor);
        if (sourceViewerExtension3 != null && sourceViewerExtension3.getQuickAssistAssistant() != null) {
            sourceViewerExtension3.getQuickAssistAssistant().addCompletionListener((ICompletionListener)this);
        }
        if ((sourceViewerExtension4 = Utilities.getSourceViewerExtension4(editor)) != null && sourceViewerExtension4.getContentAssistantFacade() != null) {
            sourceViewerExtension4.getContentAssistantFacade().addCompletionListener((ICompletionListener)this);
        }
    }

    @Override
    public void removeListeners(IEditorPart editor) {
        try {
            ISourceViewerExtension4 sourceViewerExtension4;
            ISourceViewerExtension3 sourceViewerExtension3 = Utilities.getSourceViewerExtension3(this.getRecorder().getEditor());
            if (sourceViewerExtension3 != null && sourceViewerExtension3.getQuickAssistAssistant() != null) {
                sourceViewerExtension3.getQuickAssistAssistant().removeCompletionListener((ICompletionListener)this);
            }
            if ((sourceViewerExtension4 = Utilities.getSourceViewerExtension4(this.getRecorder().getEditor())) != null && sourceViewerExtension4.getContentAssistantFacade() != null) {
                sourceViewerExtension4.getContentAssistantFacade().removeCompletionListener((ICompletionListener)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.getRecorder().setAssistSession(true);
        if (event.assistant == null) {
            return;
        }
        AssistCommand.AssistType assistType = event.assistant.getClass().getCanonicalName().indexOf("QuickAssist") != -1 ? AssistCommand.AssistType.QUICK_ASSIST : AssistCommand.AssistType.CONTENT_ASSIST;
        this.getRecorder().recordCommand(new AssistCommand(assistType, AssistCommand.StartEndType.START, event.isAutoActivated, null));
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.getRecorder().setAssistSession(false);
        if (event.assistant == null) {
            return;
        }
        AssistCommand.AssistType assistType = event.assistant.getClass().getCanonicalName().indexOf("QuickAssist") != -1 ? AssistCommand.AssistType.QUICK_ASSIST : AssistCommand.AssistType.CONTENT_ASSIST;
        this.getRecorder().recordCommand(new AssistCommand(assistType, AssistCommand.StartEndType.END, false, null));
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }
}

