/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands.document;

import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Range;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Delete
extends DocChange {
    private int mOffset;
    private int mLength;
    private int mStartLine;
    private int mEndLine;
    private String mText;

    public Delete() {
    }

    public Delete(int offset, int length, int startLine, int endLine, String text, IDocument document) {
        this.mOffset = offset;
        this.mLength = length;
        this.mStartLine = startLine;
        this.mEndLine = endLine;
        this.mText = text;
        if (document != null) {
            String documentContent = document.get();
            documentContent = String.valueOf(documentContent.substring(0, this.mOffset)) + documentContent.substring(this.mOffset + this.mLength);
            this.calcNumericalValues(documentContent);
        }
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("offset", Integer.toString(this.mOffset));
        attrMap.put("length", Integer.toString(this.mLength));
        attrMap.put("startLine", Integer.toString(this.mStartLine));
        attrMap.put("endLine", Integer.toString(this.mEndLine));
        if (this.getNumericalValues() != null) {
            for (Map.Entry<String, Integer> pair : this.getNumericalValues().entrySet()) {
                attrMap.put(pair.getKey(), Integer.toString(pair.getValue()));
            }
        }
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.getText() != null) {
            dataMap.put("text", this.getText());
        }
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        super.createFrom(commandElement);
        Attr attr = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode("offset");
        if (attr != null) {
            this.mOffset = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("length")) != null) {
            this.mLength = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("startLine")) != null) {
            this.mStartLine = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("endLine")) != null) {
            this.mEndLine = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("endLine")) != null) {
            this.mEndLine = Integer.parseInt(attr.getValue());
        }
        if ((nodeList = commandElement.getElementsByTagName("text")).getLength() > 0) {
            Node textNode = nodeList.item(0);
            this.mText = this.checkTextValidity(textNode.getTextContent(), this.mLength);
        }
    }

    @Override
    public String getCommandType() {
        return "Delete";
    }

    @Override
    public String getName() {
        return "Delete text (offset: " + Integer.toString(this.mOffset) + ", length: " + Integer.toString(this.mLength) + ", startLine: " + Integer.toString(this.mStartLine) + ", endLine: " + Integer.toString(this.mEndLine) + ")";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "Every document changes";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.documentChange";
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getLength() {
        return this.mLength;
    }

    public void setStartLine(int startLine) {
        this.mStartLine = startLine;
    }

    public int getStartLine() {
        return this.mStartLine;
    }

    public void setEndLine(int endLine) {
        this.mEndLine = endLine;
    }

    public int getEndLine() {
        return this.mEndLine;
    }

    public String getText() {
        return this.mText;
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        if (!(anotherCommand instanceof Delete)) {
            return false;
        }
        Delete nextCommand = (Delete)anotherCommand;
        if (nextCommand.getOffset() != this.getOffset() && nextCommand.getOffset() + nextCommand.getLength() != this.getOffset()) {
            return false;
        }
        if (nextCommand.getText() == null && this.getText() != null || nextCommand.getText() != null && this.getText() == null) {
            return false;
        }
        if (nextCommand.getOffset() == this.getOffset()) {
            this.mEndLine += nextCommand.getEndLine() - nextCommand.getStartLine();
            if (this.getText() != null) {
                this.mText = String.valueOf(this.getText()) + nextCommand.getText();
            }
        } else if (nextCommand.getOffset() + nextCommand.getLength() == this.getOffset()) {
            this.mStartLine -= nextCommand.getEndLine() - nextCommand.getStartLine();
            this.mOffset = nextCommand.getOffset();
            if (this.getText() != null) {
                this.mText = String.valueOf(nextCommand.getText()) + this.getText();
            }
        }
        this.mLength += nextCommand.getLength();
        this.replaceNumericalValues(nextCommand);
        return true;
    }

    @Override
    public void apply(IDocument doc) {
        try {
            doc.replace(this.getOffset(), this.getLength(), "");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String apply(String original) {
        try {
            return String.valueOf(original.substring(0, this.getOffset())) + original.substring(this.getOffset() + this.getLength());
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return original;
        }
    }

    @Override
    public void apply(StringBuilder builder) {
        try {
            builder.delete(this.getOffset(), this.getOffset() + this.getLength());
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Range apply(Range range) {
        if (!range.contains(this.getDeletionRange())) {
            throw new IllegalArgumentException();
        }
        return new Range(range.getOffset(), range.getLength() - this.getLength());
    }

    @Override
    public void applyInverse(IDocument doc) {
        try {
            doc.replace(this.getOffset(), 0, this.getText());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String applyInverse(String original) {
        try {
            return String.valueOf(original.substring(0, this.getOffset())) + this.getText() + original.substring(this.getOffset());
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return original;
        }
    }

    @Override
    public void applyInverse(StringBuilder builder) {
        try {
            builder.insert(this.getOffset(), this.getText());
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Range applyInverse(Range range) {
        if (!range.contains(this.getOffset())) {
            throw new IllegalArgumentException();
        }
        return new Range(range.getOffset(), range.getLength() + this.getLength());
    }

    @Override
    public double getY1() {
        if (this.getNumericalValues() != null && this.getNumericalValues().containsKey("docLength")) {
            return 100.0 * (double)this.getOffset() / (double)(this.getNumericalValues().get("docLength") + this.getLength());
        }
        return 0.0;
    }

    @Override
    public double getY2() {
        if (this.getNumericalValues() != null && this.getNumericalValues().containsKey("docLength")) {
            return 100.0 * (double)(this.getOffset() + this.getLength()) / (double)(this.getNumericalValues().get("docLength") + this.getLength());
        }
        return 100.0;
    }

    @Override
    public Range getDeletionRange() {
        if (this.mDeletionRange == null) {
            this.mDeletionRange = new Range(this.getOffset(), this.getLength());
        }
        return this.mDeletionRange;
    }

    @Override
    public String getDeletedText() {
        return this.getText();
    }

    @Override
    public Range getInsertionRange() {
        if (this.mInsertionRange == null) {
            this.mInsertionRange = new Range(this.getOffset(), 0);
        }
        return this.mInsertionRange;
    }

    @Override
    public String getInsertedText() {
        return "";
    }

    public String toString() {
        return String.format("[Delete:%d]\n%s", this.getCommandIndex(), this.getText());
    }
}

