/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.ICommandIndexListener;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.plugin.Activator;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractCommand
implements ICommand {
    private static boolean incrementCommandID = true;
    private static int currentCommandID = -1;
    private static Set<ICommandIndexListener> commandIndexListeners = new HashSet<ICommandIndexListener>();
    private long mTimestamp;
    private long mTimestamp2;
    private int mRepeatCount;
    private int mCommandIndex;
    private long mSessionId;
    private boolean mTopBottomLinesRecorded;
    private int mTopLineNumber;
    private int mBottomLineNumber;

    public static void addCommandIndexListener(ICommandIndexListener listener) {
        if (!commandIndexListeners.contains(listener)) {
            commandIndexListeners.add(listener);
        }
    }

    public static void removeCommandIndexListener(ICommandIndexListener listener) {
        if (commandIndexListeners.contains(listener)) {
            commandIndexListeners.remove(listener);
        }
    }

    public static int getCurrentCommandID() {
        return currentCommandID;
    }

    public static void setIncrementCommandID(boolean state) {
        incrementCommandID = state;
    }

    public static boolean getIncrementCommandID() {
        return incrementCommandID;
    }

    public AbstractCommand() {
        if (AbstractCommand.getIncrementCommandID()) {
            this.mRepeatCount = 1;
            this.mCommandIndex = ++currentCommandID;
            AbstractCommand.fireCommandIndexChanged();
        }
        try {
            if (Activator.getDefault().getPreferenceStore().getBoolean("EventLogger_LogTopBottomLines")) {
                this.mTopBottomLinesRecorded = true;
                IEditorPart editor = Utilities.getActiveEditor();
                StyledText styledText = Utilities.getStyledText(editor);
                int clientAreaHeight = styledText.getClientArea().height;
                this.mTopLineNumber = styledText.getLineIndex(0) + 1;
                this.mBottomLineNumber = styledText.getLineIndex(clientAreaHeight) + 1;
            } else {
                this.mTopBottomLinesRecorded = false;
            }
        }
        catch (NullPointerException nullPointerException) {}
        this.mSessionId = EventRecorder.getInstance().getStartTimestamp();
    }

    private static void fireCommandIndexChanged() {
        for (ICommandIndexListener listener : commandIndexListeners) {
            listener.commandIndexIncreased(currentCommandID);
        }
    }

    @Override
    public String persist() {
        return Utilities.persistCommand(this.getAttributesMap(), this.getDataMap(), this);
    }

    @Override
    public void persist(Document doc, Element commandElement) {
        Utilities.persistCommand(doc, commandElement, this.getCommandType(), this.getAttributesMap(), this.getDataMap(), this);
    }

    @Override
    public void createFrom(Element commandElement) {
        if (commandElement == null) {
            throw new IllegalArgumentException();
        }
        Attr attr = null;
        attr = commandElement.getAttributeNode("__id");
        if (attr != null) {
            this.mCommandIndex = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("timestamp")) != null) {
            this.mTimestamp = Long.parseLong(attr.getValue());
        }
        this.mRepeatCount = (attr = commandElement.getAttributeNode("repeat")) != null ? Integer.parseInt(attr.getValue()) : 1;
        attr = commandElement.getAttributeNode("timestamp2");
        this.mTimestamp2 = attr != null ? Long.parseLong(attr.getValue()) : this.mTimestamp;
        this.mTopBottomLinesRecorded = false;
        attr = commandElement.getAttributeNode("topLine");
        if (attr != null) {
            this.mTopLineNumber = Integer.parseInt(attr.getValue());
            this.mTopBottomLinesRecorded = true;
        }
        if ((attr = commandElement.getAttributeNode("bottomLine")) != null) {
            this.mBottomLineNumber = Integer.parseInt(attr.getValue());
            this.mTopBottomLinesRecorded = true;
        }
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    @Override
    public void setTimestamp2(long timestamp) {
        this.mTimestamp2 = timestamp;
    }

    @Override
    public long getTimestamp2() {
        return this.mTimestamp2;
    }

    @Override
    public void increaseRepeatCount() {
        ++this.mRepeatCount;
    }

    @Override
    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.mRepeatCount = repeatCount;
    }

    @Override
    public int getCommandIndex() {
        return this.mCommandIndex;
    }

    @Override
    public void setCommandIndex(int id) {
        this.mCommandIndex = id;
    }

    @Override
    public long getSessionId() {
        return this.mSessionId;
    }

    @Override
    public void setSessionId(long sessionId) {
        this.mSessionId = sessionId;
    }

    @Override
    public boolean areTopBottomLinesRecorded() {
        return this.mTopBottomLinesRecorded;
    }

    @Override
    public int getTopLineNumber() {
        return this.mTopLineNumber;
    }

    @Override
    public int getBottomLineNumber() {
        return this.mBottomLineNumber;
    }

    @Override
    public boolean combineWith(ICommand anotherCommand) {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        if (!prefStore.getBoolean("EventLogger_CombineCommands")) {
            return false;
        }
        if (anotherCommand.getTimestamp() - this.getTimestamp2() > (long)prefStore.getInt("EventLogger_CombineTimeThreshold")) {
            return false;
        }
        if (this.combine(anotherCommand)) {
            this.setTimestamp2(anotherCommand.getTimestamp());
            this.increaseRepeatCount();
            return true;
        }
        return false;
    }

    public abstract boolean combine(ICommand var1);

    @Override
    public String getCommandTag() {
        String commandTag = "Command";
        String categoryID = this.getCategoryID();
        if (categoryID != null) {
            if (categoryID.equals("eventlogger.category.documentChange")) {
                commandTag = "DocumentChange";
            } else if (categoryID.equals("eventlogger.category.annotation")) {
                commandTag = "Annotation";
            }
        }
        return commandTag;
    }

    public static void resetCommandID() {
        currentCommandID = -1;
        AbstractCommand.fireCommandIndexChanged();
    }
}

