/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.dialogs;

import edu.cmu.scs.fluorite.commands.FindCommand;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.plugin.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindConfigureDialog
extends Dialog {
    private Text mSearchText;
    private Text mReplaceText;
    private Button mCaseSensitive;
    private Button mForward;
    private Button mRegExpMode;
    private Button mMatchWord;
    private Button mWrap;
    private Button mSelectedLines;
    private Button mReplaceAndFindButton;
    private Button mReplaceButton;
    private String mInitialSearchString;
    private boolean mCreatedDialogArea;
    private IFindReplaceTargetExtension mFindReplaceTargetExt;
    private IFindReplaceTargetExtension3 mFindReplaceTargetExt3;
    private ITextViewer mViewer;
    private Point mInitialSelection;
    private Point mLastSelection;
    private static final int FIND = 0;
    private static final int REPLACE_AND_FIND = 1;
    private static final int REPLACE = 2;
    private static final int REPLACE_ALL = 3;
    private static final int CLOSE = 4;
    private static FindConfigureDialog _instance = null;

    public static FindConfigureDialog getInstance() {
        return _instance;
    }

    public FindConfigureDialog(Shell shell, String initialSearchString, ITextViewer viewer) {
        super(shell);
        this.setShellStyle(2160);
        this.mInitialSearchString = initialSearchString;
        this.mCreatedDialogArea = false;
        this.mViewer = viewer;
        this.mFindReplaceTargetExt = (IFindReplaceTargetExtension)viewer.getFindReplaceTarget();
        this.mFindReplaceTargetExt3 = (IFindReplaceTargetExtension3)viewer.getFindReplaceTarget();
        this.mInitialSelection = viewer.getSelectedRange();
        this.mLastSelection = new Point(0, 0);
    }

    protected Control createDialogArea(Composite parent) {
        IPreferenceStore prefStore;
        this.getShell().setText("Find/Replace");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Composite stringComp = new Composite(comp, 0);
        stringComp.setLayout((Layout)new GridLayout(2, false));
        stringComp.setLayoutData((Object)new GridData(768));
        Label label = new Label(stringComp, 0);
        label.setText("&Find:");
        this.mSearchText = new Text(stringComp, 2048);
        this.mSearchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(stringComp, 0);
        label.setText("R&eplace with:");
        this.mReplaceText = new Text(stringComp, 2048);
        this.mReplaceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        stringComp.pack();
        Composite dirScopeComp = new Composite(comp, 0);
        dirScopeComp.setLayout((Layout)new GridLayout(2, true));
        dirScopeComp.setLayoutData((Object)new GridData(768));
        Group dirGroup = new Group(dirScopeComp, 0);
        dirGroup.setText("Direction");
        dirGroup.setLayout((Layout)new GridLayout());
        dirGroup.setLayoutData((Object)new GridData(1808));
        this.mForward = new Button((Composite)dirGroup, 16);
        this.mForward.setText("F&orward");
        Button backward = new Button((Composite)dirGroup, 16);
        backward.setText("&Backward");
        Group scopeGroup = new Group(dirScopeComp, 0);
        scopeGroup.setText("Scope");
        scopeGroup.setLayout((Layout)new GridLayout());
        scopeGroup.setLayoutData((Object)new GridData(768));
        Button all = new Button((Composite)scopeGroup, 16);
        all.setText("A&ll");
        all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindConfigureDialog.this.mFindReplaceTargetExt.setScope(null);
                FindConfigureDialog.this.mViewer.setSelectedRange(((FindConfigureDialog)FindConfigureDialog.this).mInitialSelection.x, ((FindConfigureDialog)FindConfigureDialog.this).mInitialSelection.y);
            }
        });
        this.mSelectedLines = new Button((Composite)scopeGroup, 16);
        this.mSelectedLines.setText("Selec&ted lines");
        this.mSelectedLines.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point lineInfo = FindConfigureDialog.this.mFindReplaceTargetExt.getLineSelection();
                FindConfigureDialog.this.mFindReplaceTargetExt.setScope((IRegion)new Region(lineInfo.x, lineInfo.y));
                FindConfigureDialog.this.mViewer.setSelectedRange(lineInfo.x, 0);
            }
        });
        Group optionsGroup = new Group(dirScopeComp, 0);
        optionsGroup.setText("Options");
        optionsGroup.setLayout((Layout)new GridLayout(2, false));
        optionsGroup.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.mCaseSensitive = new Button((Composite)optionsGroup, 32);
        this.mCaseSensitive.setText("&Case sensitive");
        this.mWrap = new Button((Composite)optionsGroup, 32);
        this.mWrap.setText("Wra&p search");
        this.mWrap.setLayoutData((Object)new GridData(768));
        this.mMatchWord = new Button((Composite)optionsGroup, 32);
        this.mMatchWord.setText("&Whole word");
        Button incremental = new Button((Composite)optionsGroup, 32);
        incremental.setText("&Incremental");
        incremental.setLayoutData((Object)new GridData(768));
        this.mRegExpMode = new Button((Composite)optionsGroup, 32);
        this.mRegExpMode.setText("Regular e&xpressions");
        this.mRegExpMode.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        dirScopeComp.pack();
        Composite buttonsComp = new Composite(comp, 0);
        GridLayout buttonsLayout = new GridLayout();
        buttonsComp.setLayout((Layout)buttonsLayout);
        this.createButton(buttonsComp, 0, "Fi&nd", true);
        this.mReplaceAndFindButton = this.createButton(buttonsComp, 1, "Replace/Fin&d", false);
        this.mReplaceButton = this.createButton(buttonsComp, 2, "&Replace", false);
        this.createButton(buttonsComp, 3, "Replace &All", false);
        this.setReplaceButtonsEnabled(false);
        buttonsComp.setLayoutData((Object)new GridData(131072, 1024, true, true));
        buttonsLayout.numColumns = 2;
        if (this.mInitialSearchString != null) {
            this.mSearchText.setText(this.mInitialSearchString);
        }
        if ((prefStore = Activator.getDefault().getPreferenceStore()).getBoolean("EventLogger_FindForward")) {
            this.mForward.setSelection(true);
        } else {
            backward.setSelection(true);
        }
        this.mCaseSensitive.setSelection(prefStore.getBoolean("EventLogger_FindCaseSensitive"));
        this.mWrap.setSelection(prefStore.getBoolean("EventLogger_FindWrapSearch"));
        this.mMatchWord.setSelection(prefStore.getBoolean("EventLogger_FindWholeWord"));
        incremental.setEnabled(false);
        this.mRegExpMode.setSelection(prefStore.getBoolean("EventLogger_FindRegExp"));
        this.mSearchText.selectAll();
        this.mFindReplaceTargetExt.beginSession();
        Point selectedRange = this.mViewer.getSelectedRange();
        try {
            if (this.mViewer.getDocument().getLineOfOffset(selectedRange.x) != this.mViewer.getDocument().getLineOfOffset(selectedRange.x + selectedRange.y)) {
                Point lineInfo = this.mFindReplaceTargetExt.getLineSelection();
                this.mFindReplaceTargetExt.setScope((IRegion)new Region(lineInfo.x, lineInfo.y));
                this.mViewer.setSelectedRange(lineInfo.x, 0);
                this.mSelectedLines.setSelection(true);
            } else {
                all.setSelection(true);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.mSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FindConfigureDialog.this.setReplaceButtonsEnabled(false);
                super.keyPressed(e);
            }
        });
        this.mCreatedDialogArea = true;
        _instance = this;
        return comp;
    }

    private void setReplaceButtonsEnabled(boolean enabled) {
        this.mReplaceAndFindButton.setEnabled(enabled);
        this.mReplaceButton.setEnabled(enabled);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.find();
                break;
            }
            case 1: {
                this.replaceAndFind();
                break;
            }
            case 2: {
                this.replace();
                break;
            }
            case 3: {
                this.replaceAll();
                break;
            }
            case 4: {
                this.cancelPressed();
            }
        }
    }

    private void replaceAll() {
        int offset = this.getOffset();
        int count = 0;
        IUndoManager undoManager = null;
        if (this.mViewer instanceof ITextViewerExtension6) {
            undoManager = ((ITextViewerExtension6)this.mViewer).getUndoManager();
        }
        if (undoManager != null) {
            undoManager.beginCompoundChange();
        }
        while (this.performFind(offset) != -1) {
            this.performReplace();
            offset = this.mLastSelection.x + this.mReplaceText.getText().length();
            ++count;
        }
        if (undoManager != null) {
            undoManager.endCompoundChange();
        }
        MessageBox msgBox = new MessageBox(this.getShell(), 32);
        msgBox.setText("Replace All");
        msgBox.setMessage(count + " matches replaced");
        msgBox.open();
        FindCommand command = new FindCommand();
        command.setSelection("Replace All");
        this.fillCommandParameters(command);
        EventRecorder.getInstance().recordCommand(command);
    }

    private void replaceAndFind() {
        this.performReplace();
        int offset = this.getOffset();
        this.performFind(offset);
        FindCommand command = new FindCommand();
        command.setSelection("Replace/Find");
        command.setOffset(offset);
        this.fillCommandParameters(command);
        EventRecorder.getInstance().recordCommand(command);
    }

    private void replace() {
        this.performReplace();
        FindCommand command = new FindCommand();
        command.setSelection("Replace");
        this.fillCommandParameters(command);
        EventRecorder.getInstance().recordCommand(command);
    }

    private void performReplace() {
        this.mFindReplaceTargetExt3.replaceSelection(this.mReplaceText.getText(), this.mRegExpMode.getSelection());
        this.setReplaceButtonsEnabled(false);
    }

    private void find() {
        int offset = this.getOffset();
        this.performFind(offset);
        FindCommand command = new FindCommand();
        command.setSelection("Find");
        command.setOffset(offset);
        this.fillCommandParameters(command);
        EventRecorder.getInstance().recordCommand(command);
    }

    private int performFind(int offset) {
        int ret = this.mFindReplaceTargetExt3.findAndSelect(offset, this.mSearchText.getText(), this.mForward.getSelection(), this.mCaseSensitive.getSelection(), this.mMatchWord.getSelection(), this.mRegExpMode.getSelection());
        if (ret == -1 && this.mWrap.getSelection()) {
            ret = this.mFindReplaceTargetExt3.findAndSelect(0, this.mSearchText.getText(), this.mForward.getSelection(), this.mCaseSensitive.getSelection(), this.mMatchWord.getSelection(), this.mRegExpMode.getSelection());
        }
        if (ret != -1) {
            this.mLastSelection.x = ret;
            this.mLastSelection.y = this.mSearchText.getText().length();
            this.setReplaceButtonsEnabled(true);
        } else {
            Display.getCurrent().beep();
        }
        return ret;
    }

    private void fillCommandParameters(FindCommand command) {
        command.setSearchString(this.mSearchText.getText());
        command.setReplaceString(this.mReplaceText.getText());
        command.setSearchForward(this.mForward.getSelection());
        command.setScopeIsSelection(this.mSelectedLines.getSelection());
        command.setCaseSensitive(this.mCaseSensitive.getSelection());
        command.setWrapSearch(this.mWrap.getSelection());
        command.setMatchWholeWord(this.mMatchWord.getSelection());
        command.setRegExpMode(this.mRegExpMode.getSelection());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.mCreatedDialogArea) {
            return;
        }
        this.createButton(parent, 4, "Close", false);
    }

    private int getOffset() {
        return this.mViewer.getSelectedRange().x + this.mViewer.getSelectedRange().y;
    }

    public boolean close() {
        this.mFindReplaceTargetExt.endSession();
        _instance = null;
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        if (prefStore != null) {
            prefStore.setValue("EventLogger_FindForward", this.mForward.getSelection());
            prefStore.setValue("EventLogger_FindCaseSensitive", this.mCaseSensitive.getSelection());
            prefStore.setValue("EventLogger_FindWrapSearch", this.mWrap.getSelection());
            prefStore.setValue("EventLogger_FindWholeWord", this.mMatchWord.getSelection());
            prefStore.setValue("EventLogger_FindRegExp", this.mRegExpMode.getSelection());
        }
        return super.close();
    }
}

