/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssistCommand
extends AbstractCommand {
    private AssistType mAssistType;
    private StartEndType mStartEndType;
    private boolean mAutoActivated;
    private String mContext;

    public AssistCommand() {
    }

    public AssistCommand(AssistType assistType, StartEndType startEndType, boolean autoActivated, String context) {
        this.mAssistType = assistType;
        this.mStartEndType = startEndType;
        this.mAutoActivated = this.mStartEndType == StartEndType.END ? false : autoActivated;
        this.mContext = context;
    }

    public AssistType getAssistType() {
        return this.mAssistType;
    }

    public StartEndType getStartEndType() {
        return this.mStartEndType;
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("assist_type", this.mAssistType.toString());
        attrMap.put("start_end", this.mStartEndType.toString());
        attrMap.put("auto_activated", Boolean.toString(this.mAutoActivated));
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.mContext != null) {
            dataMap.put("context", this.mContext);
        }
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        Node textNode;
        super.createFrom(commandElement);
        Attr attr = null;
        String value = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode("assist_type");
        if (attr != null) {
            try {
                this.mAssistType = AssistType.valueOf(attr.getValue());
            }
            catch (Exception exception) {
                this.mAssistType = AssistType.CONTENT_ASSIST;
            }
        } else {
            this.mAssistType = AssistType.CONTENT_ASSIST;
        }
        if ((attr = commandElement.getAttributeNode("start_end")) != null) {
            try {
                this.mStartEndType = StartEndType.valueOf(attr.getValue());
            }
            catch (Exception exception) {
                this.mStartEndType = StartEndType.START;
            }
        } else {
            this.mStartEndType = StartEndType.START;
        }
        this.mAutoActivated = (attr = commandElement.getAttributeNode("auto_activated")) != null ? Boolean.parseBoolean(attr.getValue()) : false;
        nodeList = commandElement.getElementsByTagName("context");
        this.mContext = nodeList.getLength() > 0 ? ((value = (textNode = nodeList.item(0)).getTextContent()).equals("null") ? null : value) : null;
    }

    @Override
    public String getCommandType() {
        return "AssistCommand";
    }

    @Override
    public String getName() {
        return String.valueOf(this.mAssistType.toString()) + " " + this.mStartEndType.toString() + ", AutoActivated: " + Boolean.toString(this.mAutoActivated) + ", Context: " + this.mContext;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        return false;
    }

    public static enum AssistType {
        CONTENT_ASSIST,
        QUICK_ASSIST;

    }

    public static enum StartEndType {
        START,
        END;

    }
}

