/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands.document;

import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Range;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Replace
extends DocChange {
    private int mOffset;
    private int mLength;
    private int mStartLine;
    private int mEndLine;
    private int mInsertionLength;
    private String mDeletedText;
    private String mInsertedText;
    private boolean mEntireFile;
    private Map<String, Integer> mIntermediateNumericalValues;

    public Replace() {
    }

    public Replace(int offset, int length, int startLine, int endLine, int insertionLength, String deletedText, String insertedText, IDocument document) {
        this.mOffset = offset;
        this.mLength = length;
        this.mStartLine = startLine;
        this.mEndLine = endLine;
        this.mInsertionLength = insertionLength;
        this.mDeletedText = deletedText;
        this.mInsertedText = insertedText;
        this.mEntireFile = false;
        if (document != null) {
            StringBuffer documentContent = new StringBuffer(document.get());
            documentContent.replace(offset, offset + length, "");
            this.calcNumericalValues(documentContent.toString());
            this.mIntermediateNumericalValues = (Map)((HashMap)this.getNumericalValues()).clone();
            documentContent.replace(offset, offset, insertedText);
            this.calcNumericalValues(documentContent.toString());
            if (offset == 0 && length == document.getLength()) {
                this.mEntireFile = true;
            }
        }
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("offset", Integer.toString(this.mOffset));
        attrMap.put("length", Integer.toString(this.mLength));
        attrMap.put("startLine", Integer.toString(this.mStartLine));
        attrMap.put("endLine", Integer.toString(this.mEndLine));
        attrMap.put("insertionLength", Integer.toString(this.mInsertionLength));
        if (this.getNumericalValues() != null) {
            for (Map.Entry<String, Integer> pair : this.getNumericalValues().entrySet()) {
                attrMap.put(pair.getKey(), Integer.toString(pair.getValue()));
            }
        }
        if (this.mIntermediateNumericalValues != null) {
            for (Map.Entry<String, Integer> pair : this.mIntermediateNumericalValues.entrySet()) {
                attrMap.put("int_" + pair.getKey(), Integer.toString(pair.getValue()));
            }
        }
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.getDeletedText() != null) {
            dataMap.put("deletedText", this.getDeletedText());
        }
        if (this.getInsertedText() != null) {
            dataMap.put("insertedText", this.getInsertedText());
        }
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        Node textNode;
        super.createFrom(commandElement);
        Attr attr = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode("offset");
        if (attr != null) {
            this.mOffset = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("length")) != null) {
            this.mLength = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("startLine")) != null) {
            this.mStartLine = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("endLine")) != null) {
            this.mEndLine = Integer.parseInt(attr.getValue());
        }
        this.mInsertionLength = (attr = commandElement.getAttributeNode("insertionLength")) != null ? Integer.parseInt(attr.getValue()) : -1;
        nodeList = commandElement.getElementsByTagName("deletedText");
        if (nodeList.getLength() > 0) {
            textNode = nodeList.item(0);
            this.mDeletedText = this.checkTextValidity(textNode.getTextContent(), this.mLength);
        }
        if ((nodeList = commandElement.getElementsByTagName("insertedText")).getLength() > 0) {
            textNode = nodeList.item(0);
            this.mInsertedText = this.mInsertionLength != -1 ? this.checkTextValidity(textNode.getTextContent(), this.mInsertionLength) : textNode.getTextContent();
        }
        this.mIntermediateNumericalValues = new HashMap<String, Integer>();
        attr = commandElement.getAttributeNode("int_docLength");
        if (attr != null) {
            this.mIntermediateNumericalValues.put("docLength", Integer.parseInt(attr.getValue()));
        }
        if ((attr = commandElement.getAttributeNode("int_docActiveCodeLength")) != null) {
            this.mIntermediateNumericalValues.put("docActiveCodeLength", Integer.parseInt(attr.getValue()));
        }
        if ((attr = commandElement.getAttributeNode("int_docASTNodeCount")) != null) {
            this.mIntermediateNumericalValues.put("docASTNodeCount", Integer.parseInt(attr.getValue()));
        }
        if ((attr = commandElement.getAttributeNode("int_docExpressionCount")) != null) {
            this.mIntermediateNumericalValues.put("docExpressionCount", Integer.parseInt(attr.getValue()));
        }
        if (this.mIntermediateNumericalValues.isEmpty()) {
            this.mIntermediateNumericalValues = null;
        }
    }

    @Override
    public String getCommandType() {
        return "Replace";
    }

    @Override
    public String getName() {
        return "Replace text (offset: " + Integer.toString(this.mOffset) + ", length: " + Integer.toString(this.mLength) + ", startLine: " + Integer.toString(this.mStartLine) + ", endLine: " + Integer.toString(this.mEndLine) + ")";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "Every document changes";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.documentChange";
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getLength() {
        return this.mLength;
    }

    public int getStartLine() {
        return this.mStartLine;
    }

    public int getEndLine() {
        return this.mEndLine;
    }

    @Override
    public String getDeletedText() {
        return this.mDeletedText;
    }

    @Override
    public String getInsertedText() {
        return this.mInsertedText;
    }

    public boolean isEntireFileChange() {
        return this.mEntireFile;
    }

    public void setEntireFileChange(boolean value) {
        this.mEntireFile = value;
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        if (!(anotherCommand instanceof Insert)) {
            return false;
        }
        if (this.isEntireFileChange()) {
            return false;
        }
        Insert nextCommand = (Insert)anotherCommand;
        if (nextCommand.getOffset() < this.getOffset() || nextCommand.getOffset() > this.getOffset() + this.getInsertionLength()) {
            return false;
        }
        if (nextCommand.getText() == null && this.getInsertedText() != null || nextCommand.getText() != null && this.getInsertedText() == null) {
            return false;
        }
        if (this.getInsertedText() != null) {
            this.mInsertedText = String.valueOf(this.getInsertedText().substring(0, nextCommand.getOffset() - this.getOffset())) + nextCommand.getText() + this.getInsertedText().substring(nextCommand.getOffset() - this.getOffset());
        }
        this.mInsertionLength += nextCommand.getLength();
        this.replaceNumericalValues(nextCommand);
        return true;
    }

    public int getInsertionLength() {
        return this.mInsertionLength;
    }

    @Override
    public void apply(IDocument doc) {
        try {
            doc.replace(this.getOffset(), this.getLength(), this.getInsertedText());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String apply(String original) {
        try {
            return String.valueOf(original.substring(0, this.getOffset())) + this.getInsertedText() + original.substring(this.getOffset() + this.getLength());
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return original;
        }
    }

    @Override
    public void apply(StringBuilder builder) {
        try {
            builder.replace(this.getOffset(), this.getOffset() + this.getLength(), this.getInsertedText());
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Range apply(Range range) {
        if (!range.contains(this.getDeletionRange())) {
            throw new IllegalArgumentException();
        }
        return new Range(range.getOffset(), range.getLength() - this.getLength() + this.getInsertionLength());
    }

    @Override
    public void applyInverse(IDocument doc) {
        try {
            doc.replace(this.getOffset(), this.getInsertionLength(), this.getDeletedText());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String applyInverse(String original) {
        try {
            return String.valueOf(original.substring(0, this.getOffset())) + this.getDeletedText() + original.substring(this.getOffset() + this.getInsertionLength());
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return original;
        }
    }

    @Override
    public void applyInverse(StringBuilder builder) {
        try {
            builder.replace(this.getOffset(), this.getOffset() + this.getInsertionLength(), this.getDeletedText());
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Range applyInverse(Range range) {
        if (!range.contains(this.getInsertionRange())) {
            throw new IllegalArgumentException();
        }
        return new Range(range.getOffset(), range.getLength() - this.getInsertionLength() + this.getLength());
    }

    private Map<String, Integer> getIntermediateNumericalValues() {
        return Collections.unmodifiableMap(this.mIntermediateNumericalValues);
    }

    @Override
    public double getY1() {
        if (this.getIntermediateNumericalValues() != null && this.getIntermediateNumericalValues().containsKey("docLength")) {
            return 100.0 * (double)this.getOffset() / (double)(this.getIntermediateNumericalValues().get("docLength") + this.getLength());
        }
        return 0.0;
    }

    @Override
    public double getY2() {
        if (this.getIntermediateNumericalValues() != null && this.getIntermediateNumericalValues().containsKey("docLength")) {
            return 100.0 * (double)(this.getOffset() + this.getLength()) / (double)(this.getIntermediateNumericalValues().get("docLength") + this.getLength());
        }
        return 100.0;
    }

    @Override
    public Range getDeletionRange() {
        if (this.mDeletionRange == null) {
            this.mDeletionRange = new Range(this.getOffset(), this.getLength());
        }
        return this.mDeletionRange;
    }

    @Override
    public Range getInsertionRange() {
        if (this.mInsertionRange == null) {
            this.mInsertionRange = new Range(this.getOffset(), this.getInsertionLength());
        }
        return this.mInsertionRange;
    }

    public String toString() {
        return String.format("[Replace:%d]\n---\n%s\n---\n+++\n%s\n+++", this.getCommandIndex(), this.getDeletedText(), this.getInsertedText());
    }
}

