/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.model;

import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.eclipse.core.runtime.Platform;

public class FluoriteXMLFormatter
extends Formatter {
    private long mStartTimestamp;
    private String mLogVersion;
    private static final String LOG_VERSION = "0.5.0.unknown";

    public FluoriteXMLFormatter(long startTimestamp) {
        this.mStartTimestamp = startTimestamp;
        this.mLogVersion = FluoriteXMLFormatter.getLogVersion();
    }

    private static String getLogVersion() {
        String versionStr = LOG_VERSION;
        try {
            versionStr = Platform.getBundle((String)"edu.cmu.scs.fluorite").getVersion().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return versionStr;
    }

    @Override
    public String format(LogRecord rec) {
        Object[] params = rec.getParameters();
        if (params.length != 1 || !(params[0] instanceof ICommand)) {
            return null;
        }
        ICommand command = (ICommand)params[0];
        return command.persist();
    }

    @Override
    public String getHead(Handler h) {
        String lineSeparator = Utilities.NewLine;
        lineSeparator = lineSeparator.replace("\r", "\\r");
        lineSeparator = lineSeparator.replace("\n", "\\n");
        return String.format("<Events startTimestamp=\"%1$s\" logVersion=\"%2$s\" osName=\"%3$s\" osVersion=\"%4$s\" lineSeparator=\"%5$s\">%n", this.mStartTimestamp, this.mLogVersion, System.getProperty("os.name"), System.getProperty("os.version"), lineSeparator);
    }

    @Override
    public String getTail(Handler h) {
        return "</Events>" + Utilities.NewLine;
    }
}

