/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands.document;

import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Range;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Insert
extends DocChange {
    private int mOffset;
    private int mLength;
    private String mText;

    public Insert() {
    }

    public Insert(int offset, String text, IDocument doc) {
        this.mOffset = offset;
        this.mLength = text.length();
        this.mText = text;
        if (doc != null) {
            this.calcNumericalValues(doc.get());
        }
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("offset", Integer.toString(this.mOffset));
        attrMap.put("length", Integer.toString(this.mLength));
        if (this.getNumericalValues() != null) {
            for (Map.Entry<String, Integer> pair : this.getNumericalValues().entrySet()) {
                attrMap.put(pair.getKey(), Integer.toString(pair.getValue()));
            }
        }
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.getText() != null) {
            dataMap.put("text", this.getText());
        }
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        super.createFrom(commandElement);
        Attr attr = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode("offset");
        if (attr != null) {
            this.mOffset = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode("length")) != null) {
            this.mLength = Integer.parseInt(attr.getValue());
        }
        if ((nodeList = commandElement.getElementsByTagName("text")).getLength() > 0) {
            Node textNode = nodeList.item(0);
            this.mText = this.checkTextValidity(textNode.getTextContent(), this.mLength);
        }
    }

    @Override
    public String getCommandType() {
        return "Insert";
    }

    @Override
    public String getName() {
        return "Insert text (offset: " + Integer.toString(this.mOffset) + ", length: " + Integer.toString(this.mLength) + ")";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "Every document changes";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.documentChange";
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getLength() {
        return this.mLength;
    }

    public String getText() {
        return this.mText;
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        if (!(anotherCommand instanceof Insert)) {
            return false;
        }
        Insert nextCommand = (Insert)anotherCommand;
        if (nextCommand.getOffset() < this.getOffset() || nextCommand.getOffset() > this.getOffset() + this.getLength()) {
            return false;
        }
        if (nextCommand.getText() == null && this.getText() != null || nextCommand.getText() != null && this.getText() == null) {
            return false;
        }
        if (this.getText().contains("\r") || this.getText().contains("\n") || nextCommand.getText().contains("\r") || nextCommand.getText().contains("\n")) {
            return false;
        }
        if (this.getText() != null) {
            this.mText = String.valueOf(this.getText().substring(0, nextCommand.getOffset() - this.getOffset())) + nextCommand.getText() + this.getText().substring(nextCommand.getOffset() - this.getOffset());
        }
        this.mLength += nextCommand.getLength();
        this.replaceNumericalValues(nextCommand);
        return true;
    }

    @Override
    public void apply(IDocument doc) {
        try {
            doc.replace(this.getOffset(), 0, this.getText());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String apply(String original) {
        try {
            return String.valueOf(original.substring(0, this.getOffset())) + this.getText() + original.substring(this.getOffset());
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return original;
        }
    }

    @Override
    public void apply(StringBuilder builder) {
        try {
            builder.insert(this.getOffset(), this.getText());
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Range apply(Range range) {
        if (!range.contains(this.getOffset())) {
            throw new IllegalArgumentException();
        }
        return new Range(range.getOffset(), range.getOffset() + this.getLength());
    }

    @Override
    public void applyInverse(IDocument doc) {
        try {
            doc.replace(this.getOffset(), this.getLength(), "");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String applyInverse(String original) {
        try {
            return String.valueOf(original.substring(0, this.getOffset())) + original.substring(this.getOffset() + this.getLength());
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return original;
        }
    }

    @Override
    public void applyInverse(StringBuilder builder) {
        try {
            builder.delete(this.getOffset(), this.getOffset() + this.getLength());
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Range applyInverse(Range range) {
        if (!range.contains(this.getInsertionRange())) {
            throw new IllegalArgumentException();
        }
        return new Range(range.getOffset(), range.getLength() - this.getLength());
    }

    @Override
    public double getY1() {
        if (this.getNumericalValues() != null && this.getNumericalValues().containsKey("docLength")) {
            return 100.0 * (double)this.getOffset() / (double)this.getNumericalValues().get("docLength").intValue();
        }
        return 0.0;
    }

    @Override
    public double getY2() {
        if (this.getNumericalValues() != null && this.getNumericalValues().containsKey("docLength")) {
            return 100.0 * (double)(this.getOffset() + this.getLength()) / (double)this.getNumericalValues().get("docLength").intValue();
        }
        return 100.0;
    }

    @Override
    public Range getDeletionRange() {
        if (this.mDeletionRange == null) {
            this.mDeletionRange = new Range(this.getOffset(), 0);
        }
        return this.mDeletionRange;
    }

    @Override
    public String getDeletedText() {
        return "";
    }

    @Override
    public Range getInsertionRange() {
        if (this.mInsertionRange == null) {
            this.mInsertionRange = new Range(this.getOffset(), this.getLength());
        }
        return this.mInsertionRange;
    }

    @Override
    public String getInsertedText() {
        return this.getText();
    }

    public String toString() {
        return String.format("[Insert:%d]\n%s", this.getCommandIndex(), this.getText());
    }
}

