/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.recorders;

import edu.cmu.scs.fluorite.commands.RunCommand;
import edu.cmu.scs.fluorite.recorders.BaseRecorder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.ui.IEditorPart;

public class RunRecorder
extends BaseRecorder
implements IDebugEventSetListener {
    private static final String PROJECT_ATTR_KEY = "org.eclipse.jdt.launching.PROJECT_ATTR";
    private static RunRecorder instance = null;

    public static RunRecorder getInstance() {
        if (instance == null) {
            instance = new RunRecorder();
        }
        return instance;
    }

    private RunRecorder() {
    }

    @Override
    public void addListeners(IEditorPart editor) {
    }

    @Override
    public void removeListeners(IEditorPart editor) {
    }

    public void handleDebugEvents(DebugEvent[] debugEvents) {
        DebugEvent[] debugEventArray = debugEvents;
        int n = debugEvents.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            this.handleDebugEvent(event);
            ++n2;
        }
    }

    private void handleDebugEvent(DebugEvent event) {
        int kind = event.getKind();
        if (kind != 4 && kind != 8) {
            return;
        }
        Object source = event.getSource();
        boolean terminate = event.getKind() == 8;
        IProcess process = this.getProcess(source);
        boolean debug = source instanceof IDebugTarget;
        if (process == null) {
            return;
        }
        ILaunchConfiguration config = process.getLaunch().getLaunchConfiguration();
        if (config == null) {
            return;
        }
        ILaunchConfigurationType configType = this.getConfigurationType(config);
        if (configType == null) {
            return;
        }
        if (configType.getIdentifier().contains("junit")) {
            return;
        }
        String projectName = "null";
        try {
            projectName = config.getAttribute(PROJECT_ATTR_KEY, "null");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.getRecorder().recordCommand(new RunCommand(debug, terminate, projectName));
    }

    private IProcess getProcess(Object source) {
        if (source instanceof IDebugTarget) {
            return ((IDebugTarget)source).getProcess();
        }
        if (source instanceof IProcess) {
            return (IProcess)source;
        }
        return null;
    }

    private ILaunchConfigurationType getConfigurationType(ILaunchConfiguration config) {
        ILaunchConfigurationType configType = null;
        try {
            configType = config.getType();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        return configType;
    }
}

