/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.dialogs.FindConfigureDialog;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FindCommand
extends AbstractCommand {
    private boolean mReplaceAll = false;
    private boolean mScopeIsSelection = false;
    private boolean mWrapSearch = false;
    private boolean mSearchForward = true;
    private boolean mCaseSensitive = false;
    private boolean mMatchWholeWord = false;
    private boolean mRegExpMode = false;
    private String mSearchString = null;
    private String mReplaceString = null;
    private boolean mOkPressed = false;
    private int mOffset;
    private String mSelection;
    public static final String XML_Selection_Attr = "selection";
    public static final String XML_Offset_Attr = "offset";
    public static final String XML_ReplaceAll_Attr = "replaceAll";
    public static final String XML_SelectionScope_Attr = "selectionScope";
    public static final String XML_WrapSearch_Attr = "wrapSearch";
    public static final String XML_Forward_Attr = "forward";
    public static final String XML_CaseSensitive_Attr = "caseSensitive";
    public static final String XML_MatchWord_Attr = "matchWord";
    public static final String XML_RegExp_Attr = "regexp";
    public static final String XML_SearchString_Tag = "searchString";
    public static final String XML_ReplaceString_Tag = "replaceString";

    public FindCommand() {
    }

    public FindCommand(String findString) {
        this();
        this.mSearchString = findString;
    }

    private void configureWithSearchTerm(Shell shell, String initialSearchString) {
        FindConfigureDialog dlg = new FindConfigureDialog(shell, initialSearchString, (ITextViewer)Utilities.getSourceViewer(EventRecorder.getInstance().getEditor()));
        dlg.open();
    }

    public void configureNew(Shell shell) {
        StyledText widget;
        if (FindConfigureDialog.getInstance() != null) {
            return;
        }
        String initialSearchString = null;
        IEditorPart editor = Utilities.getActiveEditor();
        if (editor != null && (widget = Utilities.getStyledText(editor)) != null && (initialSearchString = widget.getSelectionText()).length() == 0) {
            initialSearchString = null;
        }
        this.configureWithSearchTerm(shell, initialSearchString);
    }

    @Override
    public void dump() {
        System.out.println(this.getDescription());
    }

    @Override
    public boolean execute(IEditorPart target) {
        block18: {
            IFindReplaceTarget findTarget = Utilities.getFindReplaceTarget(target);
            if (findTarget != null && findTarget instanceof IFindReplaceTargetExtension) {
                IFindReplaceTargetExtension findTarget1 = (IFindReplaceTargetExtension)findTarget;
                findTarget1.beginSession();
                try {
                    boolean inRange;
                    int findPos;
                    StyledText widget = Utilities.getStyledText(target);
                    if (!(findTarget instanceof IFindReplaceTargetExtension3)) break block18;
                    IFindReplaceTargetExtension3 findTarget3 = (IFindReplaceTargetExtension3)findTarget;
                    int boundaryStart = 0;
                    int boundaryEnd = widget.getCharCount() - 1;
                    if (this.mScopeIsSelection) {
                        Point sel = widget.getSelectionRange();
                        boundaryStart = sel.x;
                        boundaryEnd = sel.x + sel.y;
                        findTarget1.setScope((IRegion)new Region(sel.x, sel.y));
                    } else {
                        findTarget1.setScope(null);
                    }
                    if (this.mReplaceString != null && this.mReplaceAll) {
                        this.doReplaceAll(findTarget3, widget);
                        return true;
                    }
                    String searchString = this.mSearchString;
                    if (searchString == null) {
                        try {
                            Clipboard cb = new Clipboard(widget.getDisplay());
                            TextTransfer transfer = TextTransfer.getInstance();
                            searchString = (String)cb.getContents((Transfer)transfer);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (searchString == null) {
                            searchString = widget.getSelectionText();
                        }
                    }
                    if (searchString == null || searchString.length() == 0) {
                        return false;
                    }
                    int startPos = widget.getCaretOffset() - 1;
                    if (this.mScopeIsSelection) {
                        startPos = this.mSearchForward ? boundaryStart : boundaryEnd;
                    }
                    if (!this.isInRange(searchString, boundaryStart, boundaryEnd, findPos = ((IFindReplaceTargetExtension3)findTarget).findAndSelect(startPos, searchString, this.mSearchForward, this.mCaseSensitive, this.mMatchWholeWord, this.mRegExpMode)) && this.mWrapSearch && !this.mScopeIsSelection) {
                        startPos = this.mSearchForward ? boundaryStart : boundaryEnd;
                        findPos = ((IFindReplaceTargetExtension3)findTarget).findAndSelect(startPos, searchString, this.mSearchForward, this.mCaseSensitive, this.mMatchWholeWord, this.mRegExpMode);
                    }
                    if ((inRange = this.isInRange(searchString, boundaryStart, boundaryEnd, findPos)) && this.mReplaceString != null) {
                        findTarget3.replaceSelection(this.mReplaceString, this.mRegExpMode);
                    }
                    boolean bl = inRange;
                    return bl;
                }
                finally {
                    ((IFindReplaceTargetExtension)findTarget).endSession();
                }
            }
        }
        return false;
    }

    private boolean isInRange(String searchString, int boundaryStart, int boundaryEnd, int foundPos) {
        return foundPos >= boundaryStart && foundPos + searchString.length() <= boundaryEnd;
    }

    private void doReplaceAll(IFindReplaceTargetExtension3 findTarget, StyledText widget) {
        int foundPos;
        int docPos = 0;
        int endBoundary = 0;
        if (this.mScopeIsSelection) {
            docPos = widget.getSelection().x;
            endBoundary = widget.getSelection().y;
        }
        while (!((foundPos = findTarget.findAndSelect(docPos, this.mSearchString, this.mSearchForward, this.mCaseSensitive, this.mMatchWholeWord, this.mRegExpMode)) < 0 || this.mScopeIsSelection && foundPos >= endBoundary)) {
            int oldDocLength = widget.getCharCount();
            int searchStringSize = widget.getSelectionCount();
            findTarget.replaceSelection(this.mReplaceString, this.mRegExpMode);
            int newDocLength = widget.getCharCount();
            int amtAdded = newDocLength - oldDocLength;
            docPos = foundPos + searchStringSize + amtAdded;
            endBoundary += amtAdded;
        }
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Perform Find with the following parameters:\n");
        buffer.append("Search String: " + this.mSearchString + "\n");
        buffer.append("Case Sensitive: " + this.mCaseSensitive + "\n");
        buffer.append("Search Forward: " + this.mSearchForward + "\n");
        buffer.append("Match whole word: " + this.mMatchWholeWord + "\n");
        buffer.append("Selection scope: " + this.mScopeIsSelection + "\n");
        buffer.append("Wrap Search: " + this.mWrapSearch + "\n");
        buffer.append("Reg Exp Mode: " + this.mRegExpMode + "\n");
        buffer.append("Replace All: " + this.mReplaceAll + "\n");
        buffer.append("Replace String: " + this.mReplaceString + "\n");
        return buffer.toString();
    }

    @Override
    public String getName() {
        return "Find " + (this.mSearchString != null ? this.mSearchString : "<clipboard/selection>");
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_Selection_Attr, this.mSelection);
        attrMap.put(XML_Offset_Attr, Integer.toString(this.mOffset));
        attrMap.put(XML_Forward_Attr, Boolean.toString(this.mSearchForward));
        attrMap.put(XML_CaseSensitive_Attr, Boolean.toString(this.mCaseSensitive));
        attrMap.put(XML_RegExp_Attr, Boolean.toString(this.mRegExpMode));
        attrMap.put(XML_MatchWord_Attr, Boolean.toString(this.mMatchWholeWord));
        attrMap.put(XML_ReplaceAll_Attr, Boolean.toString(this.mReplaceAll));
        attrMap.put(XML_SelectionScope_Attr, Boolean.toString(this.mScopeIsSelection));
        attrMap.put(XML_WrapSearch_Attr, Boolean.toString(this.mWrapSearch));
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.mSearchString != null) {
            dataMap.put(XML_SearchString_Tag, this.mSearchString);
        }
        if (this.mReplaceString != null) {
            dataMap.put(XML_ReplaceString_Tag, this.mReplaceString);
        }
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        Node textNode;
        super.createFrom(commandElement);
        Attr attr = null;
        String value = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode(XML_Selection_Attr);
        this.mSelection = attr != null ? ((value = attr.getValue()).equals("null") ? null : value) : null;
        attr = commandElement.getAttributeNode(XML_Offset_Attr);
        if (attr != null) {
            this.mOffset = Integer.parseInt(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(XML_Forward_Attr)) != null) {
            this.mSearchForward = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(XML_CaseSensitive_Attr)) != null) {
            this.mCaseSensitive = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(XML_RegExp_Attr)) != null) {
            this.mRegExpMode = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(XML_MatchWord_Attr)) != null) {
            this.mMatchWholeWord = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(XML_ReplaceAll_Attr)) != null) {
            this.mReplaceAll = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(XML_SelectionScope_Attr)) != null) {
            this.mScopeIsSelection = Boolean.parseBoolean(attr.getValue());
        }
        if ((attr = commandElement.getAttributeNode(XML_WrapSearch_Attr)) != null) {
            this.mWrapSearch = Boolean.parseBoolean(attr.getValue());
        }
        this.mSearchString = (nodeList = commandElement.getElementsByTagName(XML_SearchString_Tag)).getLength() > 0 ? ((value = (textNode = nodeList.item(0)).getTextContent()).equals("null") ? null : value) : null;
        nodeList = commandElement.getElementsByTagName(XML_ReplaceString_Tag);
        this.mReplaceString = nodeList.getLength() > 0 ? ((value = (textNode = nodeList.item(0)).getTextContent()).equals("null") ? null : value) : null;
    }

    @Override
    public String getCommandType() {
        return "FindCommand";
    }

    public void setSearchForward(boolean forward) {
        this.mSearchForward = forward;
    }

    public boolean isReplaceAll() {
        return this.mReplaceAll;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.mReplaceAll = replaceAll;
    }

    public boolean isCaseSensitive() {
        return this.mCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.mCaseSensitive = caseSensitive;
    }

    public boolean isMatchWholeWord() {
        return this.mMatchWholeWord;
    }

    public void setMatchWholeWord(boolean matchWholeWord) {
        this.mMatchWholeWord = matchWholeWord;
    }

    public boolean isRegExpMode() {
        return this.mRegExpMode;
    }

    public void setRegExpMode(boolean regExpMode) {
        this.mRegExpMode = regExpMode;
    }

    public String getSearchString() {
        return this.mSearchString;
    }

    public void setSearchString(String searchString) {
        this.mSearchString = searchString;
    }

    public String getReplaceString() {
        return this.mReplaceString;
    }

    public void setReplaceString(String replaceString) {
        this.mReplaceString = replaceString;
    }

    public boolean isSearchForward() {
        return this.mSearchForward;
    }

    public boolean isScopeIsSelection() {
        return this.mScopeIsSelection;
    }

    public void setScopeIsSelection(boolean scopeIsSelection) {
        this.mScopeIsSelection = scopeIsSelection;
    }

    public boolean isWrapSearch() {
        return this.mWrapSearch;
    }

    public void setWrapSearch(boolean wrapSearch) {
        this.mWrapSearch = wrapSearch;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public String getSelection() {
        return this.mSelection;
    }

    public void setSelection(String selection) {
        this.mSelection = selection;
    }

    public void setOkPressed(boolean okPressed) {
        this.mOkPressed = okPressed;
    }

    public boolean getOkPressed() {
        return this.mOkPressed;
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        return false;
    }
}

