/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class MouseWheelCommand
extends AbstractCommand {
    private int mWheelValue;

    public MouseWheelCommand() {
    }

    public MouseWheelCommand(int wheelValue) {
        this.mWheelValue = wheelValue;
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("wheelValue", Integer.toString(this.mWheelValue));
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        return null;
    }

    @Override
    public void createFrom(Element commandElement) {
        super.createFrom(commandElement);
        Attr attr = null;
        attr = commandElement.getAttributeNode("wheelValue");
        if (attr != null) {
            this.mWheelValue = Integer.parseInt(attr.getValue());
        }
    }

    @Override
    public String getCommandType() {
        return "MouseWheelCommand";
    }

    @Override
    public String getName() {
        return "Mouse Wheel (wheel value: " + this.mWheelValue + ")";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        if (!(anotherCommand instanceof MouseWheelCommand)) {
            return false;
        }
        MouseWheelCommand nextCommand = (MouseWheelCommand)anotherCommand;
        if (nextCommand.mWheelValue < 0 && this.mWheelValue < 0 || nextCommand.mWheelValue > 0 && this.mWheelValue > 0) {
            this.mWheelValue += nextCommand.mWheelValue;
            return true;
        }
        return false;
    }
}

