/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.ITreeDataCommand;
import edu.cmu.scs.fluorite.commands.ITypeOverridable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestElementContainer;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.jdt.junit.model.ITestSuiteElement;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JUnitCommand
extends AbstractCommand
implements ITreeDataCommand,
ITypeOverridable {
    private String mProjectName;
    private double mElapsedTimeInSeconds;
    private TestData mRootData;
    private static final String XML_ProjectName_Attr = "projectName";
    private static final String XML_ElapsedTime_Attr = "elapsedTimeInSeconds";

    public JUnitCommand() {
    }

    public JUnitCommand(String projectName, double elapsedTimeInSeconds, ITestElement rootElement) {
        this.mProjectName = projectName;
        this.mElapsedTimeInSeconds = elapsedTimeInSeconds;
        this.mRootData = new TestData(rootElement);
    }

    @Override
    public void createFrom(Element commandElement) {
        String rootTagName;
        super.createFrom(commandElement);
        Attr attr = null;
        String value = null;
        NodeList nodeList = null;
        attr = commandElement.getAttributeNode(XML_ProjectName_Attr);
        this.mProjectName = attr != null ? ((value = attr.getValue()).equals("null") ? null : value) : null;
        attr = commandElement.getAttributeNode(XML_ElapsedTime_Attr);
        if (attr != null) {
            this.mElapsedTimeInSeconds = Double.parseDouble(attr.getValue());
        }
        if ((nodeList = commandElement.getElementsByTagName(rootTagName = TestData.ElementType.TestSession.toString())).getLength() > 0) {
            Element xmlElement = (Element)nodeList.item(0);
            this.mRootData = new TestData(xmlElement);
        }
    }

    @Override
    public boolean execute(IEditorPart target) {
        return false;
    }

    @Override
    public void dump() {
    }

    @Override
    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(XML_ProjectName_Attr, this.getProjectName());
        attrMap.put(XML_ElapsedTime_Attr, Double.toString(this.getElapsedTimeInSeconds()));
        return attrMap;
    }

    @Override
    public Map<String, String> getDataMap() {
        return null;
    }

    @Override
    public String getCommandType() {
        return "JUnitCommand";
    }

    @Override
    public String getName() {
        return "JUnit Command";
    }

    @Override
    public String getDescription() {
        return "JUnit Run: " + this.getProjectName() + (this.getRootData().getSucceeded() ? " (Succeeded)" : " (Failed)");
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        return false;
    }

    public String getProjectName() {
        return this.mProjectName;
    }

    public double getElapsedTimeInSeconds() {
        return this.mElapsedTimeInSeconds;
    }

    public TestData getRootData() {
        return this.mRootData;
    }

    @Override
    public Object getRootElement() {
        return this.getRootData();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TestData) {
            List<TestData> children = ((TestData)parentElement).getChildren();
            if (children != null) {
                return children.toArray();
            }
            return null;
        }
        return null;
    }

    @Override
    public String getTagName(Object element) {
        if (element instanceof TestData) {
            return ((TestData)element).getType().toString();
        }
        return null;
    }

    @Override
    public Map<String, String> getAttrMap(Object element) {
        if (element instanceof TestData) {
            TestData testData = (TestData)element;
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("name", testData.getName());
            attrMap.put("succeeded", Boolean.toString(testData.getSucceeded()));
            return attrMap;
        }
        return null;
    }

    @Override
    public String getTypeForDisplay() {
        if (this.getRootData() != null) {
            return String.valueOf(this.getCommandType()) + "(" + Boolean.toString(this.getRootData().getSucceeded()) + ")";
        }
        return this.getCommandType();
    }

    public static class TestData {
        private ElementType mType;
        private String mName;
        private boolean mSucceeded;
        private List<TestData> mChildren;

        public TestData(ITestElement testElement) {
            if (testElement instanceof ITestRunSession) {
                ITestRunSession testRunSession = (ITestRunSession)testElement;
                this.mType = ElementType.TestSession;
                this.mName = testRunSession.getTestRunName();
            } else if (testElement instanceof ITestSuiteElement) {
                ITestSuiteElement testSuiteElement = (ITestSuiteElement)testElement;
                this.mType = ElementType.TestSuite;
                this.mName = testSuiteElement.getSuiteTypeName();
            } else if (testElement instanceof ITestCaseElement) {
                ITestCaseElement testCaseElement = (ITestCaseElement)testElement;
                this.mType = ElementType.TestCase;
                this.mName = String.valueOf(testCaseElement.getTestClassName()) + "." + testCaseElement.getTestMethodName();
            }
            boolean bl = this.mSucceeded = testElement.getTestResult(true) == ITestElement.Result.OK;
            if (testElement instanceof ITestElementContainer) {
                this.mChildren = new ArrayList<TestData>();
                ITestElementContainer testElementContainer = (ITestElementContainer)testElement;
                ITestElement[] iTestElementArray = testElementContainer.getChildren();
                int n = iTestElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITestElement childElement = iTestElementArray[n2];
                    this.mChildren.add(new TestData(childElement));
                    ++n2;
                }
            }
        }

        public TestData(Element xmlElement) {
            this.mType = ElementType.valueOf(xmlElement.getTagName());
            Attr attr = xmlElement.getAttributeNode("name");
            if (attr != null) {
                String value = attr.getValue();
                String string = this.mName = value.equals("null") ? null : value;
            }
            if ((attr = xmlElement.getAttributeNode("succeeded")) != null) {
                this.mSucceeded = Boolean.parseBoolean(attr.getValue());
            }
            NodeList nodeList = xmlElement.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    if (this.mChildren == null) {
                        this.mChildren = new ArrayList<TestData>();
                    }
                    this.mChildren.add(new TestData((Element)node));
                }
                ++i;
            }
        }

        public ElementType getType() {
            return this.mType;
        }

        public String getName() {
            return this.mName;
        }

        public boolean getSucceeded() {
            return this.mSucceeded;
        }

        public List<TestData> getChildren() {
            if (this.mChildren != null) {
                return Collections.unmodifiableList(this.mChildren);
            }
            return null;
        }

        public static enum ElementType {
            TestSession,
            TestSuite,
            TestCase;

        }
    }
}

