/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands.document;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.document.Delete;
import edu.cmu.scs.fluorite.commands.document.DocChangeWrapper;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Range;
import edu.cmu.scs.fluorite.commands.document.Replace;
import edu.cmu.scs.fluorite.visitors.ExpressionCountVisitor;
import edu.cmu.scs.fluorite.visitors.NodeCountVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.fraser.neil.plaintext.diff_match_patch;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class DocChange
extends AbstractCommand {
    protected Range mDeletionRange;
    protected Range mInsertionRange;
    private Map<String, Integer> mNumericalValues;

    protected Map<String, Integer> getNumericalValues() {
        return this.mNumericalValues;
    }

    protected void setNumericalValues(Map<String, Integer> numericalValues) {
        this.mNumericalValues = numericalValues;
    }

    protected void replaceNumericalValues(DocChange other) {
        this.mNumericalValues = other.getNumericalValues();
    }

    protected void calcNumericalValues(String documentContent) {
        this.mNumericalValues = new HashMap<String, Integer>();
        this.mNumericalValues.put("docLength", documentContent.length());
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        parser.setSource(documentContent.toCharArray());
        parser.setStatementsRecovery(true);
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        List commentList = compilationUnit.getCommentList();
        int commentLengthTotal = 0;
        for (Comment comment : commentList) {
            commentLengthTotal += comment.getLength();
        }
        this.mNumericalValues.put("docActiveCodeLength", documentContent.length() - commentLengthTotal);
        NodeCountVisitor ncVisitor = new NodeCountVisitor();
        compilationUnit.accept((ASTVisitor)ncVisitor);
        this.mNumericalValues.put("docASTNodeCount", ncVisitor.getCount());
        ExpressionCountVisitor ecVisitor = new ExpressionCountVisitor();
        compilationUnit.accept((ASTVisitor)ecVisitor);
        this.mNumericalValues.put("docExpressionCount", ecVisitor.getCount());
    }

    @Override
    public void createFrom(Element commandElement) {
        super.createFrom(commandElement);
        this.mNumericalValues = new HashMap<String, Integer>();
        Attr attr = null;
        attr = commandElement.getAttributeNode("docLength");
        if (attr != null) {
            this.mNumericalValues.put("docLength", Integer.parseInt(attr.getValue()));
        }
        if ((attr = commandElement.getAttributeNode("docActiveCodeLength")) != null) {
            this.mNumericalValues.put("docActiveCodeLength", Integer.parseInt(attr.getValue()));
        }
        if ((attr = commandElement.getAttributeNode("docASTNodeCount")) != null) {
            this.mNumericalValues.put("docASTNodeCount", Integer.parseInt(attr.getValue()));
        }
        if ((attr = commandElement.getAttributeNode("docExpressionCount")) != null) {
            this.mNumericalValues.put("docExpressionCount", Integer.parseInt(attr.getValue()));
        }
        if (this.mNumericalValues.isEmpty()) {
            this.mNumericalValues = null;
        }
    }

    protected String checkTextValidity(String text, int desiredLength) {
        if (text.length() != desiredLength) {
            if (text.replace("\r\n", "\n").length() == desiredLength) {
                text = text.replace("\r\n", "\n");
            } else if (text.replace("\n", "\r\n").length() == desiredLength) {
                text = text.replace("\n", "\r\n");
            } else {
                throw new IllegalArgumentException("Text does not match the desired length!");
            }
        }
        return text;
    }

    public abstract void apply(IDocument var1);

    public abstract String apply(String var1);

    public abstract void apply(StringBuilder var1);

    public abstract Range apply(Range var1);

    public abstract void applyInverse(IDocument var1);

    public abstract String applyInverse(String var1);

    public abstract void applyInverse(StringBuilder var1);

    public abstract Range applyInverse(Range var1);

    public abstract double getY1();

    public abstract double getY2();

    public abstract Range getDeletionRange();

    public abstract String getDeletedText();

    public abstract Range getInsertionRange();

    public abstract String getInsertedText();

    public boolean isWhitespaceOnly() {
        return this.getDeletedText().trim().isEmpty() && this.getInsertedText().trim().isEmpty();
    }

    public static boolean overlap(DocChange oldEvent, DocChange newEvent) {
        return Range.overlap(oldEvent.getInsertionRange(), newEvent.getDeletionRange());
    }

    public static DocChange mergeChanges(DocChange oldEvent, DocChange newEvent) {
        return DocChange.mergeChanges(oldEvent, newEvent, null);
    }

    public static DocChange mergeChanges(DocChange oldEvent, DocChange newEvent, IDocument docBefore) {
        if (oldEvent == null && newEvent == null) {
            return null;
        }
        if (oldEvent == null) {
            return newEvent;
        }
        if (newEvent == null) {
            return oldEvent;
        }
        if (DocChange.overlap(oldEvent, newEvent)) {
            return DocChange.mergeChangesOverlap(oldEvent, newEvent, docBefore);
        }
        return DocChange.mergeChangesApart(oldEvent, newEvent, docBefore);
    }

    public static DocChange mergeChanges(DocChange oldEvent, List<DocChange> newEvents) {
        return DocChange.mergeChanges(oldEvent, newEvents, null);
    }

    public static DocChange mergeChanges(DocChange oldEvent, List<DocChange> newEvents, IDocument docBefore) {
        DocChange result = oldEvent;
        for (DocChange newEvent : newEvents) {
            result = DocChange.mergeChanges(result, newEvent, docBefore);
        }
        return result;
    }

    public static DocChange mergeChanges(List<DocChange> events) {
        return DocChange.mergeChanges(events, null);
    }

    public static DocChange mergeChanges(List<DocChange> events, IDocument docBefore) {
        return DocChange.mergeChanges(events.get(0), events.subList(1, events.size()), docBefore);
    }

    private static DocChange mergeChangesApart(DocChange oldEvent, DocChange newEvent, IDocument docBefore) {
        Range oldDeletionRange = oldEvent.getDeletionRange();
        String oldDeletedText = oldEvent.getDeletedText();
        Range oldInsertionRange = oldEvent.getInsertionRange();
        String oldInsertedText = oldEvent.getInsertedText();
        Range newDeletionRange = newEvent.getDeletionRange();
        String newDeletedText = newEvent.getDeletedText();
        Range newInsertionRange = newEvent.getInsertionRange();
        String newInsertedText = newEvent.getInsertedText();
        if (oldInsertionRange.getEndOffset() < newDeletionRange.getOffset()) {
            int midLength = newDeletionRange.getOffset() - oldInsertionRange.getEndOffset();
            String midText = DocChange.getDocStringOrNullString(docBefore, oldDeletionRange.getEndOffset(), midLength);
            Range deletionRange = new Range(oldDeletionRange.getOffset(), oldDeletionRange.getLength() + midLength + newDeletionRange.getLength());
            String deletedText = String.valueOf(oldDeletedText) + midText + newDeletedText;
            Range insertionRange = new Range(oldDeletionRange.getOffset(), oldInsertionRange.getLength() + midLength + newInsertionRange.getLength());
            String insertedText = String.valueOf(oldInsertedText) + midText + newInsertedText;
            return DocChange.createMergedChange(oldEvent, newEvent, docBefore, deletionRange, deletedText, insertionRange, insertedText);
        }
        if (oldInsertionRange.getOffset() > newDeletionRange.getEndOffset()) {
            int midLength = oldDeletionRange.getOffset() - newDeletionRange.getEndOffset();
            String midText = DocChange.getDocStringOrNullString(docBefore, newDeletionRange.getEndOffset(), midLength);
            Range deletionRange = new Range(newDeletionRange.getOffset(), newDeletionRange.getLength() + midLength + oldDeletionRange.getLength());
            String deletedText = String.valueOf(newDeletedText) + midText + oldDeletedText;
            Range insertionRange = new Range(newDeletionRange.getOffset(), newInsertionRange.getLength() + midLength + oldInsertionRange.getLength());
            String insertedText = String.valueOf(newInsertedText) + midText + oldInsertedText;
            return DocChange.createMergedChange(oldEvent, newEvent, docBefore, deletionRange, deletedText, insertionRange, insertedText);
        }
        return null;
    }

    private static String getDocStringOrNullString(IDocument doc, int pos, int length) {
        if (doc != null) {
            try {
                return doc.get(pos, length);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return DocChange.getNullStringOfLength(length);
            }
        }
        return DocChange.getNullStringOfLength(length);
    }

    private static String getNullStringOfLength(int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append('X');
            ++i;
        }
        return builder.toString();
    }

    private static DocChange mergeChangesOverlap(DocChange oldEvent, DocChange newEvent, IDocument docBefore) {
        Range oldDeletionRange = oldEvent.getDeletionRange();
        String oldDeletedText = oldEvent.getDeletedText();
        Range oldInsertionRange = oldEvent.getInsertionRange();
        String oldInsertedText = oldEvent.getInsertedText();
        Range newDeletionRange = newEvent.getDeletionRange();
        String newDeletedText = newEvent.getDeletedText();
        Range newInsertionRange = newEvent.getInsertionRange();
        String newInsertedText = newEvent.getInsertedText();
        int leftGrow = Math.max(oldDeletionRange.getOffset() - newDeletionRange.getOffset(), 0);
        int rightGrow = Math.max(newDeletionRange.getEndOffset() - oldInsertionRange.getEndOffset(), 0);
        Range deletionRange = new Range(Math.min(oldDeletionRange.getOffset(), newDeletionRange.getOffset()), leftGrow + oldDeletionRange.getLength() + rightGrow);
        String deletedText = String.valueOf(newDeletedText.substring(0, leftGrow)) + oldDeletedText + newDeletedText.substring(newDeletedText.length() - rightGrow);
        Range insertionRange = new Range(deletionRange.getOffset(), Math.max(newDeletionRange.getOffset(), oldInsertionRange.getOffset()) - oldInsertionRange.getOffset() + oldInsertionRange.getEndOffset() - Math.min(newDeletionRange.getEndOffset(), oldInsertionRange.getEndOffset()) + newInsertionRange.getLength());
        String insertedText = String.valueOf(oldInsertedText.substring(0, Math.max(newDeletionRange.getOffset(), oldInsertionRange.getOffset()) - oldInsertionRange.getOffset())) + newInsertedText + oldInsertedText.substring(oldInsertedText.length() - (oldInsertionRange.getEndOffset() - Math.min(newDeletionRange.getEndOffset(), oldInsertionRange.getEndOffset())));
        return DocChange.createMergedChange(oldEvent, newEvent, docBefore, deletionRange, deletedText, insertionRange, insertedText);
    }

    private static DocChange createMergedChange(DocChange oldEvent, DocChange newEvent, IDocument docBefore, Range deletionRange, String deletedText, Range insertionRange, String insertedText) {
        int commonSuffix;
        diff_match_patch dmp = new diff_match_patch();
        int commonPrefix = dmp.diff_commonPrefix(deletedText, insertedText);
        if (commonPrefix > 0) {
            deletionRange = new Range(deletionRange.getOffset() + commonPrefix, deletionRange.getLength() - commonPrefix);
            deletedText = deletedText.substring(commonPrefix);
            insertionRange = new Range(insertionRange.getOffset() + commonPrefix, insertionRange.getLength() - commonPrefix);
            insertedText = insertedText.substring(commonPrefix);
        }
        if ((commonSuffix = dmp.diff_commonSuffix(deletedText, insertedText)) > 0) {
            deletionRange = new Range(deletionRange.getOffset(), deletionRange.getLength() - commonSuffix);
            deletedText = deletedText.substring(0, deletedText.length() - commonSuffix);
            insertionRange = new Range(insertionRange.getOffset(), insertionRange.getLength() - commonSuffix);
            insertedText = insertedText.substring(0, insertedText.length() - commonSuffix);
        }
        DocChange mergeResult = null;
        int startLine = 0;
        int endLine = 0;
        if (docBefore != null) {
            try {
                startLine = docBefore.getLineOfOffset(deletionRange.getOffset());
                endLine = docBefore.getLineOfOffset(deletionRange.getEndOffset());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (deletionRange.getLength() > 0 && insertionRange.getLength() > 0) {
            mergeResult = new Replace(deletionRange.getOffset(), deletionRange.getLength(), startLine, endLine, insertionRange.getLength(), deletedText, insertedText, docBefore);
        } else if (deletionRange.getLength() > 0) {
            mergeResult = new Delete(deletionRange.getOffset(), deletionRange.getLength(), startLine, endLine, deletedText, docBefore);
        } else if (insertionRange.getLength() > 0) {
            Document docAfter = null;
            if (docBefore != null) {
                docAfter = new Document(docBefore.get());
                try {
                    docAfter.replace(insertionRange.getOffset(), 0, insertedText);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    docAfter = null;
                }
            }
            mergeResult = new Insert(insertionRange.getOffset(), insertedText, (IDocument)docAfter);
        }
        if (mergeResult != null) {
            DocChangeWrapper wrapper = new DocChangeWrapper(mergeResult);
            mergeResult = wrapper;
            if (oldEvent instanceof DocChangeWrapper) {
                wrapper.addMergeIds(((DocChangeWrapper)oldEvent).getMergedFrom());
            } else {
                wrapper.addMergeId(oldEvent.getCommandIndex());
            }
            wrapper.addMergeId(newEvent.getCommandIndex());
            mergeResult.setTimestamp(oldEvent.getTimestamp());
            mergeResult.setTimestamp2(newEvent.getTimestamp2());
        }
        return mergeResult;
    }
}

