/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.fluorite.commands;

import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertStringCommand
extends AbstractCommand {
    public static final String XML_Data_Tag = "data";
    private String mData;
    private MyExtendedModifyListener mExtendedModifyListener = new MyExtendedModifyListener();

    public InsertStringCommand(String data) {
        this.mData = data;
    }

    public InsertStringCommand() {
    }

    @Override
    public void dump() {
        System.out.println(this.getName());
    }

    public String getData() {
        return this.mData;
    }

    @Override
    public boolean execute(IEditorPart target) {
        StyledText widget;
        if (this.mData != null && (widget = Utilities.getStyledText(target)) != null) {
            int caretPos = widget.getCaretOffset();
            int selSize = widget.getSelectionCount();
            StyledTextContent content = widget.getContent();
            if (content != null && this.mData.length() > 1) {
                content.replaceTextRange(caretPos, selSize, this.mData);
                widget.setCaretOffset(caretPos + this.mData.length() - selSize);
            } else {
                try {
                    widget.addExtendedModifyListener((ExtendedModifyListener)this.mExtendedModifyListener);
                    this.mExtendedModifyListener.clearCaret();
                    String insertString = this.mData;
                    if (this.mData.equals("\r") || this.mData.equals("\n")) {
                        insertString = widget.getLineDelimiter();
                    }
                    widget.insert(insertString);
                    if (this.mExtendedModifyListener.getCaretOffset() >= 0) {
                        widget.setCaretOffset(this.mExtendedModifyListener.getCaretOffset());
                    }
                }
                finally {
                    widget.removeExtendedModifyListener((ExtendedModifyListener)this.mExtendedModifyListener);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getAttributesMap() {
        return null;
    }

    @Override
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (this.mData != null) {
            dataMap.put(XML_Data_Tag, this.mData);
        }
        return dataMap;
    }

    @Override
    public void createFrom(Element commandElement) {
        Node textNode;
        super.createFrom(commandElement);
        String value = null;
        NodeList nodeList = null;
        nodeList = commandElement.getElementsByTagName(XML_Data_Tag);
        this.mData = nodeList.getLength() > 0 ? ((value = (textNode = nodeList.item(0)).getTextContent()).equals("null") ? null : value) : null;
    }

    @Override
    public String getCommandType() {
        return "InsertStringCommand";
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Insert the string into the document at the current caret location");
        if (this.mData != null) {
            buffer.append("\n");
            buffer.append(this.getName());
        }
        return buffer.toString();
    }

    @Override
    public String getName() {
        String printableData = this.mData;
        if (printableData != null) {
            printableData = printableData.replace("\r", "<CR>");
            printableData = printableData.replace("\n", "<LF>");
            printableData = printableData.replace("\t", "<tab>");
        }
        return "Insert string: " + printableData;
    }

    @Override
    public String getCategory() {
        return "EventLogger utility command";
    }

    @Override
    public String getCategoryID() {
        return "eventlogger.category.utility.command";
    }

    @Override
    public boolean combine(ICommand anotherCommand) {
        if (!(anotherCommand instanceof InsertStringCommand)) {
            return false;
        }
        InsertStringCommand nextCommand = (InsertStringCommand)anotherCommand;
        if (this.mData.indexOf(10) >= 0 || nextCommand.mData.indexOf(10) >= 0 || this.mData.indexOf(13) >= 0 || nextCommand.mData.indexOf(13) >= 0) {
            return false;
        }
        this.mData = String.valueOf(this.mData) + nextCommand.mData;
        return true;
    }

    private static class MyExtendedModifyListener
    implements ExtendedModifyListener {
        private int mCaretPos;

        private MyExtendedModifyListener() {
        }

        public void modifyText(ExtendedModifyEvent event) {
            this.mCaretPos = event.start + event.length;
        }

        public void clearCaret() {
            this.mCaretPos = -1;
        }

        public int getCaretOffset() {
            return this.mCaretPos;
        }
    }
}

