/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.commands.runtime;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.fluorite.commands.document.Delete;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Replace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Segment {
    private int mOffset;
    private int mLength;
    private String mText;
    private boolean mDeletion;
    private String mBelongsTo;
    private RuntimeDC mOwner;
    private int mRelativeOffset;
    private int mOriginalLength;
    private List<Segment> mSegmentsClosedByMe;
    private List<Segment> mRight;
    private static Comparator<Segment> locationComparator;

    public Segment(int offset, int length, String text, String belongsTo, RuntimeDC owner, boolean deletion) {
        this.mOffset = offset;
        this.mLength = length;
        this.mText = text;
        this.mBelongsTo = belongsTo;
        this.mOwner = owner;
        this.mDeletion = deletion;
        this.mRelativeOffset = -1;
        this.mOriginalLength = -1;
        this.mSegmentsClosedByMe = new ArrayList<Segment>();
        this.mRight = new ArrayList<Segment>();
    }

    public static Segment createInitialSegmentFromInsert(Insert insert, RuntimeDC owner) {
        return new Segment(insert.getOffset(), insert.getLength(), insert.getText(), RuntimeHistoryManager.getInstance().getCurrentFile(), owner, false);
    }

    public static Segment createInitialSegmentFromDelete(Delete delete, RuntimeDC owner) {
        return new Segment(delete.getOffset(), delete.getLength(), delete.getText(), RuntimeHistoryManager.getInstance().getCurrentFile(), owner, true);
    }

    public static Segment createInitialDeleteSegmentFromReplace(Replace replace, RuntimeDC owner) {
        return new Segment(replace.getOffset(), replace.getLength(), replace.getDeletedText(), RuntimeHistoryManager.getInstance().getCurrentFile(), owner, true);
    }

    public static Segment createInitialInsertSegmentFromReplace(Replace replace, RuntimeDC owner) {
        return new Segment(replace.getOffset(), replace.getInsertionLength(), replace.getInsertedText(), RuntimeHistoryManager.getInstance().getCurrentFile(), owner, false);
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void incrementOffset(int amount) {
        if (this.mOffset + amount < 0) {
            throw new IllegalArgumentException();
        }
        this.mOffset += amount;
    }

    public void decrementOffset(int amount) {
        if (this.mOffset - amount < 0) {
            throw new IllegalArgumentException();
        }
        this.mOffset -= amount;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        this.mOffset = offset;
    }

    public int getLength() {
        return this.mLength;
    }

    private void setLength(int length) {
        this.mLength = length;
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public int getEffectiveEndOffset() {
        return this.isDeletion() ? this.getOffset() : this.getEndOffset();
    }

    public String getText() {
        return this.mText;
    }

    private void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        this.mText = text;
    }

    public String getBelongsTo() {
        return this.mBelongsTo;
    }

    public boolean mergeWithSegment(Segment followingSegment) {
        if (followingSegment == null) {
            return false;
        }
        if (followingSegment.getOffset() != this.getEndOffset()) {
            return false;
        }
        this.setLength(this.getLength() + followingSegment.getLength());
        this.setText(String.valueOf(this.getText()) + followingSegment.getText());
        return true;
    }

    public Segment subSegment(int offset, int length) {
        if (offset < this.getOffset() || offset + length > this.getEndOffset()) {
            throw new IllegalArgumentException();
        }
        return new Segment(offset, length, this.getText().substring(offset - this.getOffset(), offset - this.getOffset() + length), this.getBelongsTo(), this.getOwner(), this.isDeletion());
    }

    public Segment subSegment(int offset) {
        if (offset < this.getOffset() || offset > this.getEndOffset()) {
            throw new IllegalArgumentException();
        }
        return this.subSegment(offset, this.getEndOffset() - offset);
    }

    public boolean cutDown(int offset, int length) {
        if (offset < this.getOffset() || offset + length > this.getEndOffset()) {
            throw new IllegalArgumentException();
        }
        this.setLength(this.getLength() - length);
        this.setText(String.valueOf(this.getText().substring(0, offset - this.getOffset())) + this.getText().substring(offset - this.getOffset() + length));
        return true;
    }

    public boolean cutDown(int offset) {
        if (offset < this.getOffset() || offset > this.getEndOffset()) {
            throw new IllegalArgumentException();
        }
        return this.cutDown(offset, this.getEndOffset() - offset);
    }

    public RuntimeDC getOwner() {
        return this.mOwner;
    }

    public void setOwner(RuntimeDC owner) {
        this.mOwner = owner;
    }

    public boolean isDeletion() {
        return this.mDeletion;
    }

    public void setRelativeOffset(int relativeOffset) {
        this.mRelativeOffset = relativeOffset;
    }

    public int getRelativeOffset() {
        return this.mRelativeOffset;
    }

    public void setOriginalLength(int originalLength) {
        this.mOriginalLength = originalLength;
    }

    public int getOriginalLength() {
        return this.mOriginalLength;
    }

    public void close(int relativeOffset) {
        if (relativeOffset < 0) {
            throw new IllegalArgumentException("relative offset should be no less than zero!");
        }
        this.setRelativeOffset(relativeOffset);
        if (!this.isDeletion()) {
            this.setOriginalLength(this.getLength());
            this.setLength(0);
        }
    }

    public void reopen(int baseOffset) {
        if (this.getRelativeOffset() == -1) {
            throw new IllegalStateException("Segment must be closed when reopen method is called");
        }
        this.setOffset(baseOffset + this.getRelativeOffset());
        this.setRelativeOffset(-1);
        if (!this.isDeletion()) {
            this.setLength(this.getOriginalLength());
            this.setOriginalLength(-1);
        }
    }

    public void closeSegment(Segment toBeClosed) {
        if (toBeClosed.getRelativeOffset() == -1) {
            toBeClosed.close(toBeClosed.getOffset() - this.getOffset());
            this.addSegmentClosedByMe(toBeClosed);
        }
        toBeClosed.setOffset(this.getOffset());
    }

    public void addSegmentClosedByMe(Segment closedSegment) {
        if (!this.isDeletion()) {
            throw new RuntimeException("addSegmentClosedByMe method should only be called on a DELETE segment.");
        }
        this.mSegmentsClosedByMe.add(closedSegment);
    }

    public List<Segment> getSegmentsClosedByMe() {
        return Collections.unmodifiableList(this.mSegmentsClosedByMe);
    }

    public void addRight(Segment right) {
        this.mRight.add(right);
    }

    public List<Segment> getRight() {
        return Collections.unmodifiableList(this.mRight);
    }

    public Segment copySegment() {
        Segment copy = new Segment(this.mOffset, this.mLength, this.mText, this.mBelongsTo, this.mOwner, this.mDeletion);
        copy.mRelativeOffset = this.mRelativeOffset;
        copy.mOriginalLength = this.mOriginalLength;
        copy.mSegmentsClosedByMe = new ArrayList<Segment>();
        return copy;
    }

    public boolean inSelectionRange(int selectionStart, int selectionEnd) {
        if (this.isDeletion()) {
            return selectionStart < this.getOffset() && this.getOffset() < selectionEnd;
        }
        return this.getOffset() < selectionEnd && this.getEndOffset() > selectionStart;
    }

    public static Comparator<Segment> getLocationComparator() {
        if (locationComparator == null) {
            locationComparator = new Comparator<Segment>(){

                @Override
                public int compare(Segment lhs, Segment rhs) {
                    if (lhs.getOffset() < rhs.getOffset()) {
                        return -1;
                    }
                    if (lhs.getOffset() > rhs.getOffset()) {
                        return 1;
                    }
                    if (lhs.getEffectiveEndOffset() < rhs.getEffectiveEndOffset()) {
                        return -1;
                    }
                    if (lhs.getEffectiveEndOffset() > rhs.getEffectiveEndOffset()) {
                        return 1;
                    }
                    if (lhs.getOwner().getOriginal().getSessionId() < rhs.getOwner().getOriginal().getSessionId()) {
                        return -1;
                    }
                    if (lhs.getOwner().getOriginal().getSessionId() > rhs.getOwner().getOriginal().getSessionId()) {
                        return 1;
                    }
                    if (lhs.getOwner().getOriginal().getCommandIndex() < rhs.getOwner().getOriginal().getCommandIndex()) {
                        return -1;
                    }
                    if (lhs.getOwner().getOriginal().getCommandIndex() > rhs.getOwner().getOriginal().getCommandIndex()) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
        return locationComparator;
    }
}

