/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.dialogs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AboutDialog
extends Dialog {
    private static final String TITLE = "About Azurite";
    private static final String CLOSE_BUTTON_TEXT = "Close";
    private static final int CLOSE_BUTTON_ID = 0;
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 550;

    public AboutDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2101);
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle screenBounds = this.getShell().getDisplay().getBounds();
        return new Point((screenBounds.width - initialSize.x) / 2, (screenBounds.height - initialSize.y) / 2);
    }

    protected Point getInitialSize() {
        return new Point(600, 550);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TITLE);
        this.getShell().setMinimumSize(600, 550);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 550;
        comp.setLayoutData((Object)gridData);
        Browser browser = new Browser(comp, 0);
        browser.setLayoutData((Object)new GridData(1808));
        Color bg = comp.getBackground();
        String rgb = "rgb(" + bg.getRed() + "," + bg.getGreen() + "," + bg.getBlue() + ")";
        try {
            String line;
            URL indexUrl = FileLocator.toFileURL((URL)Platform.getBundle((String)"edu.cmu.scs.azurite").getEntry("/html/about.html"));
            BufferedReader in = new BufferedReader(new InputStreamReader(indexUrl.openStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(String.valueOf(line) + "\n");
            }
            in.close();
            String additionalCSS = "<style>body { background: " + rgb + "; }</style>";
            browser.setText(String.valueOf(builder.toString()) + additionalCSS);
            browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    try {
                        URL url = new URL(event.location);
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                        event.doit = false;
                    }
                    catch (MalformedURLException | PartInitException e) {
                        e.printStackTrace();
                    }
                }

                public void changed(LocationEvent event) {
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, CLOSE_BUTTON_TEXT, true);
    }
}

