/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model.undo;

import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.undo.Chunk;
import edu.cmu.scs.azurite.model.undo.UndoAlternative;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;

public class SelectiveUndoParams {
    private List<Chunk> mChunks;
    private IDocument mDocument;
    private FileKey mFileKey;
    private Map<Chunk, UndoAlternative> mAlternativeChoices;

    public SelectiveUndoParams(List<Chunk> chunks, IDocument doc, Map<Chunk, UndoAlternative> alternativeChoices) {
        if (chunks == null || chunks.isEmpty() || doc == null) {
            throw new IllegalArgumentException();
        }
        this.mChunks = new ArrayList<Chunk>(chunks);
        this.mDocument = doc;
        this.mFileKey = chunks.get(0).getBelongsTo();
        this.mAlternativeChoices = Collections.unmodifiableMap(alternativeChoices);
    }

    public List<Chunk> getChunks() {
        return this.mChunks;
    }

    public IDocument getDocument() {
        return this.mDocument;
    }

    public FileKey getFileKey() {
        return this.mFileKey;
    }

    public Map<Chunk, UndoAlternative> getAlternativeChoices() {
        return this.mAlternativeChoices;
    }
}

