/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.viewers;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.compare.AzuriteCompareInput;
import edu.cmu.scs.azurite.compare.SimpleCompareItem;
import edu.cmu.scs.azurite.jface.dialogs.InteractiveSelectiveUndoDialog;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.undo.Chunk;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoEngine;
import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import edu.cmu.scs.fluorite.commands.CodeHistoryDiffRevertCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.util.Utilities;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CodeHistoryDiffViewer
extends Composite {
    private CompareViewerSwitchingPane mCompareViewerSwitchingPane;
    private CompareConfiguration mConfiguration;
    private List<RuntimeDC> mInvolvedDCs;
    private SimpleCompareItem mCurrentItem;
    private Map<Integer, SimpleCompareItem> mHistoryItems;
    private String mTitle;
    private String mFileContent;
    private String mSelectionText;
    private int mSelectionStart;
    private int mSelectionEnd;
    private int mSelectionLength;
    private FileKey mFileKey;
    private IViewPart mParentViewPart;
    private int mCurrentVersion;
    private ActionContributionItem mRevertAction;
    private ActionContributionItem mPrevAction;
    private ActionContributionItem mNextAction;
    private ActionContributionItem mInteractiveSelectiveUndoAction;

    public CodeHistoryDiffViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
    }

    public void setParameters(IViewPart parentViewPart, CompareConfiguration configuration, String title, String fileContent, int selectionStart, int selectionEnd, List<RuntimeDC> involvedDCs, FileKey key) {
        if (involvedDCs == null || involvedDCs.isEmpty()) {
            throw new IllegalArgumentException("No history!");
        }
        this.mParentViewPart = parentViewPart;
        this.mConfiguration = configuration;
        this.mInvolvedDCs = new ArrayList<RuntimeDC>();
        this.mInvolvedDCs.addAll(involvedDCs);
        Collections.sort(this.mInvolvedDCs, RuntimeDC.getCommandIDComparator());
        this.mTitle = title;
        this.mFileContent = fileContent;
        this.mSelectionStart = selectionStart;
        this.mSelectionEnd = selectionEnd;
        this.mSelectionLength = this.mSelectionEnd - this.mSelectionStart;
        this.mSelectionText = fileContent.substring(selectionStart, selectionEnd);
        this.mCurrentItem = new SimpleCompareItem("[" + this.mInvolvedDCs.size() + "] Current Version", this.mSelectionText, false);
        this.mHistoryItems = new HashMap<Integer, SimpleCompareItem>();
        this.mFileKey = key;
    }

    public void create() {
        this.createActions();
        this.mCompareViewerSwitchingPane = this.createCompareView(this);
        this.selectVersion(this.mInvolvedDCs.size(), true);
    }

    private void createActions() {
        this.mRevertAction = new ActionContributionItem((IAction)new Action("Revert", Activator.getImageDescriptor("icons/old_edit_undo.png")){

            public void run() {
                CodeHistoryDiffViewer.this.revertToCurrentVersion();
            }
        });
        this.mRevertAction.setId("historyDiffRevert");
        this.mRevertAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.mPrevAction = new ActionContributionItem((IAction)new Action("Prev", Activator.getImageDescriptor("icons/old_go_previous.png")){

            public void run() {
                CodeHistoryDiffViewer.this.selectPrevVersion();
            }
        });
        this.mPrevAction.setId("historyDiffPrev");
        this.mPrevAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.mNextAction = new ActionContributionItem((IAction)new Action("Next", Activator.getImageDescriptor("icons/old_go_next.png")){

            public void run() {
                CodeHistoryDiffViewer.this.selectNextVersion();
            }
        });
        this.mNextAction.setId("historyDiffNext");
        this.mNextAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.mInteractiveSelectiveUndoAction = new ActionContributionItem((IAction)new Action("Interactive Selective Undo", Activator.getImageDescriptor("icons/undo_in_region.png")){

            public void run() {
                CodeHistoryDiffViewer.this.launchInteractiveSelectiveUndoWithCurrentVersion();
            }
        });
        this.mInteractiveSelectiveUndoAction.setId("historyDiffLaunchISU");
        this.mInteractiveSelectiveUndoAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
    }

    private CompareViewerSwitchingPane createCompareView(Composite parent) {
        CompareViewerSwitchingPane compareView = new CompareViewerSwitchingPane(parent, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                IContributionItem[] items;
                Viewer v = CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, (CompareConfiguration)CodeHistoryDiffViewer.this.mConfiguration);
                v.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)CodeHistoryDiffViewer.this.mTitle);
                ToolBarManager tbm = CompareViewerSwitchingPane.getToolBarManager((Composite)this);
                String navGroupId = "historyDiffNav";
                String commandGroupId = "historyDiffCmd";
                boolean added = false;
                IContributionItem[] iContributionItemArray = items = tbm.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (navGroupId.equals(item.getId())) {
                        added = true;
                        break;
                    }
                    ++n2;
                }
                if (!added) {
                    tbm.removeAll();
                    tbm.add((IContributionItem)CodeHistoryDiffViewer.this.mInteractiveSelectiveUndoAction);
                    tbm.add((IContributionItem)new Separator(commandGroupId));
                    tbm.add((IContributionItem)CodeHistoryDiffViewer.this.mRevertAction);
                    tbm.add((IContributionItem)new Separator(navGroupId));
                    tbm.appendToGroup(navGroupId, (IContributionItem)CodeHistoryDiffViewer.this.mPrevAction);
                    tbm.appendToGroup(navGroupId, (IContributionItem)CodeHistoryDiffViewer.this.mNextAction);
                    tbm.update(true);
                }
                return v;
            }
        };
        compareView.setLayoutData((Object)new GridData(4, 4, true, true));
        return compareView;
    }

    private int getCurrentVersion() {
        return this.mCurrentVersion;
    }

    private void selectPrevVersion() {
        int collapseLevel;
        if (this.getCurrentVersion() == 0) {
            return;
        }
        TimelineViewPart timeline = TimelineViewPart.getInstance();
        int n = collapseLevel = timeline != null ? timeline.getCurrentCollapseLevel() : -1;
        if (collapseLevel == -1) {
            this.selectVersion(this.getCurrentVersion() - 1, true);
            return;
        }
        int targetVersion = this.getCurrentVersion() - 1;
        int collapseID = this.mInvolvedDCs.get(targetVersion).getCollapseID(collapseLevel);
        while (targetVersion > 0 && this.mInvolvedDCs.get(targetVersion - 1).getCollapseID(collapseLevel) == collapseID) {
            --targetVersion;
        }
        this.selectVersion(targetVersion, true);
    }

    private void selectNextVersion() {
        int collapseLevel;
        if (this.getCurrentVersion() == this.mInvolvedDCs.size()) {
            return;
        }
        TimelineViewPart timeline = TimelineViewPart.getInstance();
        int n = collapseLevel = timeline != null ? timeline.getCurrentCollapseLevel() : -1;
        if (collapseLevel == -1) {
            this.selectVersion(this.getCurrentVersion() + 1, true);
            return;
        }
        int collapseID = this.mInvolvedDCs.get(this.getCurrentVersion()).getCollapseID(collapseLevel);
        int targetVersion = this.getCurrentVersion() + 1;
        while (targetVersion < this.mInvolvedDCs.size() && this.mInvolvedDCs.get(targetVersion).getCollapseID(collapseLevel) == collapseID) {
            ++targetVersion;
        }
        this.selectVersion(targetVersion, true);
    }

    private void selectVersion(int version, boolean moveMarker) {
        if (this.mCompareViewerSwitchingPane == null) {
            throw new IllegalStateException();
        }
        if (this.getCurrentVersion() == version) {
            return;
        }
        SimpleCompareItem rightItem = this.getCompareItemOfVersion(version);
        this.mCompareViewerSwitchingPane.setInput((Object)new AzuriteCompareInput(this.mCurrentItem, rightItem));
        this.mCurrentVersion = version;
        if (TimelineViewPart.getInstance() != null && moveMarker) {
            if (version == this.mInvolvedDCs.size()) {
                RuntimeDC dc = this.mInvolvedDCs.get(this.mInvolvedDCs.size() - 1);
                TimelineViewPart.getInstance().showMarkerAtTimestamp(dc.getOriginal().getSessionId() + dc.getOriginal().getTimestamp2() + 1L);
            } else {
                RuntimeDC dc = this.mInvolvedDCs.get(version);
                TimelineViewPart.getInstance().showMarkerAtTimestamp(dc.getOriginal().getSessionId() + dc.getOriginal().getTimestamp());
            }
        }
    }

    private void launchInteractiveSelectiveUndoWithCurrentVersion() {
        List<RuntimeDC> subList = this.mInvolvedDCs.subList(this.getCurrentVersion(), this.mInvolvedDCs.size());
        TimelineViewPart timeline = TimelineViewPart.getInstance();
        if (timeline != null) {
            List<OperationId> ids = OperationId.getOperationIdsFromRuntimeDCs(subList);
            timeline.addSelection(ids, true);
            InteractiveSelectiveUndoDialog.launch();
            this.closeParentView();
        }
    }

    private void revertToCurrentVersion() {
        if (this.getCurrentVersion() != this.mInvolvedDCs.size()) {
            File fileToOpen = new File(this.mFileKey.getFilePath());
            IEditorPart editor = null;
            if (fileToOpen.exists() && fileToOpen.isFile()) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException partInitException) {}
            }
            if (editor != null) {
                IDocument doc = Utilities.getDocument(editor);
                try {
                    doc.replace(this.mSelectionStart, this.mSelectionLength, this.getCompareItemOfVersion(this.getCurrentVersion()).getStringContents());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        EventRecorder.getInstance().recordCommand((ICommand)new CodeHistoryDiffRevertCommand());
        this.closeParentView();
    }

    public void closeParentView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            page.hideView(this.mParentViewPart);
        }
    }

    public void selectVersionWithAbsTimestamp(long absTimestamp) {
        int i = 0;
        while (i < this.mInvolvedDCs.size()) {
            long t = this.mInvolvedDCs.get(i).getOriginal().getSessionId() + this.mInvolvedDCs.get(i).getOriginal().getTimestamp();
            if (absTimestamp <= t) {
                this.selectVersion(i, false);
                return;
            }
            ++i;
        }
        this.selectVersion(this.mInvolvedDCs.size(), false);
    }

    private SimpleCompareItem getCompareItemOfVersion(int version) {
        if (version < 0 || version > this.mInvolvedDCs.size()) {
            throw new IllegalArgumentException("Version out of range!");
        }
        if (version == this.mInvolvedDCs.size()) {
            return this.mCurrentItem;
        }
        List<RuntimeDC> subList = this.mInvolvedDCs.subList(version, this.mInvolvedDCs.size());
        Chunk chunk = this.isEntireFileSelected() ? Chunk.fromDCList(subList) : Chunk.fromDCList(subList, this.mSelectionStart, this.mSelectionEnd);
        int startOffset = chunk.getStartOffset();
        int endOffset = chunk.getEndOffset();
        String initialContent = this.mFileContent.substring(startOffset, endOffset);
        String undoResult = SelectiveUndoEngine.getInstance().doSelectiveUndoChunkWithoutConflicts(chunk, initialContent);
        StringBuilder historyContent = new StringBuilder(this.mSelectionText);
        historyContent.replace(Math.max(startOffset - this.mSelectionStart, 0), Math.min(endOffset - this.mSelectionStart, this.mSelectionLength), undoResult);
        DocChange originalDC = this.mInvolvedDCs.get(version).getOriginal();
        Date date = new Date(originalDC.getSessionId() + originalDC.getTimestamp());
        String dateString = DateFormat.getDateTimeInstance().format(date);
        SimpleCompareItem historyItem = new SimpleCompareItem("[" + version + "/" + this.mInvolvedDCs.size() + "] " + dateString + " (id:" + originalDC.getCommandIndex() + ")", historyContent.toString(), false);
        this.mHistoryItems.put(version, historyItem);
        return historyItem;
    }

    private boolean isEntireFileSelected() {
        return this.mSelectionStart == 0 && this.mSelectionEnd == this.mFileContent.length();
    }
}

