/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model.grouper;

import edu.cmu.scs.azurite.model.grouper.BaseChangeInformation;
import edu.cmu.scs.azurite.model.grouper.ChangeKind;
import edu.cmu.scs.azurite.model.grouper.IChangeInformation;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Range;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;

public class ChangeTypeInformation
extends BaseChangeInformation {
    private final AbstractTypeDeclaration preTypeNode;
    private final AbstractTypeDeclaration postTypeNode;

    public ChangeTypeInformation(DocChange mergedChange, AbstractTypeDeclaration preTypeNode, Range preTypeRange, AbstractTypeDeclaration postTypeNode) {
        super(mergedChange);
        this.preTypeNode = preTypeNode;
        this.postTypeNode = postTypeNode;
        this.setPreRange(preTypeRange);
    }

    @Override
    public ChangeKind getChangeKind() {
        return ChangeKind.CHANGE_TYPE;
    }

    @Override
    public String getChangeSummary() {
        String typeName = this.getTypeName(this.getPostNode());
        String typeKind = this.getTypeKind(this.getPostNode());
        if (typeName != null && typeKind != null) {
            return String.format("Changed %s '%s'", typeKind, typeName);
        }
        if (typeKind != null) {
            return String.format("Changed an unknown %s", typeKind);
        }
        if (typeName != null) {
            return String.format("Changed %s", typeName);
        }
        return "Changed an unknown type";
    }

    @Override
    public boolean shouldBeMerged(int level, IChangeInformation nextChange) {
        switch (level) {
            case 1: {
                return false;
            }
            case 2: {
                switch (nextChange.getChangeKind()) {
                    case CHANGE_TYPE: 
                    case DELETE_TYPE: 
                    case ADD_METHOD: 
                    case CHANGE_METHOD: 
                    case DELETE_METHOD: 
                    case ADD_FIELD: 
                    case CHANGE_FIELD: 
                    case DELETE_FIELD: {
                        return this.getPostTypeRange().equals((Object)nextChange.getPreTypeRange());
                    }
                }
                return false;
            }
        }
        return false;
    }

    public AbstractTypeDeclaration getPreNode() {
        return this.preTypeNode;
    }

    public AbstractTypeDeclaration getPostNode() {
        return this.postTypeNode;
    }

    @Override
    public Range getPreTypeRange() {
        if (this.getMergedChange() != null) {
            return this.getMergedChange().applyInverse(this.getPostTypeRange());
        }
        return this.getPostTypeRange();
    }

    @Override
    public Range getPostTypeRange() {
        return new Range((ASTNode)this.getEnclosingType((ASTNode)this.getPostNode()));
    }
}

