/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model.grouper;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.RuntimeDCListener;
import edu.cmu.scs.azurite.model.grouper.AddFieldInformation;
import edu.cmu.scs.azurite.model.grouper.AddImportStatementInformation;
import edu.cmu.scs.azurite.model.grouper.AddMethodInformation;
import edu.cmu.scs.azurite.model.grouper.AddTypeInformation;
import edu.cmu.scs.azurite.model.grouper.BaseChangeInformation;
import edu.cmu.scs.azurite.model.grouper.ChangeFieldInformation;
import edu.cmu.scs.azurite.model.grouper.ChangeMethodInformation;
import edu.cmu.scs.azurite.model.grouper.ChangeTypeInformation;
import edu.cmu.scs.azurite.model.grouper.DeleteFieldInformation;
import edu.cmu.scs.azurite.model.grouper.DeleteImportStatementInformation;
import edu.cmu.scs.azurite.model.grouper.DeleteMethodInformation;
import edu.cmu.scs.azurite.model.grouper.DeleteTypeInformation;
import edu.cmu.scs.azurite.model.grouper.IChangeInformation;
import edu.cmu.scs.azurite.model.grouper.NonCodeChangeInformation;
import edu.cmu.scs.azurite.model.grouper.OperationGrouperListener;
import edu.cmu.scs.azurite.model.grouper.UnknownInformation;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Range;
import edu.cmu.scs.fluorite.model.Events;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class OperationGrouper
implements RuntimeDCListener {
    private static final int MERGE_TIME_THRESHOLD = 2000;
    private static final boolean MERGE_WHITESPACES = true;
    public static final int LEVEL_PARSABLE = 0;
    public static final int LEVEL_METHOD = 1;
    public static final int LEVEL_TYPE = 2;
    public static final int NUM_LEVELS = 3;
    private Map<FileKey, Document>[] knownSnapshots;
    private FileKey currentFile;
    private List<RuntimeDC>[] pendingChangesList;
    private DocChange[] mergedPendingChanges;
    private IChangeInformation[] pendingChangeInformation;
    private ListenerList listeners;

    public OperationGrouper() {
        this.clearData();
        this.listeners = new ListenerList();
    }

    public void clearData() {
        this.knownSnapshots = new Map[3];
        this.pendingChangesList = new ArrayList[3];
        int i = 0;
        while (i < 3) {
            this.knownSnapshots[i] = new HashMap<FileKey, Document>();
            this.pendingChangesList[i] = new ArrayList<RuntimeDC>();
            ++i;
        }
        this.currentFile = null;
        this.mergedPendingChanges = new DocChange[3];
        Arrays.fill(this.mergedPendingChanges, null);
        this.pendingChangeInformation = new IChangeInformation[3];
        Arrays.fill(this.pendingChangeInformation, null);
    }

    @Override
    public void activeFileChanged(FileKey fileKey, String snapshot) {
        this.flushAllPendingChanges();
        this.currentFile = fileKey;
        if (snapshot != null) {
            int i = 0;
            while (i < 3) {
                if (!this.knownSnapshots[i].containsKey(fileKey)) {
                    this.knownSnapshots[i].put(fileKey, new Document(snapshot));
                }
                ++i;
            }
        }
    }

    public void flushAllPendingChanges() {
        int level = 0;
        while (level < 3) {
            this.flushPendingChanges(level);
            ++level;
        }
    }

    @Override
    public void runtimeDCAdded(RuntimeDC dc) {
        Document currentSnapshot = this.getCurrentSnapshot(0);
        if (currentSnapshot == null) {
            return;
        }
        this.processRuntimeDCs(0, Collections.singletonList(dc));
    }

    @Override
    public void documentChangeAdded(DocChange docChange) {
    }

    @Override
    public void documentChangeUpdated(DocChange docChange) {
    }

    @Override
    public void documentChangeAmended(DocChange oldDocChange, DocChange newDocChange) {
    }

    @Override
    public void pastLogsRead(List<Events> listEvents) {
    }

    @Override
    public void codingEventOccurred(ICommand command) {
        this.flushAllPendingChanges();
    }

    private Document getCurrentSnapshot(int level) {
        return this.knownSnapshots[level].containsKey(this.currentFile) ? this.knownSnapshots[level].get(this.currentFile) : null;
    }

    private void processRuntimeDCs(int level, List<RuntimeDC> dcs) {
        Document docBefore = this.getCurrentSnapshot(level);
        if (this.mergedPendingChanges[level] != null) {
            docBefore = new Document(docBefore.get());
            this.mergedPendingChanges[level].apply((IDocument)docBefore);
        }
        DocChange mergedChange = RuntimeDC.mergeChanges(dcs, (IDocument)docBefore);
        if (this.pendingChangesList[level].isEmpty() || this.shouldBeMerged(level, dcs, mergedChange)) {
            this.addPendingChanges(level, dcs, mergedChange);
        } else {
            this.flushPendingChanges(level);
            this.addPendingChanges(level, dcs, mergedChange);
        }
    }

    private void addPendingChanges(int level, List<RuntimeDC> dcs, DocChange mergedChange) {
        Document docBefore = this.getCurrentSnapshot(level);
        this.pendingChangesList[level].addAll(dcs);
        this.mergedPendingChanges[level] = DocChange.mergeChanges((DocChange)this.mergedPendingChanges[level], (DocChange)mergedChange, (IDocument)docBefore);
        RuntimeDC firstDC = this.pendingChangesList[level].get(0);
        int firstId = firstDC.getOriginal().getCommandIndex();
        this.updateCollapseIDs(dcs, level, firstDC, firstId);
    }

    private void updateCollapseIDs(List<RuntimeDC> dcs, int level, RuntimeDC collapseDC, int collapseID) {
        IChangeInformation ci;
        DocChange mergedChange = this.mergedPendingChanges[level];
        this.pendingChangeInformation[level] = ci = mergedChange != null ? OperationGrouper.determineChangeKind(level, this.getCurrentSnapshot(level).get(), mergedChange) : null;
        int i = level;
        while (i < 3) {
            collapseDC.setChangeInformation(i, ci);
            for (RuntimeDC dc : dcs) {
                if (dc == collapseDC) continue;
                dc.setCollapseID(i, collapseID);
                dc.setChangeInformation(i, null);
            }
            this.fireCollapseIDsUpdatedEvent(dcs, i, collapseID, ci);
            ++i;
        }
    }

    private boolean shouldBeMerged(int level, List<RuntimeDC> dcs, DocChange mergedChange) {
        switch (level) {
            case 0: {
                return this.shouldBeMergedLevel0(dcs, mergedChange);
            }
            case 1: {
                return this.shouldBeMergedLevel1(dcs, mergedChange);
            }
            case 2: {
                return this.shouldBeMergedLevel2(dcs, mergedChange);
            }
        }
        throw new UnsupportedOperationException();
    }

    private boolean shouldBeMergedLevel0(List<RuntimeDC> dcs, DocChange mergedChange) {
        Document docIntermediate;
        DocChange newEvent;
        DocChange oldEvent;
        block6: {
            if (dcs == null || dcs.size() != 1 || dcs.get(0) == null || dcs.get(0).getOriginal() == null) {
                throw new IllegalArgumentException();
            }
            if (this.mergedPendingChanges[0] == null) {
                return true;
            }
            Document docBefore = this.getCurrentSnapshot(0);
            oldEvent = this.mergedPendingChanges[0];
            newEvent = dcs.get(0).getOriginal();
            docIntermediate = new Document(docBefore.get());
            oldEvent.apply((IDocument)docIntermediate);
            try {
                Document doc = new Document(docBefore.get());
                oldEvent.apply((IDocument)doc);
                if (!DocChange.overlap((DocChange)oldEvent, (DocChange)newEvent) && docIntermediate.getLineOfOffset(oldEvent.getInsertionRange().getEndOffset()) != docIntermediate.getLineOfOffset(newEvent.getDeletionRange().getOffset()) && docIntermediate.getLineOfOffset(oldEvent.getInsertionRange().getOffset()) != docIntermediate.getLineOfOffset(newEvent.getDeletionRange().getEndOffset())) {
                    return false;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                if (DocChange.overlap((DocChange)oldEvent, (DocChange)newEvent)) break block6;
                return false;
            }
        }
        if (!this.isLocallyParsable(docIntermediate.get(), oldEvent)) {
            return true;
        }
        return newEvent.getTimestamp() - oldEvent.getTimestamp2() < 2000L;
    }

    private boolean shouldBeMergedLevel1(List<RuntimeDC> dcs, DocChange mergedChange) {
        int level = 1;
        if (this.mergedPendingChanges[level] == null || mergedChange == null) {
            return true;
        }
        if (this.pendingChangeInformation[level] == null) {
            this.pendingChangeInformation[level] = OperationGrouper.determineChangeKind(level, this.getCurrentSnapshot(level).get(), this.mergedPendingChanges[level]);
        }
        IChangeInformation prevChange = this.pendingChangeInformation[level];
        IChangeInformation nextChange = OperationGrouper.determineChangeKind(level, this.getCurrentSnapshot(level - 1).get(), mergedChange);
        if (prevChange != null && nextChange != null) {
            return prevChange.shouldBeMerged(level, nextChange);
        }
        return false;
    }

    private boolean shouldBeMergedLevel2(List<RuntimeDC> dcs, DocChange mergedChange) {
        int level = 2;
        if (this.mergedPendingChanges[level] == null || mergedChange == null) {
            return true;
        }
        if (this.pendingChangeInformation[level] == null) {
            this.pendingChangeInformation[level] = OperationGrouper.determineChangeKind(level, this.getCurrentSnapshot(level).get(), this.mergedPendingChanges[level]);
        }
        IChangeInformation prevChange = this.pendingChangeInformation[level];
        IChangeInformation nextChange = OperationGrouper.determineChangeKind(level, this.getCurrentSnapshot(level - 1).get(), mergedChange);
        if (prevChange != null && nextChange != null) {
            return prevChange.shouldBeMerged(level, nextChange);
        }
        return false;
    }

    private static IChangeInformation determineChangeKind(int level, String preSnapshot, DocChange docChange) {
        Range preRange = docChange.getDeletionRange();
        ASTNode preRoot = OperationGrouper.parseSnapshot(preSnapshot);
        NodeFinder preFinder = new NodeFinder(preRoot, preRange.getOffset(), preRange.getLength());
        ASTNode preCovered = preFinder.getCoveredNode();
        Range postRange = docChange.getInsertionRange();
        String postSnapshot = docChange.apply(preSnapshot);
        ASTNode postRoot = OperationGrouper.parseSnapshot(postSnapshot);
        NodeFinder postFinder = new NodeFinder(postRoot, postRange.getOffset(), postRange.getLength());
        ASTNode postCovered = postFinder.getCoveredNode();
        ASTNode postCovering = postFinder.getCoveringNode();
        if (preCovered == null && OperationGrouper.getNodeType(postCovered) == 26) {
            return new AddImportStatementInformation(docChange);
        }
        if (OperationGrouper.getNodeType(preCovered) == 26 && postCovered == null) {
            return new DeleteImportStatementInformation(docChange);
        }
        if (preCovered == null && OperationGrouper.getNodeType(postCovered) == 23) {
            return new AddFieldInformation(docChange, (FieldDeclaration)postCovered);
        }
        if (OperationGrouper.getNodeType(preCovered) == 23 && postCovered == null) {
            return new DeleteFieldInformation(docChange, (FieldDeclaration)preCovered);
        }
        BaseChangeInformation ci = OperationGrouper.determineChangeKindChange(preRoot, postCovering, docChange, ChangeFieldInformation.class, FieldDeclaration.class);
        if (ci != null) {
            return ci;
        }
        if (preCovered == null && postCovered != null && postCovered.getNodeType() == 31) {
            return new AddMethodInformation(docChange, (MethodDeclaration)postCovered);
        }
        if (preCovered != null && preCovered.getNodeType() == 31 && postCovered == null) {
            return new DeleteMethodInformation(docChange, (MethodDeclaration)preCovered);
        }
        ci = OperationGrouper.determineChangeKindChange(preRoot, postCovering, docChange, ChangeMethodInformation.class, MethodDeclaration.class);
        if (ci != null) {
            return ci;
        }
        if (preCovered == null && postCovered != null && postCovered instanceof AbstractTypeDeclaration) {
            return new AddTypeInformation(docChange, (AbstractTypeDeclaration)postCovered);
        }
        if (preCovered != null && preCovered instanceof AbstractTypeDeclaration && postCovered == null) {
            return new DeleteTypeInformation(docChange, (AbstractTypeDeclaration)preCovered);
        }
        ci = OperationGrouper.determineChangeKindChange(preRoot, postCovering, docChange, ChangeTypeInformation.class, AbstractTypeDeclaration.class);
        if (ci != null) {
            return ci;
        }
        if (preRoot.toString().equals(postRoot.toString())) {
            return new NonCodeChangeInformation(docChange);
        }
        return new UnknownInformation(docChange);
    }

    private static <CT extends IChangeInformation, AT extends ASTNode> CT determineChangeKindChange(ASTNode preRoot, ASTNode postCovering, DocChange docChange, Class<CT> changeInfoClass, Class<AT> astClass) {
        ASTNode node = postCovering;
        while (node != null) {
            if (astClass.isInstance(node)) {
                Range postRange = new Range(node);
                Range preRange = null;
                ASTNode preNode = null;
                try {
                    preRange = docChange.applyInverse(postRange);
                    preNode = NodeFinder.perform((ASTNode)preRoot, (ISourceRange)preRange);
                    if (!astClass.isInstance(preNode)) {
                        preNode = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Constructor<CT> cinfo = changeInfoClass.getConstructor(DocChange.class, astClass, Range.class, astClass);
                    return (CT)((IChangeInformation)cinfo.newInstance(docChange, preNode, preRange, node));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            node = node.getParent();
        }
        return null;
    }

    private static int getNodeType(ASTNode node) {
        if (node == null) {
            return -1;
        }
        return node.getNodeType();
    }

    /*
     * Unable to fully structure code
     */
    private boolean isLocallyParsable(String snapshot, DocChange lastChange) {
        rootNode = OperationGrouper.parseSnapshot(snapshot);
        if (!(rootNode instanceof CompilationUnit)) {
            return false;
        }
        insertionRange = lastChange.getInsertionRange();
        node = NodeFinder.perform((ASTNode)rootNode, (int)insertionRange.getEndOffset(), (int)0);
        visitor = new MalformedNodeFinder();
        node.accept((ASTVisitor)visitor);
        if (!visitor.isMalformed()) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.isNodeMalformed(node)) {
                return false;
            }
            node = node.getParent();
lbl13:
            // 2 sources

            ** while (node != null)
        }
lbl14:
        // 1 sources

        return true;
    }

    private static ASTNode parseSnapshot(String snapshot) {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(snapshot.toCharArray());
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.7", (Map)options);
        parser.setCompilerOptions((Map)options);
        ASTNode rootNode = parser.createAST(null);
        return rootNode;
    }

    private boolean isNodeMalformed(ASTNode node) {
        return (node.getFlags() & 1) == 1;
    }

    private void flushPendingChanges(int level) {
        List<RuntimeDC> dcs = this.pendingChangesList[level];
        if (dcs.isEmpty()) {
            return;
        }
        if (level + 1 < 3) {
            this.processRuntimeDCs(level + 1, dcs);
        }
        Document snapshot = this.getCurrentSnapshot(level);
        if (this.mergedPendingChanges[level] != null) {
            this.mergedPendingChanges[level].apply((IDocument)snapshot);
        }
        this.pendingChangesList[level].clear();
        this.mergedPendingChanges[level] = null;
        this.pendingChangeInformation[level] = null;
    }

    public void addOperationGrouperListener(OperationGrouperListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeOperationGrouperListener(OperationGrouperListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireCollapseIDsUpdatedEvent(List<RuntimeDC> dcs, int level, int collapseID, IChangeInformation changeInformation) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((OperationGrouperListener)listenerObj).collapseIDsUpdated(dcs, level, collapseID, changeInformation);
            ++n2;
        }
    }

    private class MalformedNodeFinder
    extends ASTVisitor {
        private boolean malformed = false;

        private MalformedNodeFinder() {
        }

        public void preVisit(ASTNode node) {
            if (this.isMalformed()) {
                return;
            }
            if (OperationGrouper.this.isNodeMalformed(node)) {
                this.malformed = true;
            }
        }

        public boolean isMalformed() {
            return this.malformed;
        }
    }
}

