/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.viewers;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.compare.AzuriteCompareInput;
import edu.cmu.scs.azurite.compare.SimpleCompareItem;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoEngine;
import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.util.Utilities;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReviewViewer
extends Composite {
    private CompareViewerSwitchingPane mCompareViewerSwitchingPane;
    private CompareConfiguration mConfiguration;
    private String mTitle;
    private IViewPart mParentViewPart;
    private int mVersionBegin;
    private int mVersionEnd;
    private ActionContributionItem mRevertAction;
    private ActionContributionItem mPrevAction;
    private ActionContributionItem mNextAction;

    public ReviewViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
    }

    public void setParameters(IViewPart parentViewPart, CompareConfiguration configuration) {
        this.mParentViewPart = parentViewPart;
        this.mConfiguration = configuration;
    }

    public void create() {
        this.createActions();
        this.mCompareViewerSwitchingPane = this.createCompareView(this);
    }

    private void createActions() {
        this.mRevertAction = new ActionContributionItem((IAction)new Action("Revert", Activator.getImageDescriptor("icons/old_edit_undo.png")){

            public void run() {
                RuntimeHistoryManager manager = RuntimeHistoryManager.getInstance();
                List<RuntimeDC> entireHistory = manager.getEntireHistory();
                List<RuntimeDC> involvedDCs = entireHistory.subList(ReviewViewer.this.mVersionBegin, ReviewViewer.this.mVersionEnd);
                List<OperationId> ids = OperationId.getOperationIdsFromRuntimeDCs(involvedDCs);
                Map<FileKey, List<RuntimeDC>> params = manager.extractFileDCMapFromOperationIds(ids);
                SelectiveUndoEngine.getInstance().doSelectiveUndoOnMultipleFiles(params);
            }
        });
        this.mRevertAction.setId("reviewRevert");
        this.mRevertAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.mPrevAction = new ActionContributionItem((IAction)new Action("Prev", Activator.getImageDescriptor("icons/old_go_previous.png")){

            public void run() {
                if (ReviewViewer.this.mVersionBegin > 0) {
                    ReviewViewer.this.selectVersion(ReviewViewer.this.mVersionBegin - 1, ReviewViewer.this.mVersionBegin);
                } else {
                    MessageDialog.openInformation((Shell)ReviewViewer.this.getShell(), (String)"Azurite - Review", (String)"No more changes to be reviewed");
                }
            }
        });
        this.mPrevAction.setId("reviewPrev");
        this.mPrevAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.mNextAction = new ActionContributionItem((IAction)new Action("Next", Activator.getImageDescriptor("icons/old_go_next.png")){

            public void run() {
                int historySize = RuntimeHistoryManager.getInstance().getEntireHistory().size();
                if (ReviewViewer.this.mVersionEnd < historySize) {
                    ReviewViewer.this.selectVersion(ReviewViewer.this.mVersionEnd, ReviewViewer.this.mVersionEnd + 1);
                } else {
                    MessageDialog.openInformation((Shell)ReviewViewer.this.getShell(), (String)"Azurite - Review", (String)"No more changes to be reviewed");
                }
            }
        });
        this.mNextAction.setId("reviewNext");
        this.mNextAction.setMode(ActionContributionItem.MODE_FORCE_TEXT);
    }

    private CompareViewerSwitchingPane createCompareView(Composite parent) {
        CompareViewerSwitchingPane compareView = new CompareViewerSwitchingPane(parent, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                IContributionItem[] items;
                Viewer v = CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, (CompareConfiguration)ReviewViewer.this.mConfiguration);
                v.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)ReviewViewer.this.mTitle);
                ToolBarManager tbm = CompareViewerSwitchingPane.getToolBarManager((Composite)this);
                String navGroupId = "reviewNav";
                boolean added = false;
                IContributionItem[] iContributionItemArray = items = tbm.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (navGroupId.equals(item.getId())) {
                        added = true;
                        break;
                    }
                    ++n2;
                }
                if (!added) {
                    tbm.removeAll();
                    tbm.add((IContributionItem)ReviewViewer.this.mRevertAction);
                    tbm.add((IContributionItem)new Separator(navGroupId));
                    tbm.appendToGroup(navGroupId, (IContributionItem)ReviewViewer.this.mPrevAction);
                    tbm.appendToGroup(navGroupId, (IContributionItem)ReviewViewer.this.mNextAction);
                    tbm.update(true);
                }
                return v;
            }
        };
        compareView.setLayoutData((Object)new GridData(4, 4, true, true));
        return compareView;
    }

    private int getVersionBegin() {
        return this.mVersionBegin;
    }

    private int getVersionEnd() {
        return this.mVersionEnd;
    }

    public void selectVersion(int versionBegin, int versionEnd) {
        if (this.mCompareViewerSwitchingPane == null) {
            throw new IllegalStateException();
        }
        RuntimeHistoryManager manager = RuntimeHistoryManager.getInstance();
        List<RuntimeDC> entireHistory = manager.getEntireHistory();
        if (versionBegin < 0 || versionEnd > entireHistory.size() || versionBegin >= versionEnd) {
            throw new IllegalArgumentException();
        }
        if (this.getVersionBegin() == versionBegin && this.getVersionEnd() == versionEnd) {
            return;
        }
        List<RuntimeDC> involvedDCs = entireHistory.subList(versionBegin, versionEnd);
        int size = versionEnd - versionBegin;
        FileKey key = involvedDCs.get(0).getBelongsTo();
        int i = 1;
        while (i < size) {
            if (!key.equals(involvedDCs.get(i).getBelongsTo())) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        List<RuntimeDC> historyForKey = manager.getRuntimeDocumentChanges(key);
        int versionEndForKey = historyForKey.indexOf(entireHistory.get(versionEnd - 1)) + 1;
        int versionBeginForKey = versionEndForKey - size;
        IEditorPart editor = Utilities.openEditorWithKey(key);
        Utilities.moveCursorToChangeLocation(editor, involvedDCs.get(0));
        List<OperationId> ids = OperationId.getOperationIdsFromRuntimeDCs(involvedDCs);
        TimelineViewPart timelineViewPart = TimelineViewPart.getInstance();
        if (timelineViewPart != null) {
            timelineViewPart.addSelection(ids, true);
        }
        IDocument doc = Utilities.findDocumentForKey(key);
        StringBuilder fileContent = new StringBuilder(doc.get());
        int i2 = historyForKey.size() - 1;
        while (i2 >= versionEndForKey) {
            DocChange originalDC = historyForKey.get(i2).getOriginal();
            originalDC.applyInverse(fileContent);
            --i2;
        }
        String after = fileContent.toString();
        int i3 = versionEndForKey - 1;
        while (i3 >= versionBeginForKey) {
            DocChange originalDC = historyForKey.get(i3).getOriginal();
            originalDC.applyInverse(fileContent);
            --i3;
        }
        String before = fileContent.toString();
        SimpleCompareItem left = new SimpleCompareItem("Before", before, false);
        SimpleCompareItem right = new SimpleCompareItem("After", after, false);
        AzuriteCompareInput input = new AzuriteCompareInput(left, right);
        this.mCompareViewerSwitchingPane.setInput((Object)input);
        this.mCompareViewerSwitchingPane.redraw();
        this.mVersionBegin = versionBegin;
        this.mVersionEnd = versionEnd;
    }

    public void closeParentView() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            page.hideView(this.mParentViewPart);
        }
    }
}

