/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.dialogs;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.jface.widgets.AlternativeButton;
import edu.cmu.scs.azurite.model.undo.Chunk;
import edu.cmu.scs.azurite.model.undo.UndoAlternative;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConflictResolutionDialog
extends TitleAreaDialog {
    private static final int MINIMUM_OPERATIONS_HEIGHT = 70;
    private static final int SASH_WIDTH = 10;
    private static final int MINIMUM_SASHFORM_WIDTH = 700;
    private static final int MINIMUM_SASHFORM_HEIGHT = 400;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int SPACING = 10;
    private static final String TEXT = "Azurite - Selective Undo";
    private static final String TITLE = "Conflict Detected";
    private static final String DEFAULT_MESSAGE = "One or more conflicts were detected while performing selective undo.";
    private IDocument mOriginalDoc;
    private IDocument mCopyDoc;
    private int mOffset;
    private int mLength;
    private int mOriginalLength;
    private List<UndoAlternative> mAlternatives;
    private Chunk mChunk;
    private ISourceViewer mCodePreview;
    private Color mBackground;

    public ConflictResolutionDialog(Shell parent, IDocument originalDoc, int offset, int length, List<UndoAlternative> alternatives, Chunk chunk) {
        super(parent);
        this.mOriginalDoc = originalDoc;
        this.mCopyDoc = new Document(originalDoc.get());
        this.mOffset = offset;
        this.mLength = length;
        this.mOriginalLength = length;
        this.mAlternatives = alternatives;
        this.mChunk = chunk;
        this.mBackground = new Color((Device)parent.getDisplay(), 186, 205, 224);
        this.setHelpAvailable(false);
    }

    public void create() {
        super.create();
        this.getShell().setText(TEXT);
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createMainArea(parent);
        this.createInvolvedOperationsGroup(composite);
        SashForm sashForm = this.createSashForm(composite);
        this.createAlternativesGroup((Composite)sashForm);
        this.createCodePreviewGroup((Composite)sashForm);
        sashForm.setSashWidth(10);
        sashForm.setWeights(new int[]{1, 2});
        this.selectAlternative(0);
        return composite;
    }

    private Composite createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private void createInvolvedOperationsGroup(Composite parent) {
        Composite groupOperations = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        groupOperations.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.minimumHeight = 70;
        groupOperations.setLayoutData((Object)gridData);
        Label label = new Label(groupOperations, 0);
        label.setText("The following operations were selected but had some conflicts outside of the selection.");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(groupOperations, 512);
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        for (RuntimeDC dc : this.mChunk.getInvolvedChanges()) {
            list.add(dc.toString());
        }
    }

    private SashForm createSashForm(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        gridData.minimumWidth = 700;
        gridData.minimumHeight = 400;
        sashForm.setLayoutData((Object)gridData);
        return sashForm;
    }

    private void createAlternativesGroup(Composite parent) {
        Group groupAlternatives = new Group(parent, 0);
        groupAlternatives.setText("Alternatives");
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 10;
        groupAlternatives.setLayout((Layout)gridLayout);
        int i = 0;
        while (i < this.mAlternatives.size()) {
            UndoAlternative alternative = this.mAlternatives.get(i);
            AlternativeButton buttonAlternative = new AlternativeButton((Composite)groupAlternatives, 16);
            buttonAlternative.setAlternativeCode(alternative.getResultingCode());
            buttonAlternative.setToolTipText(alternative.getDescription());
            buttonAlternative.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            if (i == 0) {
                buttonAlternative.setSelected(true);
            }
            final int currentIndex = i++;
            buttonAlternative.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConflictResolutionDialog.this.selectAlternative(currentIndex);
                }
            });
        }
    }

    private void createCodePreviewGroup(Composite parent) {
        Group groupPreview = new Group(parent, 0);
        groupPreview.setText("Code Preview");
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 10;
        fillLayout.marginHeight = 10;
        groupPreview.setLayout((Layout)fillLayout);
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn lnrc = new LineNumberRulerColumn();
        lnrc.setFont(Utilities.getFont());
        ruler.addDecorator(0, (IVerticalRulerColumn)lnrc);
        this.mCodePreview = new SourceViewer((Composite)groupPreview, (IVerticalRuler)ruler, 768);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner(this.mCopyDoc);
        JavaSourceViewerConfiguration config = new JavaSourceViewerConfiguration(tools.getColorManager(), JavaPlugin.getDefault().getCombinedPreferenceStore(), null, null);
        this.mCodePreview.configure((SourceViewerConfiguration)config);
        this.mCodePreview.setDocument(this.mCopyDoc);
        this.mCodePreview.setEditable(false);
        this.mCodePreview.getTextWidget().setFont(Utilities.getFont());
    }

    private void selectAlternative(int index) {
        if (index < 0 || index >= this.mAlternatives.size()) {
            throw new IllegalArgumentException();
        }
        UndoAlternative alternative = this.mAlternatives.get(index);
        try {
            this.mCopyDoc.replace(this.mOffset, this.mLength, alternative.getResultingCode());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
        this.mLength = alternative.getResultingCode().length();
        StyleRange range = new StyleRange(this.mOffset, this.mLength, null, this.mBackground);
        this.mCodePreview.getTextWidget().setStyleRange(range);
    }

    protected void okPressed() {
        try {
            this.mOriginalDoc.replace(this.mOffset, this.mOriginalLength, this.mCopyDoc.get(this.mOffset, this.mLength));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

