/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.widgets;

import edu.cmu.scs.fluorite.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class AlternativeButton
extends Composite {
    private static final int THICK_BORDER_WIDTH = 5;
    private static final int THIN_BORDER_WIDTH = 1;
    private static final int MARGIN_WIDTH = 3;
    private boolean mSelected = false;
    private Composite mThickBorderComposite;
    private Composite mThinBorderComposite;
    private StyledText mStyledText;
    private List<SelectionListener> mSelectionListeners = new ArrayList<SelectionListener>();

    public AlternativeButton(Composite parent, int style) {
        super(parent, style);
        this.createComponents(this);
        this.addMouseDownListener(this);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.mSelectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.mSelectionListeners.remove(listener);
    }

    private void fireWidgetSelected() {
        Event event = new Event();
        event.widget = this;
        for (SelectionListener listener : this.mSelectionListeners) {
            listener.widgetSelected(new SelectionEvent(event));
        }
    }

    private void addMouseDownListener(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    AlternativeButton.this.handleMouseDown();
                }
            });
            if (child instanceof Composite) {
                this.addMouseDownListener((Composite)child);
            }
            ++n2;
        }
    }

    private void handleMouseDown() {
        this.getSelected();
        Control[] controlArray = this.getParent().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof AlternativeButton) {
                ((AlternativeButton)child).setSelected(false);
            }
            ++n2;
        }
        this.setSelected(true);
        this.fireWidgetSelected();
    }

    private void createComponents(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        this.mThickBorderComposite = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 4;
        fillLayout.marginWidth = 4;
        this.mThickBorderComposite.setLayout((Layout)fillLayout);
        this.mThinBorderComposite = new Composite(this.mThickBorderComposite, 0);
        fillLayout = new FillLayout();
        fillLayout.marginHeight = 1;
        fillLayout.marginWidth = 1;
        this.mThinBorderComposite.setLayout((Layout)fillLayout);
        Composite mid = new Composite(this.mThinBorderComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 3;
        gridLayout.marginWidth = 3;
        mid.setLayout((Layout)gridLayout);
        this.mStyledText = new StyledText(mid, 524544);
        this.mStyledText.setAlwaysShowScrollBars(false);
        this.mStyledText.setEditable(false);
        this.mStyledText.setFont(Utilities.getFont());
        this.mStyledText.setCursor(this.getDisplay().getSystemCursor(0));
        this.mStyledText.setCaret(null);
        this.mStyledText.setSelectionBackground(this.mStyledText.getBackground());
        this.mStyledText.setSelectionForeground(this.mStyledText.getForeground());
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        this.mStyledText.setLayoutData((Object)gridData);
        mid.setBackground(this.mStyledText.getBackground());
        this.updateBorder();
    }

    private void updateBorder() {
        int thickColorID = this.getSelected() ? 26 : 22;
        Color thickBorderColor = this.getDisplay().getSystemColor(thickColorID);
        int thinColorID = this.getSelected() ? 26 : 2;
        Color thinBorderColor = this.getDisplay().getSystemColor(thinColorID);
        this.mThickBorderComposite.setBackground(thickBorderColor);
        this.mThinBorderComposite.setBackground(thinBorderColor);
        this.redraw();
    }

    public void setSelected(boolean selected) {
        this.mSelected = selected;
        this.updateBorder();
    }

    public boolean getSelected() {
        return this.mSelected;
    }

    public void setAlternativeCode(String code) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        this.mStyledText.setText(code);
    }
}

