/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.commands.runtime;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDelete;
import edu.cmu.scs.azurite.commands.runtime.RuntimeInsert;
import edu.cmu.scs.azurite.commands.runtime.RuntimeReplace;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.grouper.IChangeInformation;
import edu.cmu.scs.fluorite.commands.document.Delete;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Insert;
import edu.cmu.scs.fluorite.commands.document.Replace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.IDocument;

public abstract class RuntimeDC {
    private DocChange mOriginal;
    private List<RuntimeDC> mConflicts;
    private FileKey mBelongsTo;
    private int[] mCollapseTo;
    private IChangeInformation[] mChangeInformation;
    private static Comparator<RuntimeDC> commandIDComparator;
    private OperationId mOperationId;

    public static RuntimeDC createRuntimeDocumentChange(DocChange original) {
        if (original instanceof Insert) {
            return new RuntimeInsert((Insert)original);
        }
        if (original instanceof Delete) {
            return new RuntimeDelete((Delete)original);
        }
        if (original instanceof Replace) {
            return new RuntimeReplace((Replace)original);
        }
        throw new IllegalArgumentException("argument should be one of Insert / Delete / Replace");
    }

    protected RuntimeDC(DocChange original) {
        this.mOriginal = original;
        this.mConflicts = new ArrayList<RuntimeDC>();
        this.mCollapseTo = new int[3];
        Arrays.fill(this.mCollapseTo, original != null ? original.getCommandIndex() : -1);
        this.mChangeInformation = new IChangeInformation[3];
        Arrays.fill(this.mChangeInformation, null);
    }

    public DocChange getOriginal() {
        return this.mOriginal;
    }

    public abstract void applyInsert(RuntimeInsert var1);

    public abstract void applyDelete(RuntimeDelete var1);

    public abstract void applyReplace(RuntimeReplace var1);

    public abstract void applyTo(RuntimeDC var1);

    public List<RuntimeDC> getConflicts() {
        return this.mConflicts;
    }

    protected void addConflict(RuntimeDC docChange) {
        this.mConflicts.add(docChange);
    }

    public void setBelongsTo(FileKey belongsTo) {
        this.mBelongsTo = belongsTo;
    }

    public FileKey getBelongsTo() {
        return this.mBelongsTo;
    }

    public abstract List<Segment> getAllSegments();

    public abstract int getTypeIndex();

    public static Comparator<RuntimeDC> getCommandIDComparator() {
        if (commandIDComparator == null) {
            commandIDComparator = new Comparator<RuntimeDC>(){

                @Override
                public int compare(RuntimeDC lhs, RuntimeDC rhs) {
                    if (lhs.getOriginal().getSessionId() < rhs.getOriginal().getSessionId()) {
                        return -1;
                    }
                    if (lhs.getOriginal().getSessionId() > rhs.getOriginal().getSessionId()) {
                        return 1;
                    }
                    int lindex = lhs.getOriginal().getCommandIndex();
                    int rindex = rhs.getOriginal().getCommandIndex();
                    return new Integer(lindex).compareTo(rindex);
                }
            };
        }
        return commandIDComparator;
    }

    public String getHtmlInfo(int level) {
        StringBuilder builder = new StringBuilder();
        if ("true".equals(System.getProperty("azuriteDebug"))) {
            builder.append("ID: " + this.getOriginal().getCommandIndex() + ", [" + this.getCollapseID(0) + ", " + this.getCollapseID(1) + ", " + this.getCollapseID(2) + "]<br>");
        }
        DocChange docChange = null;
        String changeSummary = null;
        if (level == -1) {
            docChange = this.getOriginal();
        } else if (this.mChangeInformation[level] != null) {
            docChange = this.mChangeInformation[level].getMergedChange();
            changeSummary = this.mChangeInformation[level].getChangeSummary();
        }
        boolean empty = true;
        if (docChange != null) {
            if (changeSummary != null) {
                builder.append("<div class='change_summary'>");
                builder.append(changeSummary);
                builder.append("</div>");
            }
            String deletedText = docChange.getDeletedText();
            String insertedText = docChange.getInsertedText();
            if (deletedText != null && !deletedText.isEmpty()) {
                builder.append("<div class='code code_deletion'>");
                builder.append(this.transformToHtmlString(deletedText));
                builder.append("</div>");
                empty = false;
            }
            if (insertedText != null && !insertedText.isEmpty()) {
                builder.append("<div class='code code_insertion'>");
                builder.append(this.transformToHtmlString(insertedText));
                builder.append("</div>");
                empty = false;
            }
        }
        if (empty) {
            builder.append("No Changes");
        }
        return builder.toString().replace("\n", "<br>");
    }

    protected String transformToHtmlString(String originalCode) {
        return originalCode.replace("\r\n", "\n").replace("\r", "\n").replace("\n", "<br>");
    }

    public abstract String getTypeString();

    public abstract String getMarkerMessage();

    public OperationId getOperationId() {
        if (this.mOperationId == null) {
            this.mOperationId = new OperationId(this.getOriginal().getSessionId(), this.getOriginal().getCommandIndex());
        }
        return this.mOperationId;
    }

    public int getCollapseID(int level) {
        return this.mCollapseTo[level];
    }

    public void setCollapseID(int level, int id) {
        this.mCollapseTo[level] = id;
    }

    public IChangeInformation getChangeInformation(int level) {
        return this.mChangeInformation[level];
    }

    public void setChangeInformation(int level, IChangeInformation changeInformation) {
        this.mChangeInformation[level] = changeInformation;
    }

    public static DocChange mergeChanges(RuntimeDC oldDC, RuntimeDC newDC) {
        return RuntimeDC.mergeChanges(oldDC, newDC, null);
    }

    public static DocChange mergeChanges(RuntimeDC oldDC, RuntimeDC newDC, IDocument docBefore) {
        return DocChange.mergeChanges((DocChange)oldDC.getOriginal(), (DocChange)newDC.getOriginal(), (IDocument)docBefore);
    }

    public static DocChange mergeChanges(RuntimeDC oldDC, List<RuntimeDC> newDCs) {
        return RuntimeDC.mergeChanges(oldDC, newDCs, null);
    }

    public static DocChange mergeChanges(RuntimeDC oldDC, List<RuntimeDC> newDCs, IDocument docBefore) {
        return RuntimeDC.mergeChanges(oldDC.getOriginal(), newDCs, docBefore);
    }

    public static DocChange mergeChanges(DocChange oldChange, List<RuntimeDC> newDCs) {
        return RuntimeDC.mergeChanges(oldChange, newDCs, null);
    }

    public static DocChange mergeChanges(DocChange oldChange, List<RuntimeDC> newDCs, IDocument docBefore) {
        DocChange result = oldChange;
        for (RuntimeDC newDC : newDCs) {
            result = DocChange.mergeChanges((DocChange)result, (DocChange)newDC.getOriginal(), (IDocument)docBefore);
        }
        return result;
    }

    public static DocChange mergeChanges(List<RuntimeDC> dcs) {
        return RuntimeDC.mergeChanges(dcs, null);
    }

    public static DocChange mergeChanges(List<RuntimeDC> dcs, IDocument docBefore) {
        return RuntimeDC.mergeChanges(dcs.get(0), dcs.subList(1, dcs.size()), docBefore);
    }
}

