/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.util;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.model.FileKey;
import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class Utilities {
    public static IDocument findDocumentFromOpenEditors(FileKey fileKey) {
        try {
            IEditorReference[] editorRefs;
            IEditorReference[] iEditorReferenceArray = editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IFileEditorInput fileInput;
                IFile file;
                FileKey key;
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorInput input = editorRef.getEditorInput();
                if (input instanceof IFileEditorInput && fileKey.equals(key = new FileKey((file = (fileInput = (IFileEditorInput)input).getFile()).getProject().getName(), file.getLocation().toOSString()))) {
                    return edu.cmu.scs.fluorite.util.Utilities.getDocument((IEditorPart)editorRef.getEditor(false));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDocument findDocumentForKey(FileKey fileKey) {
        IFile file;
        block3: {
            try {
                Path absPath;
                IDocument doc = Utilities.findDocumentFromOpenEditors(fileKey);
                if (doc != null) return doc;
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                file = root.getFileForLocation((IPath)(absPath = new Path(fileKey.getFilePath())));
                if (file != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        IPath relPath = file.getFullPath();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(relPath, LocationKind.IFILE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(relPath, LocationKind.IFILE);
        return buffer.getDocument();
    }

    public static IEditorPart openEditorWithKey(FileKey key) {
        File fileToOpen = new File(key.getFilePath());
        IEditorPart editor = null;
        if (fileToOpen.exists() && fileToOpen.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {}
        }
        return editor;
    }

    public static void moveCursorToChangeLocation(IEditorPart editor, RuntimeDC runtimeDC) {
        if (editor != null) {
            final ITextViewerExtension5 textViewerExt5 = edu.cmu.scs.fluorite.util.Utilities.getTextViewerExtension5((IEditorPart)editor);
            final int offset = runtimeDC.getAllSegments().get(0).getOffset();
            final StyledText styledText = edu.cmu.scs.fluorite.util.Utilities.getStyledText((IEditorPart)editor);
            UIJob job = new UIJob("Jump to the Code"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    styledText.setSelection(textViewerExt5.modelOffset2WidgetOffset(offset));
                    styledText.setFocus();
                    styledText.showSelection();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

