/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model.undo;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import edu.cmu.scs.azurite.jface.dialogs.ConflictResolutionDialog;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.undo.Chunk;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoParams;
import edu.cmu.scs.azurite.model.undo.UndoAlternative;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.util.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SelectiveUndoEngine {
    public static final int MAX_EXPANSION_DEPTH = 2;
    private static SelectiveUndoEngine instance = null;

    public static SelectiveUndoEngine getInstance() {
        if (instance == null) {
            instance = new SelectiveUndoEngine();
        }
        return instance;
    }

    public void doSelectiveUndo(List<RuntimeDC> runtimeDocChanges) {
        if (runtimeDocChanges == null) {
            throw new IllegalArgumentException();
        }
        this.doSelectiveUndo(runtimeDocChanges.toArray(new RuntimeDC[runtimeDocChanges.size()]));
    }

    public void doSelectiveUndo(List<RuntimeDC> runtimeDocChanges, IDocument document) {
        if (runtimeDocChanges == null || document == null) {
            throw new IllegalArgumentException();
        }
        this.doSelectiveUndo(runtimeDocChanges.toArray(new RuntimeDC[runtimeDocChanges.size()]), document);
    }

    public void doSelectiveUndo(RuntimeDC[] runtimeDocChanges) {
        if (runtimeDocChanges == null) {
            throw new IllegalArgumentException();
        }
        IDocument document = null;
        try {
            document = Utilities.getIDocumentForEditor((IEditorPart)EventRecorder.getInstance().getEditor());
        }
        catch (Exception exception) {}
        if (document == null) {
            throw new IllegalStateException("Failed to get the active document");
        }
        this.doSelectiveUndo(runtimeDocChanges, document);
    }

    public void doSelectiveUndo(RuntimeDC[] runtimeDocChanges, IDocument document) {
        if (runtimeDocChanges == null || document == null) {
            throw new IllegalArgumentException();
        }
        List<Chunk> chunks = this.determineChunksWithRuntimeDCs(runtimeDocChanges);
        this.doSelectiveUndoWithChunks(chunks, document);
    }

    public void doSelectiveUndoWithChunks(List<Chunk> chunks, IDocument document) {
        this.doSelectiveUndoWithChunks(chunks, document, null);
    }

    public void doSelectiveUndoWithChunks(List<Chunk> chunks, IDocument document, Map<Chunk, UndoAlternative> alternativeChoices) {
        Collections.reverse(chunks);
        for (Chunk chunk : chunks) {
            try {
                Chunk expandedChunk = chunk.getExpandedChunkWithDepth(2);
                int initialOffset = expandedChunk.getStartOffset();
                String initialContent = document.get(initialOffset, expandedChunk.getChunkLength());
                if (chunk.hasConflictOutsideThisChunk()) {
                    List<UndoAlternative> alternatives = this.doSelectiveUndoChunkWithConflicts(chunk, initialContent);
                    if (alternatives.size() <= 2) {
                        document.replace(initialOffset, initialContent.length(), alternatives.get(0).getResultingCode());
                        continue;
                    }
                    if (alternativeChoices != null && alternativeChoices.get(chunk) != null) {
                        UndoAlternative chosenAlternative = alternativeChoices.get(chunk);
                        document.replace(initialOffset, initialContent.length(), chosenAlternative.getResultingCode());
                        continue;
                    }
                    Shell parentShell = Display.getDefault().getActiveShell();
                    ConflictResolutionDialog conflictDialog = new ConflictResolutionDialog(parentShell, document, initialOffset, initialContent.length(), alternatives, chunk);
                    conflictDialog.create();
                    conflictDialog.open();
                    continue;
                }
                String resultingContent = this.doSelectiveUndoChunkWithoutConflicts(chunk, initialContent);
                document.replace(initialOffset, initialContent.length(), resultingContent);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void sortRuntimeDocumentChanges(RuntimeDC[] runtimeDocChanges) {
        Arrays.sort(runtimeDocChanges, RuntimeDC.getCommandIDComparator());
    }

    public List<UndoAlternative> doSelectiveUndoChunkWithConflicts(Chunk chunk, String initialContent) {
        ArrayList<UndoAlternative> result = new ArrayList<UndoAlternative>();
        result.add(new UndoAlternative("Revert this code to the way it was right before all the selected operations were performed.", this.doSelectiveUndoChunkWithoutConflicts(chunk.getExpandedChunkInRange(), initialContent)));
        int i = 1;
        while (i <= 2) {
            if (i != 0) {
                result.add(new UndoAlternative("Revert this code including the non-selected conflicting operations with depth " + i + ".", this.doSelectiveUndoChunkWithoutConflicts(chunk.getExpandedChunkWithDepth(2), initialContent)));
            }
            ++i;
        }
        result.add(new UndoAlternative("Strictly selectively undo only the selected operations.", this.doSelectiveUndoChunkWithoutConflicts(chunk, initialContent)));
        result.add(new UndoAlternative("Keep the code as it is. Do not perform selective undo for this chunk.", initialContent));
        i = 1;
        while (i < result.size()) {
            UndoAlternative cur = (UndoAlternative)result.get(i);
            int j = 0;
            while (j < i) {
                UndoAlternative prev = (UndoAlternative)result.get(j);
                if (prev.getResultingCode().equals(cur.getResultingCode())) {
                    result.remove(i);
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return Collections.unmodifiableList(result);
    }

    public String doSelectiveUndoChunkWithoutConflicts(Chunk chunk, String initialContent) {
        int initialOffset = chunk.getStartOffset();
        StringBuffer buffer = new StringBuffer(initialContent);
        Chunk copyChunk = chunk.copyChunk();
        ArrayList<RuntimeDC> involvedDCs = new ArrayList<RuntimeDC>(chunk.getInvolvedChanges());
        Collections.reverse(involvedDCs);
        for (RuntimeDC change : involvedDCs) {
            ArrayList<Segment> segments = new ArrayList<Segment>();
            for (Segment copySegment : copyChunk) {
                if (!copySegment.getOwner().equals(change)) continue;
                segments.add(copySegment);
            }
            Collections.sort(segments, Segment.getLocationComparator());
            Collections.reverse(segments);
            ListIterator it = segments.listIterator();
            while (it.hasNext()) {
                Segment segmentUnderUndo = (Segment)it.next();
                this.undoSegment(segmentUnderUndo, copyChunk, initialOffset, buffer);
                it.remove();
                copyChunk.remove(segmentUnderUndo);
            }
        }
        return buffer.toString();
    }

    private void undoSegment(Segment segmentUnderUndo, Chunk copyChunk, int initialOffset, StringBuffer buffer) {
        if (segmentUnderUndo.isDeletion()) {
            this.undoDeleteSegment(segmentUnderUndo, copyChunk, initialOffset, buffer);
        } else {
            this.undoInsertSegment(segmentUnderUndo, copyChunk, initialOffset, buffer);
        }
    }

    private void undoInsertSegment(Segment segmentUnderUndo, Chunk copyChunk, int initialOffset, StringBuffer buffer) {
        buffer.replace(segmentUnderUndo.getOffset() - initialOffset, segmentUnderUndo.getEndOffset() - initialOffset, "");
        for (Segment chunkSegment : copyChunk) {
            if (chunkSegment.equals(segmentUnderUndo) || Segment.getLocationComparator().compare(chunkSegment, segmentUnderUndo) < 0) continue;
            chunkSegment.decrementOffset(segmentUnderUndo.getLength());
        }
    }

    private void undoDeleteSegment(Segment segmentUnderUndo, Chunk copyChunk, int initialOffset, StringBuffer buffer) {
        buffer.replace(segmentUnderUndo.getOffset() - initialOffset, segmentUnderUndo.getOffset() - initialOffset, segmentUnderUndo.getText());
        for (Segment chunkSegment : copyChunk) {
            if (chunkSegment.equals(segmentUnderUndo) || Segment.getLocationComparator().compare(chunkSegment, segmentUnderUndo) < 0) continue;
            chunkSegment.incrementOffset(segmentUnderUndo.getLength());
        }
        for (Segment closedSegment : segmentUnderUndo.getSegmentsClosedByMe()) {
            if (!copyChunk.contains(closedSegment)) continue;
            closedSegment.reopen(segmentUnderUndo.getOffset());
        }
        for (Segment right : segmentUnderUndo.getRight()) {
            if (!copyChunk.contains(right)) continue;
            right.setOffset(segmentUnderUndo.getOffset() + segmentUnderUndo.getLength());
        }
    }

    public void doSelectiveUndoWithParams(SelectiveUndoParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.doSelectiveUndoWithChunks(params.getChunks(), params.getDocument(), params.getAlternativeChoices());
    }

    List<Segment> getAllSegments(RuntimeDC[] runtimeDocChanges) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        RuntimeDC[] runtimeDCArray = runtimeDocChanges;
        int n = runtimeDocChanges.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimeDC runtimeDocChange = runtimeDCArray[n2];
            segments.addAll(runtimeDocChange.getAllSegments());
            ++n2;
        }
        return segments;
    }

    public List<Chunk> determineChunksWithRuntimeDCs(List<RuntimeDC> runtimeDCs) {
        return this.determineChunksWithRuntimeDCs(runtimeDCs.toArray(new RuntimeDC[runtimeDCs.size()]));
    }

    public List<Chunk> determineChunksWithRuntimeDCs(RuntimeDC[] runtimeDCs) {
        if (runtimeDCs == null) {
            throw new IllegalArgumentException();
        }
        this.sortRuntimeDocumentChanges(runtimeDCs);
        List<Segment> segments = this.getAllSegments(runtimeDCs);
        return this.determineChunks(segments);
    }

    public List<Chunk> determineChunks(List<Segment> segments) {
        Collections.sort(segments, Segment.getLocationComparator());
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        Chunk prevChunk = null;
        int i = 0;
        while (i < segments.size()) {
            Chunk chunk = null;
            chunk = prevChunk == null || segments.get(i).getEffectiveEndOffset() < prevChunk.getStartOffset() || segments.get(i).getOffset() > prevChunk.getEndOffset() ? new Chunk() : prevChunk;
            int j = segments.size() - 1;
            while (j > i) {
                if (segments.get(i).getOwner() == segments.get(j).getOwner()) break;
                --j;
            }
            int k = i;
            while (k <= j) {
                chunk.add(segments.get(k));
                ++k;
            }
            if (chunk != prevChunk) {
                chunks.add(chunk);
            }
            i = j;
            prevChunk = chunk;
            ++i;
        }
        return chunks;
    }

    public void doSelectiveUndoOnMultipleFiles(Map<FileKey, List<RuntimeDC>> params) {
        for (FileKey key : params.keySet()) {
            List<RuntimeDC> runtimeDCs = params.get(key);
            File fileToOpen = new File(key.getFilePath());
            if (!fileToOpen.exists() || !fileToOpen.isFile()) continue;
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                this.doSelectiveUndo(runtimeDCs);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void doSelectiveUndoOnMultipleFilesWithChoices(Map<FileKey, SelectiveUndoParams> params) {
        for (FileKey key : params.keySet()) {
            File fileToOpen = new File(key.getFilePath());
            if (!fileToOpen.exists() || !fileToOpen.isFile()) continue;
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                this.doSelectiveUndoWithParams(params.get(key));
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }
}

