/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.ui.handlers;

import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectedRectsHandler
extends AbstractHandler {
    private static final String DIALOG_TITLE = "Azurite - Commands for Selected Rectangles in Timeline";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TimelineViewPart timeline = TimelineViewPart.getInstance();
        if (timeline == null) {
            MessageDialog.openInformation((Shell)shell, (String)DIALOG_TITLE, (String)"You must open the timeline first.");
            return null;
        }
        int numSelected = timeline.getSelectedRectsCount();
        if (numSelected == 0) {
            MessageDialog.openInformation((Shell)shell, (String)DIALOG_TITLE, (String)"You must select some rectangles first.");
            return null;
        }
        ListDialog dialog = new ListDialog(shell);
        dialog.setTitle(DIALOG_TITLE);
        dialog.setMessage("Which of the following commands do you want to execute on the selected rectangles?");
        dialog.setHelpAvailable(false);
        dialog.setContentProvider((IStructuredContentProvider)new SelectedRectsOperationContentProvider());
        dialog.setLabelProvider((ILabelProvider)new SelectedRectsOperationLabelProvider());
        Object[][] objectArrayArray = new Object[2][];
        Object[] objectArray = new Object[3];
        objectArray[1] = "Selective Undo";
        objectArray[2] = "edu.cmu.scs.azurite.ui.commands.selectiveUndoCommand";
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[1] = "Jump to the Code";
        objectArray2[2] = "edu.cmu.scs.azurite.ui.commands.jumpToTheAffectedCodeCommand";
        objectArrayArray[1] = objectArray2;
        Object[][] input = objectArrayArray;
        if (numSelected > 1) {
            input = (Object[][])Arrays.copyOfRange(input, 0, 1);
        }
        dialog.setInput((Object)input);
        dialog.setInitialSelections(new Object[]{input[0]});
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            Object[] resultItem = (Object[])result[0];
            String commandId = resultItem[2].toString();
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(commandId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class SelectedRectsOperationContentProvider
    implements IStructuredContentProvider {
        private SelectedRectsOperationContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private static class SelectedRectsOperationLabelProvider
    extends LabelProvider {
        private List<Image> imagesToDispose = new ArrayList<Image>();

        private SelectedRectsOperationLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            for (Image image : this.imagesToDispose) {
                image.dispose();
            }
        }

        public Image getImage(Object element) {
            if (element == null || ((Object[])element)[0] == null) {
                return null;
            }
            Image image = Activator.getImageDescriptor(((Object[])element)[0].toString()).createImage();
            this.imagesToDispose.add(image);
            return image;
        }

        public String getText(Object element) {
            return ((Object[])element)[1].toString();
        }
    }
}

