/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model;

import edu.cmu.scs.azurite.commands.diff.IDiffDC;
import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.IAddCommand;
import edu.cmu.scs.azurite.model.IRuntimeDCFilter;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.PastHistoryManager;
import edu.cmu.scs.azurite.model.RuntimeDCListener;
import edu.cmu.scs.azurite.model.grouper.OperationGrouper;
import edu.cmu.scs.azurite.plugin.Activator;
import edu.cmu.scs.fluorite.commands.FileOpenCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.ITypeOverridable;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Replace;
import edu.cmu.scs.fluorite.model.CommandExecutionListener;
import edu.cmu.scs.fluorite.model.DocumentChangeListener;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.model.Events;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class RuntimeHistoryManager
implements DocumentChangeListener,
CommandExecutionListener {
    private Map<FileKey, Integer> mNextIndexToApply;
    private Map<FileKey, List<RuntimeDC>> mDocumentChanges;
    private FileKey mCurrentFileKey;
    private List<ICommand> mEventsToBeDisplayed;
    private ListenerList mRuntimeDocumentChangeListeners;
    private List<Runnable> mScheduledTasks;
    private boolean mStarted;
    private Events mCurrentSessionEvents;
    private List<RuntimeDC> mEntireHistory;
    private static List<String> sTimelineEvents;
    private OperationGrouper mOperationGrouper;
    private static RuntimeHistoryManager _instance;

    public RuntimeHistoryManager() {
        this.clearData();
        this.mRuntimeDocumentChangeListeners = new ListenerList();
        this.mScheduledTasks = new ArrayList<Runnable>();
        this.mStarted = false;
        long startTimestamp = EventRecorder.getInstance().getStartTimestamp();
        this.mCurrentSessionEvents = new Events(Collections.emptyList(), "Current Session", Long.toString(startTimestamp), "", startTimestamp);
        this.mOperationGrouper = new OperationGrouper();
        this.addRuntimeDocumentChangeListener(this.mOperationGrouper);
    }

    public static void updateTimelineEventsList() {
        sTimelineEvents = new ArrayList<String>();
        if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore() != null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String str = store.getString("Azurite_EventDisplaySettings");
            if (str == null) {
                str = store.getDefaultString("Azurite_EventDisplaySettings");
            }
            if (str != null) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (StringReader reader = new StringReader(str);){
                        XMLMemento root = XMLMemento.createReadRoot((Reader)reader);
                        IMemento[] iMementoArray = root.getChildren();
                        int n = iMementoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemento child = iMementoArray[n2];
                            sTimelineEvents.add(child.getString("type"));
                            ++n2;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static List<String> getTimelineEvents() {
        if (sTimelineEvents == null) {
            RuntimeHistoryManager.updateTimelineEventsList();
        }
        return Collections.unmodifiableList(sTimelineEvents);
    }

    private void clearData() {
        this.mDocumentChanges = new HashMap<FileKey, List<RuntimeDC>>();
        this.mNextIndexToApply = new HashMap<FileKey, Integer>();
        this.mCurrentFileKey = null;
        this.mEventsToBeDisplayed = new ArrayList<ICommand>();
        this.mEntireHistory = new ArrayList<RuntimeDC>();
        if (this.getOperationGrouper() != null) {
            this.getOperationGrouper().clearData();
        }
    }

    public void scheduleTask(Runnable runnable) {
        if (this.mStarted) {
            runnable.run();
        } else {
            this.mScheduledTasks.add(runnable);
        }
    }

    public static RuntimeHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new RuntimeHistoryManager();
        }
        return _instance;
    }

    public void start() {
        EventRecorder.getInstance().addDocumentChangeListener((DocumentChangeListener)this);
        EventRecorder.getInstance().addDocumentChangeListener((DocumentChangeListener)PastHistoryManager.getInstance());
        EventRecorder.getInstance().addCommandExecutionListener((CommandExecutionListener)this);
        this.mStarted = true;
        for (Runnable runnable : this.mScheduledTasks) {
            runnable.run();
        }
    }

    public void stop() {
        EventRecorder.getInstance().removeDocumentChangeListener((DocumentChangeListener)this);
    }

    public void addRuntimeDocumentChangeListener(RuntimeDCListener listener) {
        this.mRuntimeDocumentChangeListeners.add((Object)listener);
    }

    public void removeRuntimeDocumentChangeListener(RuntimeDCListener listener) {
        this.mRuntimeDocumentChangeListeners.remove((Object)listener);
    }

    private void fireActiveFileChangedEvent(FileKey fileKey, String snapshot) {
        Object[] objectArray = this.mRuntimeDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RuntimeDCListener)listenerObj).activeFileChanged(fileKey, snapshot);
            ++n2;
        }
    }

    private void fireRuntimeDCAddedEvent(RuntimeDC docChange) {
        Object[] objectArray = this.mRuntimeDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RuntimeDCListener)listenerObj).runtimeDCAdded(docChange);
            ++n2;
        }
    }

    private void fireDocumentChangeAddedEvent(DocChange docChange) {
        Object[] objectArray = this.mRuntimeDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RuntimeDCListener)listenerObj).documentChangeAdded(docChange);
            ++n2;
        }
    }

    private void fireDocumentChangeUpdatedEvent(DocChange docChange) {
        Object[] objectArray = this.mRuntimeDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RuntimeDCListener)listenerObj).documentChangeUpdated(docChange);
            ++n2;
        }
    }

    private void firePastLogsReadEvent(List<Events> events) {
        Object[] objectArray = this.mRuntimeDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RuntimeDCListener)listenerObj).pastLogsRead(events);
            ++n2;
        }
    }

    private void fireDocumentChangeAmendedEvent(DocChange oldDocChange, DocChange newDocChange) {
        Object[] objectArray = this.mRuntimeDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RuntimeDCListener)listenerObj).documentChangeAmended(oldDocChange, newDocChange);
            ++n2;
        }
    }

    private void fireCodingEventOccurredEvent(ICommand command) {
        Object[] objectArray = this.mRuntimeDocumentChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listenerObj = objectArray[n2];
            ((RuntimeDCListener)listenerObj).codingEventOccurred(command);
            ++n2;
        }
    }

    public Set<FileKey> getFileKeys() {
        return this.mDocumentChanges.keySet();
    }

    public List<RuntimeDC> getRuntimeDocumentChanges() {
        return this.getRuntimeDocumentChanges(this.getCurrentFileKey());
    }

    public List<RuntimeDC> getRuntimeDocumentChanges(FileKey key) {
        if (this.mDocumentChanges.containsKey(key)) {
            return this.mDocumentChanges.get(key);
        }
        return null;
    }

    public List<RuntimeDC> getEntireHistory() {
        return Collections.unmodifiableList(this.mEntireHistory);
    }

    public String getCurrentFile() {
        if (this.mCurrentFileKey != null) {
            return this.mCurrentFileKey.getFilePath();
        }
        return null;
    }

    public String getCurrentProject() {
        if (this.mCurrentFileKey != null) {
            return this.mCurrentFileKey.getProjectName();
        }
        return null;
    }

    public FileKey getCurrentFileKey() {
        return this.mCurrentFileKey;
    }

    private void setCurrentFileKey(FileKey newFileKey) {
        this.mCurrentFileKey = newFileKey;
    }

    public List<ICommand> getEventsToBeDisplayed() {
        return Collections.unmodifiableList(this.mEventsToBeDisplayed);
    }

    public void activeFileChanged(FileOpenCommand foc) {
        this.processFileOpenCommand(foc);
        this.mCurrentSessionEvents.addCommand((ICommand)foc);
    }

    public void processFileOpenCommand(FileOpenCommand foc) {
        this.activeFileChanged(foc.getProjectName(), foc.getFilePath(), foc.getSnapshot());
        if (foc.getSnapshot() != null && foc.getPrevSnapshot() != null) {
            PastHistoryManager.getInstance().injectDiffDCs(this.getCurrentFileKey(), foc.getPrevSnapshot(), foc.getSnapshot(), foc.getSessionId(), foc.getTimestamp(), true, new IAddCommand(){

                @Override
                public void addCommand(ICommand command) {
                    if (command instanceof DocChange) {
                        DocChange docChange = (DocChange)command;
                        RuntimeHistoryManager.this.documentChanged(docChange);
                        RuntimeHistoryManager.this.documentChangeFinalized(docChange);
                    }
                }
            });
        }
    }

    public void activeFileChanged(String projectName, String filePath, String snapshot) {
        FileKey key = new FileKey(projectName, filePath);
        this.setCurrentFileKey(key);
        if (!this.mDocumentChanges.containsKey(key)) {
            this.mDocumentChanges.put(key, new ArrayList());
            this.mNextIndexToApply.put(key, 0);
        }
        this.fireActiveFileChangedEvent(key, snapshot);
    }

    public void documentChanged(DocChange docChange) {
        if (this.isEntireFileReplace(docChange)) {
            Replace replace = (Replace)docChange;
            if (!(replace.getDeletedText() == null || replace.getDeletedText().isEmpty() || replace.getInsertedText() == null || replace.getInsertedText().isEmpty() || replace.getDeletedText().equals(replace.getInsertedText()))) {
                PastHistoryManager.getInstance().injectDiffDCs(this.getCurrentFileKey(), replace.getDeletedText(), replace.getInsertedText(), replace.getSessionId(), replace.getTimestamp(), true, new IAddCommand(){

                    @Override
                    public void addCommand(ICommand command) {
                        if (command instanceof DocChange) {
                            DocChange docChange = (DocChange)command;
                            RuntimeHistoryManager.this.documentChanged(docChange);
                            RuntimeHistoryManager.this.documentChangeFinalized(docChange);
                        }
                    }
                });
            }
        } else {
            this.fireDocumentChangeAddedEvent(docChange);
            this.mCurrentSessionEvents.addCommand((ICommand)docChange);
        }
    }

    private boolean isEntireFileReplace(DocChange docChange) {
        return docChange instanceof Replace && ((Replace)docChange).isEntireFileChange();
    }

    public void documentChangeUpdated(DocChange docChange) {
        this.fireDocumentChangeUpdatedEvent(docChange);
    }

    public void documentChangeFinalized(DocChange docChange) {
        if (!this.isEntireFileReplace(docChange)) {
            this.addRuntimeDCFromOriginalDC(docChange);
        }
    }

    private void addRuntimeDCFromOriginalDC(DocChange docChange) {
        this.addRuntimeDCFromOriginalDC(docChange, this.getCurrentFileKey());
    }

    private void addRuntimeDCFromOriginalDC(DocChange docChange, FileKey key) {
        this.addRuntimeDCFromOriginalDC(docChange, key, true);
    }

    private void addRuntimeDCFromOriginalDC(DocChange docChange, FileKey key, boolean fireEvent) {
        RuntimeDC runtimeDC = RuntimeDC.createRuntimeDocumentChange(docChange);
        runtimeDC.setBelongsTo(key);
        List<RuntimeDC> list = this.getRuntimeDocumentChanges(key);
        if (list == null) {
            throw new IllegalArgumentException("Key does not exist!");
        }
        list.add(runtimeDC);
        this.mEntireHistory.add(runtimeDC);
        if (fireEvent) {
            this.fireRuntimeDCAddedEvent(runtimeDC);
        }
    }

    public List<RuntimeDC> filterDocumentChangesByIds(FileKey key, final List<OperationId> ids) {
        if (key == null || ids == null) {
            throw new IllegalArgumentException();
        }
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                return ids.contains(runtimeDC.getOperationId());
            }
        });
    }

    public List<RuntimeDC> filterDocumentChangesByIds(List<OperationId> ids) {
        return this.filterDocumentChangesByIds(this.getCurrentFileKey(), ids);
    }

    public RuntimeDC filterDocumentChangeById(FileKey key, final OperationId id) {
        if (key == null || id == null) {
            throw new IllegalArgumentException();
        }
        List<RuntimeDC> intermediateResult = this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                return id.equals(runtimeDC.getOperationId());
            }
        });
        if (intermediateResult == null || intermediateResult.isEmpty()) {
            return null;
        }
        return intermediateResult.get(0);
    }

    public List<RuntimeDC> filterDocumentChangesGreaterThanId(OperationId id) {
        return this.filterDocumentChangesGreaterThanId(this.getCurrentFileKey(), id);
    }

    public List<RuntimeDC> filterDocumentChangesGreaterThanId(FileKey key, final OperationId id) {
        if (key == null || id == null) {
            throw new IllegalArgumentException();
        }
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                return id.compareTo(runtimeDC.getOperationId()) < 0;
            }
        });
    }

    public List<RuntimeDC> filterDocumentChangesLaterThanTimestamp(long absTimestamp) {
        return this.filterDocumentChangesLaterThanTimestamp(this.getCurrentFileKey(), absTimestamp);
    }

    public List<RuntimeDC> filterDocumentChangesLaterThanTimestamp(FileKey key, final long absTimestamp) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                long timestamp = runtimeDC.getOriginal().getSessionId() + runtimeDC.getOriginal().getTimestamp();
                return absTimestamp < timestamp;
            }
        });
    }

    public List<RuntimeDC> filterDocumentChangesLaterThanOrEqualToTimestamp(long absTimestamp) {
        return this.filterDocumentChangesLaterThanOrEqualToTimestamp(this.getCurrentFileKey(), absTimestamp);
    }

    public List<RuntimeDC> filterDocumentChangesLaterThanOrEqualToTimestamp(FileKey key, final long absTimestamp) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                long timestamp = runtimeDC.getOriginal().getSessionId() + runtimeDC.getOriginal().getTimestamp();
                return absTimestamp <= timestamp;
            }
        });
    }

    public List<RuntimeDC> filterDocumentChangesEarlierThanTimestamp(long absTimestamp) {
        return this.filterDocumentChangesEarlierThanTimestamp(this.getCurrentFileKey(), absTimestamp);
    }

    public List<RuntimeDC> filterDocumentChangesEarlierThanTimestamp(FileKey key, final long absTimestamp) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                long timestamp = runtimeDC.getOriginal().getSessionId() + runtimeDC.getOriginal().getTimestamp();
                return absTimestamp > timestamp;
            }
        });
    }

    public List<RuntimeDC> filterDocumentChangesEarlierThanOrEqualToTimestamp(long absTimestamp) {
        return this.filterDocumentChangesEarlierThanOrEqualToTimestamp(this.getCurrentFileKey(), absTimestamp);
    }

    public List<RuntimeDC> filterDocumentChangesEarlierThanOrEqualToTimestamp(FileKey key, final long absTimestamp) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                long timestamp = runtimeDC.getOriginal().getSessionId() + runtimeDC.getOriginal().getTimestamp();
                return absTimestamp >= timestamp;
            }
        });
    }

    public List<RuntimeDC> filterDocumentChangesLaterThanOrEqualToAndEarlierThanTimestamps(long absTimestampStart, long absTimestampEnd) {
        return this.filterDocumentChangesLaterThanOrEqualToAndEarlierThanTimestamps(this.getCurrentFileKey(), absTimestampStart, absTimestampEnd);
    }

    public List<RuntimeDC> filterDocumentChangesLaterThanOrEqualToAndEarlierThanTimestamps(FileKey key, final long absTimestampStart, final long absTimestampEnd) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                long timestamp = runtimeDC.getOriginal().getSessionId() + runtimeDC.getOriginal().getTimestamp();
                return absTimestampStart <= timestamp && timestamp < absTimestampEnd;
            }
        });
    }

    public RuntimeDC filterDocumentChangeByIdWithoutCalculating(FileKey key, final OperationId id) {
        if (key == null || id == null) {
            throw new IllegalArgumentException();
        }
        List<RuntimeDC> intermediateResult = this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                return id.equals(runtimeDC.getOperationId());
            }
        }, false);
        if (intermediateResult == null || intermediateResult.isEmpty()) {
            return null;
        }
        return intermediateResult.get(0);
    }

    public List<RuntimeDC> filterDocumentChangesByRegion(int startOffset, int endOffset) {
        return this.filterDocumentChangesByRegion(this.getCurrentFileKey(), startOffset, endOffset);
    }

    public List<RuntimeDC> filterDocumentChangesByRegion(FileKey key, final int startOffset, final int endOffset) {
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                List<Segment> segments = runtimeDC.getAllSegments();
                for (Segment segment : segments) {
                    if (startOffset >= segment.getEffectiveEndOffset() || segment.getOffset() >= endOffset) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public List<RuntimeDC> filterDocumentChangesByRegionInclusive(int startOffset, int endOffset) {
        return this.filterDocumentChangesByRegionInclusive(this.getCurrentFileKey(), startOffset, endOffset);
    }

    public List<RuntimeDC> filterDocumentChangesByRegionInclusive(FileKey key, final int startOffset, final int endOffset) {
        return this.filterDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                List<Segment> segments = runtimeDC.getAllSegments();
                for (Segment segment : segments) {
                    if (startOffset > segment.getEffectiveEndOffset() || segment.getOffset() > endOffset) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public List<RuntimeDC> filterDocumentChanges(IRuntimeDCFilter filter) {
        return this.filterDocumentChanges(this.getCurrentFileKey(), filter);
    }

    public List<RuntimeDC> filterDocumentChanges(FileKey key, IRuntimeDCFilter filter) {
        return this.filterDocumentChanges(key, filter, true);
    }

    public List<RuntimeDC> filterDocumentChanges(FileKey key, IRuntimeDCFilter filter, boolean calculate) {
        if (key == null || filter == null) {
            throw new IllegalArgumentException();
        }
        EventRecorder.getInstance().fireLastDocumentChangeFinalizedEvent();
        List<RuntimeDC> list = calculate ? this.calculateDynamicSegments(key) : this.getRuntimeDocumentChanges(key);
        ArrayList<RuntimeDC> result = new ArrayList<RuntimeDC>();
        for (RuntimeDC dc : list) {
            if (!filter.filter(dc)) continue;
            result.add(dc);
        }
        return result;
    }

    public boolean hasDocumentChangesLaterThanTimestamp(long absTimestamp) {
        return this.hasDocumentChangesLaterThanTimestamp(this.getCurrentFileKey(), absTimestamp);
    }

    public boolean hasDocumentChangesLaterThanTimestamp(FileKey key, final long absTimestamp) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.hasDocumentChanges(key, new IRuntimeDCFilter(){

            @Override
            public boolean filter(RuntimeDC runtimeDC) {
                long timestamp = runtimeDC.getOriginal().getSessionId() + runtimeDC.getOriginal().getTimestamp();
                return absTimestamp < timestamp;
            }
        });
    }

    public boolean hasDocumentChanges(IRuntimeDCFilter filter) {
        return this.hasDocumentChanges(this.getCurrentFileKey(), filter);
    }

    public boolean hasDocumentChanges(FileKey key, IRuntimeDCFilter filter) {
        return this.hasDocumentChanges(key, filter, true);
    }

    public boolean hasDocumentChanges(FileKey key, IRuntimeDCFilter filter, boolean calculate) {
        if (key == null || filter == null) {
            throw new IllegalArgumentException();
        }
        EventRecorder.getInstance().fireLastDocumentChangeFinalizedEvent();
        List<RuntimeDC> list = calculate ? this.calculateDynamicSegments(key) : this.getRuntimeDocumentChanges(key);
        for (RuntimeDC dc : list) {
            if (!filter.filter(dc)) continue;
            return true;
        }
        return false;
    }

    public List<RuntimeDC> calculateDynamicSegments(FileKey fileKey) {
        List<RuntimeDC> list = this.getRuntimeDocumentChanges(fileKey);
        if (list == null) {
            throw new IllegalStateException();
        }
        int i = this.mNextIndexToApply.get(fileKey);
        while (i < list.size()) {
            int j = 0;
            while (j < i) {
                list.get(i).applyTo(list.get(j));
                ++j;
            }
            ++i;
        }
        this.mNextIndexToApply.put(fileKey, list.size());
        return list;
    }

    public void pastLogsRead(List<Events> listEvents) {
        this.clearData();
        ArrayList<Events> listAllEvents = new ArrayList<Events>();
        listAllEvents.addAll(PastHistoryManager.getInstance().getPastEvents());
        listAllEvents.add(this.mCurrentSessionEvents);
        for (Events events : listAllEvents) {
            List commands = events.getCommands();
            for (ICommand command : commands) {
                if (RuntimeHistoryManager.shouldCommandBeDisplayed(command)) {
                    this.mEventsToBeDisplayed.add(command);
                    continue;
                }
                if (!(command instanceof DocChange)) continue;
                DocChange docChange = (DocChange)command;
                if (docChange instanceof FileOpenCommand) {
                    this.processFileOpenCommand((FileOpenCommand)docChange);
                    continue;
                }
                this.processDocumentChange(docChange);
            }
            if (events == this.mCurrentSessionEvents || this.getOperationGrouper() == null) continue;
            this.getOperationGrouper().flushAllPendingChanges();
        }
        listAllEvents.remove(listAllEvents.size() - 1);
        this.firePastLogsReadEvent(listAllEvents);
    }

    private void processDocumentChange(DocChange docChange) {
        if (docChange instanceof IDiffDC) {
            this.addRuntimeDCFromOriginalDC(docChange, ((IDiffDC)docChange).getFileKey());
        } else {
            this.addRuntimeDCFromOriginalDC(docChange);
        }
    }

    public Map<FileKey, List<RuntimeDC>> extractFileDCMapFromOperationIds(List<OperationId> ids) {
        Set<FileKey> fileKeys = this.getFileKeys();
        HashMap<FileKey, List<RuntimeDC>> params = new HashMap<FileKey, List<RuntimeDC>>();
        for (FileKey key : fileKeys) {
            List<RuntimeDC> filteredIds = this.filterDocumentChangesByIds(key, ids);
            if (filteredIds.size() == 0) continue;
            params.put(key, filteredIds);
        }
        return params;
    }

    public static boolean shouldCommandBeDisplayed(ICommand command) {
        String type = command instanceof ITypeOverridable ? ((ITypeOverridable)command).getTypeForDisplay() : command.getCommandType();
        return RuntimeHistoryManager.getTimelineEvents().contains(type);
    }

    public void commandExecuted(ICommand command) {
        if (RuntimeHistoryManager.shouldCommandBeDisplayed(command)) {
            this.mCurrentSessionEvents.addCommand(command);
            this.mEventsToBeDisplayed.add(command);
            EventRecorder.getInstance().fireLastDocumentChangeFinalizedEvent();
            this.fireCodingEventOccurredEvent(command);
        }
    }

    public void documentChangeAmended(DocChange oldDocChange, DocChange newDocChange) {
        List<RuntimeDC> dcs = this.getRuntimeDocumentChanges();
        if (dcs == null || dcs.isEmpty()) {
            throw new IllegalStateException("Could not find the runtimeDC associated with the oldDocChange.");
        }
        RuntimeDC candidateDC = dcs.get(dcs.size() - 1);
        if (candidateDC.getOriginal() != oldDocChange) {
            throw new IllegalStateException("The last runtime DC is not the desired one!");
        }
        if (this.mNextIndexToApply.get(this.getCurrentFileKey()) >= dcs.size()) {
            throw new IllegalStateException("The dynamic segment calculation is already done!");
        }
        dcs.remove(dcs.size() - 1);
        this.mEntireHistory.remove(this.mEntireHistory.size() - 1);
        this.addRuntimeDCFromOriginalDC(newDocChange, this.getCurrentFileKey(), false);
        int oldIndex = this.mCurrentSessionEvents.getCommands().indexOf(oldDocChange);
        this.mCurrentSessionEvents.getCommands().set(oldIndex, newDocChange);
        this.fireDocumentChangeAmendedEvent(oldDocChange, newDocChange);
    }

    public OperationGrouper getOperationGrouper() {
        return this.mOperationGrouper;
    }
}

