/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model;

import edu.cmu.scs.azurite.commands.diff.DiffDelete;
import edu.cmu.scs.azurite.commands.diff.DiffInsert;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.IAddCommand;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.fluorite.commands.AbstractCommand;
import edu.cmu.scs.fluorite.commands.FileOpenCommand;
import edu.cmu.scs.fluorite.commands.ICommand;
import edu.cmu.scs.fluorite.commands.document.DocChange;
import edu.cmu.scs.fluorite.commands.document.Replace;
import edu.cmu.scs.fluorite.model.DocumentChangeListener;
import edu.cmu.scs.fluorite.model.EventRecorder;
import edu.cmu.scs.fluorite.model.Events;
import edu.cmu.scs.fluorite.util.LogReader;
import edu.cmu.scs.fluorite.util.Utilities;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import name.fraser.neil.plaintext.diff_match_patch;
import name.fraser.neil.plaintext.diff_match_patch_ext;

public class PastHistoryManager
implements DocumentChangeListener {
    private Deque<Events> mPastEvents = new LinkedList<Events>();
    Map<FileKey, SnapshotElement> mInitialSnapshots = new HashMap<FileKey, SnapshotElement>();
    private static PastHistoryManager _instance;

    private PastHistoryManager() {
    }

    public static PastHistoryManager getInstance() {
        if (_instance == null) {
            _instance = new PastHistoryManager();
        }
        return _instance;
    }

    public Deque<Events> getPastEvents() {
        return this.mPastEvents;
    }

    public int readPastLogs(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count should be positive!");
        }
        File logLocation = null;
        try {
            logLocation = Utilities.getLogLocation();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!logLocation.isDirectory()) {
            throw new IllegalStateException("Log location is not a directory!");
        }
        long currentStartTimestamp = EventRecorder.getInstance().getStartTimestamp();
        if (this.mPastEvents.size() > 0) {
            currentStartTimestamp = this.mPastEvents.peekFirst().getStartTimestamp();
        }
        final String currentLogName = Utilities.getUniqueLogNameByTimestamp((long)currentStartTimestamp, (boolean)false);
        File[] logFiles = logLocation.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.endsWith(".xml") && name.compareTo(currentLogName) < 0;
            }
        });
        Arrays.sort(logFiles, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
        File[] logFilesToRead = logFiles;
        if (logFiles.length >= count) {
            logFilesToRead = Arrays.copyOfRange(logFiles, logFiles.length - count, logFiles.length);
        }
        this.readPastLogs(logFilesToRead);
        return logFilesToRead.length;
    }

    public void readPastLogs(File[] logFilesToRead) {
        ArrayList<Events> tempEvents = new ArrayList<Events>();
        LogReader reader = new LogReader();
        File[] fileArray = logFilesToRead;
        int n = logFilesToRead.length;
        int n2 = 0;
        while (n2 < n) {
            File logFile = fileArray[n2];
            Events events = reader.readAll(logFile.getAbsolutePath());
            if (events != null) {
                tempEvents.add(events);
            }
            ++n2;
        }
        if (!tempEvents.isEmpty()) {
            Collections.reverse(tempEvents);
            for (Events events : tempEvents) {
                this.processEvents(events);
            }
            RuntimeHistoryManager.getInstance().pastLogsRead(tempEvents);
        }
    }

    private void processEvents(Events events) {
        HashMap<FileKey, SnapshotElement> localInitialSnapshots = new HashMap<FileKey, SnapshotElement>();
        HashMap<FileKey, String> localFinalSnapshots = new HashMap<FileKey, String>();
        FileKey curFileKey = null;
        final Events copyEvents = new Events(Collections.emptyList(), "", Long.toString(events.getStartTimestamp()), "", events.getStartTimestamp());
        final IntegerContainer insertedCount = new IntegerContainer();
        insertedCount.value = 0;
        for (ICommand command : events.getCommands()) {
            Replace replace;
            command.setCommandIndex(command.getCommandIndex() + insertedCount.value);
            copyEvents.addCommand(command);
            if (!(command instanceof DocChange)) continue;
            if (command instanceof FileOpenCommand) {
                final FileOpenCommand foc = (FileOpenCommand)command;
                FileKey key = new FileKey(foc.getProjectName(), foc.getFilePath());
                if (!localInitialSnapshots.containsKey(key)) {
                    SnapshotElement elem = new SnapshotElement(foc.getSessionId(), foc.getTimestamp(), foc.getSnapshot());
                    localInitialSnapshots.put(key, elem);
                    localFinalSnapshots.put(key, foc.getSnapshot());
                }
                curFileKey = key;
                String knownFinalSnapshot = (String)localFinalSnapshots.get(curFileKey);
                if (foc.getSnapshot() != null && knownFinalSnapshot != null && !foc.getSnapshot().equals(knownFinalSnapshot)) {
                    this.injectDiffDCs(curFileKey, knownFinalSnapshot, foc.getSnapshot(), foc.getSessionId(), foc.getTimestamp(), false, new IAddCommand(){

                        @Override
                        public void addCommand(ICommand command) {
                            ++insertedCount.value;
                            command.setCommandIndex(foc.getCommandIndex() + insertedCount.value);
                            copyEvents.addCommand(command);
                        }
                    });
                }
            }
            DocChange docChange = (DocChange)command;
            String originalContent = (String)localFinalSnapshots.get(curFileKey);
            if (originalContent != null || docChange instanceof FileOpenCommand) {
                String updatedContent = docChange.apply(originalContent);
                localFinalSnapshots.put(curFileKey, updatedContent);
            }
            if (originalContent == null || !(docChange instanceof Replace) || (replace = (Replace)docChange).getOffset() != 0 || replace.getLength() != originalContent.length()) continue;
            replace.setEntireFileChange(true);
            copyEvents.removeLastCommand();
            if (replace.getDeletedText() == null || replace.getDeletedText().isEmpty() || replace.getInsertedText() == null || replace.getInsertedText().isEmpty() || replace.getDeletedText().equals(replace.getInsertedText())) continue;
            PastHistoryManager.getInstance().injectDiffDCs(curFileKey, replace.getDeletedText(), replace.getInsertedText(), replace.getSessionId(), replace.getTimestamp(), false, new IAddCommand(){

                @Override
                public void addCommand(ICommand command) {
                    ++insertedCount.value;
                    command.setCommandIndex(replace.getCommandIndex() + insertedCount.value);
                    copyEvents.addCommand(command);
                }
            });
        }
        this.injectDiffDCsWhileReadingPreviousLog(copyEvents, localInitialSnapshots, localFinalSnapshots);
        for (FileKey key : localInitialSnapshots.keySet()) {
            if (!this.mInitialSnapshots.containsKey(key)) {
                this.mInitialSnapshots.put(key, (SnapshotElement)localInitialSnapshots.get(key));
                continue;
            }
            SnapshotElement elem = this.mInitialSnapshots.get(key);
            SnapshotElement localElem = (SnapshotElement)localInitialSnapshots.get(key);
            elem.setSessionId(localElem.getSessionId());
            elem.setTimestamp(localElem.getTimestamp());
            elem.setSnapshot(localElem.getSnapshot());
        }
        this.mPastEvents.addFirst(copyEvents);
    }

    public void injectDiffDCs(FileKey key, String before, String after, long sessionId, long timestamp, boolean autoAssignId, IAddCommand addCommand) {
        if (before == null || after == null) {
            throw new IllegalArgumentException("Cannot process null strings.");
        }
        diff_match_patch_ext dmp = new diff_match_patch_ext();
        LinkedList<diff_match_patch.Diff> diffs = dmp.diff_lines_only(before, after);
        int curOffset = 0;
        int curLength = before.length();
        boolean incrementCommandID = AbstractCommand.getIncrementCommandID();
        try {
            if (!autoAssignId) {
                AbstractCommand.setIncrementCommandID((boolean)false);
            }
            int count = 0;
            for (diff_match_patch.Diff diff : diffs) {
                if (diff.operation != diff_match_patch.Operation.INSERT && diff.operation != diff_match_patch.Operation.DELETE) continue;
                ++count;
            }
            for (diff_match_patch.Diff diff : diffs) {
                switch (diff.operation) {
                    case INSERT: {
                        DiffInsert di = new DiffInsert(key, curOffset, diff.text, null);
                        di.setSessionId(sessionId);
                        di.setTimestamp(timestamp - (long)count);
                        di.setTimestamp2(timestamp - (long)count + 1L);
                        --count;
                        curOffset += diff.text.length();
                        di.setDocLength(curLength += diff.text.length());
                        addCommand.addCommand((ICommand)di);
                        break;
                    }
                    case DELETE: {
                        DiffDelete dd = new DiffDelete(key, curOffset, diff.text.length(), -1, -1, diff.text, null);
                        dd.setSessionId(sessionId);
                        dd.setTimestamp(timestamp - (long)count);
                        dd.setTimestamp2(timestamp - (long)count + 1L);
                        --count;
                        dd.setDocLength(curLength -= diff.text.length());
                        addCommand.addCommand((ICommand)dd);
                        break;
                    }
                    case EQUAL: {
                        curOffset += diff.text.length();
                    }
                }
            }
        }
        finally {
            AbstractCommand.setIncrementCommandID((boolean)incrementCommandID);
        }
    }

    private void injectDiffDCsWhileReadingPreviousLog(final Events events, Map<FileKey, SnapshotElement> localInitialSnapshots, Map<FileKey, String> localFinalSnapshots) {
        for (FileKey key : localInitialSnapshots.keySet()) {
            if (!this.mInitialSnapshots.containsKey(key)) continue;
            String finalContent = localFinalSnapshots.get(key);
            SnapshotElement elem = this.mInitialSnapshots.get(key);
            if (elem.getSnapshot() == null || finalContent == null || elem.getSnapshot().equals(finalContent)) continue;
            long t = elem.getSessionId() + elem.getTimestamp() - events.getStartTimestamp();
            this.injectDiffDCs(key, finalContent, elem.getSnapshot(), events.getStartTimestamp(), t, false, new IAddCommand(){

                @Override
                public void addCommand(ICommand command) {
                    ICommand lastCommand = (ICommand)events.getCommands().get(events.getCommands().size() - 1);
                    command.setCommandIndex(lastCommand.getCommandIndex() + 1);
                    events.addCommand(command);
                }
            });
        }
    }

    public void activeFileChanged(FileOpenCommand foc) {
        FileKey key = new FileKey(foc.getProjectName(), foc.getFilePath());
        if (!this.mInitialSnapshots.containsKey(key)) {
            SnapshotElement elem = new SnapshotElement(foc.getSessionId(), foc.getTimestamp(), foc.getSnapshot());
            this.mInitialSnapshots.put(key, elem);
        }
    }

    public void documentChanged(DocChange docChange) {
    }

    public void documentChangeFinalized(DocChange docChange) {
    }

    public void documentChangeUpdated(DocChange docChange) {
    }

    public void documentChangeAmended(DocChange oldDocChange, DocChange newDocChange) {
    }

    class IntegerContainer {
        public int value;

        IntegerContainer() {
        }
    }

    class SnapshotElement {
        private long mSessionId;
        private long mTimestamp;
        private String mSnapshot;

        public SnapshotElement(long sessionId, long timestamp, String snapshot) {
            this.mSessionId = sessionId;
            this.mTimestamp = timestamp;
            this.mSnapshot = snapshot;
        }

        public long getSessionId() {
            return this.mSessionId;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }

        public String getSnapshot() {
            return this.mSnapshot;
        }

        public void setSessionId(long sessionId) {
            this.mSessionId = sessionId;
        }

        public void setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
        }

        public void setSnapshot(String snapshot) {
            this.mSnapshot = snapshot;
        }
    }
}

