/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.jface.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandAction
extends Action {
    private Map<String, String> parameters;

    public CommandAction(String text, String commandId) {
        this(text, commandId, null);
    }

    public CommandAction(String text, String commandId, Map<String, String> parameters) {
        this.setText(text);
        this.setActionDefinitionId(commandId);
        this.parameters = parameters == null ? null : new HashMap<String, String>(parameters);
    }

    public void run() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (this.parameters != null) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = commandService.getCommand(this.getActionDefinitionId());
            ArrayList<Parameterization> paramList = new ArrayList<Parameterization>();
            try {
                IParameter[] iParameterArray = command.getParameters();
                int n = iParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameter param = iParameterArray[n2];
                    if (this.parameters.containsKey(param.getId())) {
                        paramList.add(new Parameterization(param, this.parameters.get(param.getId())));
                    } else {
                        paramList.add(new Parameterization(param, null));
                    }
                    ++n2;
                }
            }
            catch (NotDefinedException notDefinedException) {}
            ParameterizedCommand paramCmd = new ParameterizedCommand(command, paramList.toArray(new Parameterization[0]));
            try {
                handlerService.executeCommand(paramCmd, null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                e.printStackTrace();
            }
        } else {
            try {
                handlerService.executeCommand(this.getActionDefinitionId(), null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                e.printStackTrace();
            }
        }
    }
}

