/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model;

import java.nio.file.Path;
import java.nio.file.Paths;

public class FileKey {
    private final String mProjectName;
    private final Path mFilePath;

    public FileKey(String projectName, String filePath) {
        this.mProjectName = projectName;
        this.mFilePath = filePath == null ? null : Paths.get(filePath, new String[0]);
    }

    public String getProjectName() {
        return this.mProjectName;
    }

    public String getFilePath() {
        return this.mFilePath == null ? null : this.mFilePath.toString();
    }

    public String getFileNameOnly() {
        String filePath = this.getFilePath();
        return filePath == null ? null : Paths.get(filePath, new String[0]).getFileName().toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mFilePath == null ? 0 : this.mFilePath.hashCode());
        result = 31 * result + (this.mProjectName == null ? 0 : this.mProjectName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileKey other = (FileKey)obj;
        if (this.mFilePath == null ? other.mFilePath != null : !this.mFilePath.equals(other.mFilePath)) {
            return false;
        }
        return !(this.mProjectName == null ? other.mProjectName != null : !this.mProjectName.equals(other.mProjectName));
    }

    public String toString() {
        return "ProjectName: " + this.getProjectName() + "\tFilePath: " + this.getFilePath();
    }
}

