/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.actions;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.model.undo.SelectiveUndoEngine;
import edu.cmu.scs.fluorite.util.Utilities;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class UndoInRegionAction
implements IObjectActionDelegate {
    public void run(IAction action) {
        try {
            ISelectionProvider selectionProvider;
            IEditorPart editorPart = Utilities.getActiveEditor();
            if (!(editorPart instanceof AbstractTextEditor)) {
                return;
            }
            int offset = 0;
            int length = 0;
            IEditorSite iEditorSite = editorPart.getEditorSite();
            if (iEditorSite != null && (selectionProvider = iEditorSite.getSelectionProvider()) != null) {
                ISelection iSelection = selectionProvider.getSelection();
                offset = ((ITextSelection)iSelection).getOffset();
                if (!iSelection.isEmpty()) {
                    length = ((ITextSelection)iSelection).getLength();
                }
            }
            ITextEditor editor = (ITextEditor)editorPart;
            IDocumentProvider dp = editor.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)editor.getEditorInput());
            List<RuntimeDC> dcs = RuntimeHistoryManager.getInstance().filterDocumentChangesByRegion(offset, offset + length);
            SelectiveUndoEngine.getInstance().doSelectiveUndo(dcs, doc);
        }
        catch (Exception exception) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

