/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.model.undo;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.commands.runtime.Segment;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.undo.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class Chunk
extends ArrayList<Segment> {
    private static Comparator<Chunk> locationComparator;

    public Chunk() {
    }

    public Chunk(Collection<? extends Segment> c) {
        super(c);
    }

    public int getStartOffset() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return ((Segment)this.get(0)).getOffset();
    }

    public int getEndOffset() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        Segment last = (Segment)this.get(this.size() - 1);
        return last.getEffectiveEndOffset();
    }

    public int getChunkLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public boolean hasConflictOutsideThisChunk() {
        List<RuntimeDC> involvedDCs = this.getInvolvedChanges();
        for (RuntimeDC dc : involvedDCs) {
            List<RuntimeDC> conflicts = dc.getConflicts();
            for (RuntimeDC conflict : conflicts) {
                if (involvedDCs.contains(conflict)) continue;
                return true;
            }
        }
        return false;
    }

    public Chunk getExpandedChunkInRange() {
        Chunk result = new Chunk();
        LinkedList<RuntimeDC> queue = new LinkedList<RuntimeDC>(this.getInvolvedChanges());
        HashSet<RuntimeDC> set = new HashSet<RuntimeDC>();
        while (!queue.isEmpty()) {
            RuntimeDC dc = (RuntimeDC)queue.remove();
            if (!this.isInRange(dc, this.getStartOffset(), this.getEndOffset()) || set.contains(dc)) continue;
            set.add(dc);
            result.addAll(dc.getAllSegments());
            for (RuntimeDC conflict : dc.getConflicts()) {
                if (set.contains(conflict)) continue;
                queue.add(conflict);
            }
        }
        Collections.sort(result, Segment.getLocationComparator());
        return result;
    }

    public Chunk getExpandedChunkWithDepth(int depth) {
        Chunk result = new Chunk();
        LinkedList<Pair<RuntimeDC, Integer>> queue = new LinkedList<Pair<RuntimeDC, Integer>>();
        for (RuntimeDC dc : this.getInvolvedChanges()) {
            queue.add(new Pair<RuntimeDC, Integer>(dc, 0));
        }
        HashSet<RuntimeDC> set = new HashSet<RuntimeDC>();
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.remove();
            RuntimeDC dc = (RuntimeDC)pair.getFirst();
            if (set.contains(dc)) continue;
            set.add(dc);
            result.addAll(dc.getAllSegments());
            if (depth != -1 && ((Integer)pair.getSecond()).compareTo(depth) >= 0) continue;
            for (RuntimeDC conflict : dc.getConflicts()) {
                if (set.contains(conflict)) continue;
                queue.add(new Pair<RuntimeDC, Integer>(conflict, (Integer)pair.getSecond() + 1));
            }
        }
        Collections.sort(result, Segment.getLocationComparator());
        return result;
    }

    private boolean isInRange(RuntimeDC runtimeDC, int startOffset, int endOffset) {
        if (runtimeDC == null) {
            throw new IllegalArgumentException();
        }
        List<Segment> segments = runtimeDC.getAllSegments();
        if (segments.isEmpty()) {
            return false;
        }
        Segment first = segments.get(0);
        Segment last = segments.get(segments.size() - 1);
        return startOffset <= first.getOffset() && last.getEffectiveEndOffset() <= endOffset;
    }

    public List<RuntimeDC> getInvolvedChanges() {
        TreeSet<RuntimeDC> set = new TreeSet<RuntimeDC>(RuntimeDC.getCommandIDComparator());
        for (Segment segment : this) {
            set.add(segment.getOwner());
        }
        return Collections.unmodifiableList(new ArrayList<RuntimeDC>(set));
    }

    public Chunk copyChunk() {
        Chunk copyChunk = new Chunk();
        for (Segment originalSegment : this) {
            copyChunk.add(originalSegment.copySegment());
        }
        int i = 0;
        while (i < this.size()) {
            Segment originalSegment = (Segment)this.get(i);
            Segment copySegment = (Segment)copyChunk.get(i);
            for (Segment closedSegment : originalSegment.getSegmentsClosedByMe()) {
                int closedSegmentIndex = this.indexOf(closedSegment);
                if (closedSegmentIndex == -1) continue;
                copySegment.addSegmentClosedByMe((Segment)copyChunk.get(closedSegmentIndex));
            }
            for (Segment right : originalSegment.getRight()) {
                int rightIndex = this.indexOf(right);
                if (rightIndex == -1) continue;
                copySegment.addRight((Segment)copyChunk.get(rightIndex));
            }
            ++i;
        }
        return copyChunk;
    }

    public FileKey getBelongsTo() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return ((Segment)this.get(0)).getOwner().getBelongsTo();
    }

    public static Comparator<Chunk> getLocationComparator() {
        if (locationComparator == null) {
            locationComparator = new Comparator<Chunk>(){

                @Override
                public int compare(Chunk lhs, Chunk rhs) {
                    if (lhs.getStartOffset() < rhs.getStartOffset()) {
                        return -1;
                    }
                    if (lhs.getStartOffset() > rhs.getStartOffset()) {
                        return 1;
                    }
                    if (lhs.getEndOffset() < rhs.getEndOffset()) {
                        return -1;
                    }
                    if (lhs.getEndOffset() > rhs.getEndOffset()) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
        return locationComparator;
    }

    public static Chunk fromDCList(List<RuntimeDC> dcs) {
        Chunk chunk = new Chunk();
        for (RuntimeDC dc : dcs) {
            chunk.addAll(dc.getAllSegments());
        }
        Collections.sort(chunk, Segment.getLocationComparator());
        return chunk;
    }

    public static Chunk fromDCList(List<RuntimeDC> dcs, int startOffset, int endOffset) {
        Chunk chunk = new Chunk();
        for (RuntimeDC dc : dcs) {
            for (Segment segment : dc.getAllSegments()) {
                if (!segment.inSelectionRange(startOffset, endOffset)) continue;
                chunk.add(segment);
            }
        }
        Collections.sort(chunk, Segment.getLocationComparator());
        return chunk;
    }
}

