/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.scs.azurite.ui.handlers;

import edu.cmu.scs.azurite.commands.runtime.RuntimeDC;
import edu.cmu.scs.azurite.model.FileKey;
import edu.cmu.scs.azurite.model.OperationId;
import edu.cmu.scs.azurite.model.RuntimeHistoryManager;
import edu.cmu.scs.azurite.views.TimelineViewPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class SelectAllOutsideHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        long absTimestampEnd;
        TimelineViewPart timelineViewPart = TimelineViewPart.getInstance();
        if (timelineViewPart == null) {
            return null;
        }
        long absTimestampStart = timelineViewPart.getTimeRangeStart();
        if (absTimestampStart > (absTimestampEnd = timelineViewPart.getTimeRangeEnd())) {
            long temp = absTimestampStart;
            absTimestampStart = absTimestampEnd;
            absTimestampEnd = temp;
        }
        ArrayList<RuntimeDC> dcs = new ArrayList<RuntimeDC>();
        RuntimeHistoryManager manager = RuntimeHistoryManager.getInstance();
        for (FileKey key : manager.getFileKeys()) {
            dcs.addAll(manager.filterDocumentChangesLaterThanOrEqualToTimestamp(key, absTimestampEnd));
            dcs.addAll(manager.filterDocumentChangesEarlierThanTimestamp(key, absTimestampStart));
        }
        List<OperationId> ids = OperationId.getOperationIdsFromRuntimeDCs(dcs);
        timelineViewPart.addSelection(ids, true);
        return null;
    }
}

